<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('suaras',function (Blueprint $table){
            $table->enum('status',['pending','approve','reject'])->default('pending')->after('suara_tidak_sah');
        });

        Schema::table('file_lampirans',function (Blueprint $table){
            $table->enum('status',['pending','approve','reject'])->default('pending')->after('file');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('suaras',function (Blueprint $table){
            $table->dropColumn('status');
        });

        Schema::table('file_lampirans',function (Blueprint $table){
            $table->dropColumn('status');
        });
    }
};
