<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suara_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('suara_id')->index();
            $table->unsignedBigInteger('calon_id')->index();
            $table->integer('jumlah_suara',false);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('suara_id')->references('id')->on('suaras')->onDelete('cascade');
            $table->foreign('calon_id')->references('id')->on('calons')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suara_details');
    }
};
