<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dps', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tps_id')->index();

            $table->string('nik',16)->nullable();
            $table->string('nama',150);
            $table->enum('jenis_kelamin',['L','P']);
            $table->integer('usia',false);
            $table->string('rt',3)->nullable();
            $table->string('rw',3)->nullable();
            $table->text('alamat')->nullable();
            $table->text('ket')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['created_at','deleted_at']);

            $table->foreign('tps_id')->references('id')->on('tps')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dps');
    }
};
