<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kelurahan_desaables', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('kelurahan_desa_id')->index();
            $table->foreign('kelurahan_desa_id')->references('id')->on('kelurahan_desas')->onDelete('cascade');
            $table->unsignedBigInteger('kelurahan_desaables_id')->index();
            $table->string('kelurahan_desaables_type');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kelurahan_desaables');
    }
};
