<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tps', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('kelurahan_desa_id')->index();
            $table->integer('nomor',false);
            $table->string('rt_rw');
            $table->string('alamat')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('kelurahan_desa_id')->references('id')->on('kelurahan_desas')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tps');
    }
};
