<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('no_telp',20)->unique();
            $table->string('password');
            $table->string('email')->nullable();
            $table->string('no_kk',20)->nullable();
            $table->string( 'no_wa',20)->nullable();
            $table->enum('role',['admin','koordinator-provinsi','koordinator-kabupaten-kota','koordinator-kecamatan','koordinator-kelurahan-desa','saksi'])->default('saksi');
            $table->unsignedBigInteger('provinsi_id')->index()->nullable();
            $table->unsignedBigInteger('kabupaten_kota_id')->index()->nullable();
            $table->unsignedBigInteger('kecamatan_id')->index()->nullable();
            $table->unsignedBigInteger('kelurahan_desa_id')->index()->nullable();
            $table->unsignedBigInteger('tps_id')->index()->nullable();
            $table->unsignedBigInteger('dps_id')->index()->nullable();
            $table->enum('status',['sesuai','tidak sesuai','sudah ada'])->default('sesuai');
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
