<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserLog extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'message',
        'ip_address',
        'data'
    ];

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault([
            'nama' => 'Tidak Ada',
            'no_wa' => '-',
            'tps' => [
                'nomor' => 'Tidak Ada',
                'kelurahan_desa' => [
                    'nama' => 'Tidak Ada'
                ]
            ]
        ]);
    }
}
