<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pelatih extends Model
{
    use HasFactory;
    protected $fillable = [
        'nama',
        'no_wa',
        'email',
        'nik',
        'provinsi_id',
        'kabupaten_kota_id',
        'kecamatan_id',
        'kelurahan_desa_id'
    ];

    public function provinsi(){
        return $this->belongsTo(Provinsi::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kabupaten_kota(){
        return $this->belongsTo(KabupatenKota::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kecamatan(){
        return $this->belongsTo(Kecamatan::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kelurahan_desa(){
        return $this->belongsTo(KelurahanDesa::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }
}
