<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LaporanPelatihan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'tanggal_kegiatan',
        'uraian_kegiatan',
        'lokasi',
        'file_absensi',
        'file_dokumentasi',
        'file_anggaran'
    ];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function getListFileAbsensiAttribute(){
        if($this->file_absensi == ""){
            return [];
        }
        return explode(';',$this->file_absensi);
    }

    public function getListFileDokumentasiAttribute(){
        if($this->file_dokumentasi == ""){
            return [];
        }
        return explode(';',$this->file_dokumentasi);
    }

    public function getListFileAnggaranAttribute(){
        if($this->file_anggaran == ""){
            return [];
        }
        return explode(';',$this->file_anggaran);
    }
}
