<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Str;

class KelurahanDesa extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'nama',
        'kecamatan_id'
    ];

    public function kecamatan()
    {
        return $this->belongsTo(Kecamatan::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function tps(){
        return $this->hasMany(Tps::class);
    }

    public function users(){
        return $this->hasMany(User::class);
    }

    public function getNamaSlugAttribute(){
        return Str::slug($this->nama);
    }

    public function koordinators(){
        return $this->hasMany(User::class,'kelurahan_desa_id')->where('role','koordinator-kelurahan-desa');
    }
}
