<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Str;

class KabupatenKota extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = [
        'nama',
        'provinsi_id'
    ];

    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class)->withDefault([
            'nama'=>'Tidak Ada'
        ]);
    }

    public function kecamatans(){
        return $this->hasMany(Kecamatan::class);
    }

    public function getNamaSlugAttribute(){
        return Str::slug($this->nama);
    }

    public function koordinators(){
        return $this->hasMany(User::class,'kabupaten_kota_id')->where('role','koordinator-kabupaten-kota');
    }
}
