<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dpt extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'dpt';
    protected $fillable = [
        'nama',
        'jenis_kelamin',
        'usia',
        'rt',
        'rw',
        'alamat',
        'ket',
        'nik',
        'no_kk',
        'tps_id'
    ];

    public function tps(){
        return $this->belongsTo(Tps::class);
    }

    public function users(){
        return $this->hasMany(User::class);
    }
}
