<?php

namespace App\Imports;

use App\Models\Pelatih;
use App\Models\Provinsi;
use Exception;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithCalculatedFormulas;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class PelatihsImport implements ToModel, WithMultipleSheets, WithCalculatedFormulas
{   
    public $provinsis;

    public function __construct($provinsis)
    {   
       $this->provinsis = $provinsis;
    }

    public function sheets(): array
    {
        return [
            0 => $this,
        ];
    }

    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {   
        if (!isset($row[0]) || strtolower($row[0]) == "nama" || $row[0] == "" || !isset($row[4]) || $row[4] == "") {
            return null;
        }
        $provinsi = $this->provinsis->where('nama', $row[3])->first();
        if (!$provinsi) {
            throw new Exception("Provinsi Not Found : " . $row[3]);

        }

        $kabupatenKota = $provinsi->kabupaten_kotas->where('nama', $row[4])->first();
        if (!$kabupatenKota) {
            throw new Exception("Kabupaten/Kota Not Found : " . $row[4]);
        }

        $kecamatan = $kabupatenKota->kecamatans->where('nama', $row[5])->first();
        $kelurahanDesa = null;
        if ($kecamatan) {
            $kelurahanDesa = $kecamatan->kelurahan_desas->where('nama', $row[6])->first();
        }

        

        $no_wa = str_replace("'", "", $row[1]);
        //remove all symbol and alphabet from $no_wa
        $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);

        //check if first character is 62
        if (substr($no_wa, 0, 2) === '62') {
            $no_wa = '0' . substr($no_wa, 2);
        }

        //check if first character not 0
        if (mb_substr($no_wa, 0, 1) != '0') {
            $no_wa = '0' . $no_wa;
        }
        return new Pelatih([
            'nama' => $row[0],
            'no_wa' => $no_wa,
            'email' => $row[2],
            'provinsi_id' => $provinsi->id,
            'kabupaten_kota_id' => $kabupatenKota->id,
            'kecamatan_id' => @$kecamatan->id,
            'kelurahan_desa_id' => @$kelurahanDesa->id,
        ]);
    }
}
