<?php

namespace App\Imports;

use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Tps;
use DateTime;
use Error;
use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Maatwebsite\Excel\Concerns\ToModel;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;

class DptImport implements ToModel, WithChunkReading,ShouldQueue
{   
    public $metode = "1";
    public $kabupaten_kota_id = 0;
    public $tps = 0;
    public $kelurahan_desa_id = 0;
    private function normalizeKota($kota){
        $kota = strtolower($kota);
        $newKota = strtoupper($kota);
        switch ($kota) {
            case 'balikpapan':
                $newKota = "KOTA BALIKPAPAN";
                break;
            case 'samarinda':
                $newKota = "KOTA SAMARINDA";
                break;
            case 'bontang':
                $newKota = "KOTA BONTANG";
                break;
            case 'ppu':
                $newKota = "KAB. PENAJAM PASER UTARA";
                break;
            case 'paser':
                $newKota = "KAB. PASER";
                break;
            case 'kukar':
                $newKota = "KAB. KUTAI KARTANEGARA";
                break;
            case 'kubar':
                $newKota = "KAB. KUTAI BARAT";
                break;
            case 'kutim':
                $newKota = "KAB. KUTAI TIMUR";
                break;
            case 'berau':
                $newKota = "KAB. BERAU";
                break;
            case 'mahulu':
                $newKota = "KAB. MAHAKAM ULU";
                break;
            default:
                # code...
                break;
        }
        return $newKota;
    }

    function getAgeFromDate($dateString) {
        $dateString = str_replace('|', '-', $dateString);
        $birthDate = DateTime::createFromFormat('d-m-Y', $dateString);
        if(!$birthDate && is_numeric($dateString)){
            $birthDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($dateString);
        }
        if(!$birthDate){
            return null;
        }

        $currentDate = new DateTime("27-11-2024");
        
        $age = $currentDate->diff($birthDate)->y;
        
        return $age;
    }

    private function metode_1(array $row){
        if(strtolower($row[0]) == 'no' && !isset($row[9]) && ($row[9] == '' || $row[9] == null) || !isset($row[2]) || $row[2] == null){
            return;
        }
        $kabKota = KabupatenKota::where('nama',$this->normalizeKota($row[12]))->first();
        if(!$kabKota){
            return;
        }
        $kecamatan = Kecamatan::where('nama',$row[11])->where('kabupaten_kota_id',$kabKota->id)->first();
        if(!$kecamatan){
            $kecamatan = Kecamatan::create([
                'nama'=>$row[11],
                'kabupaten_kota_id'=>$kabKota->id,
            ]);
        }
        $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama',$row[10])->first();
        if(!$kelurahanDesa){
            $kelurahanDesa = KelurahanDesa::create([
                'nama'=>$row[10],
                'kecamatan_id'=>$kecamatan->id,
            ]);
        }
        $tps = Tps::where('nomor',$row[9])->where('kelurahan_desa_id',$kelurahanDesa->id)->first();
        if(!$tps){
            $tps = Tps::create([
                'nomor'=>$row[9],
                'rt_rw'=>$row[4].'/'.$row[5],
                'alamat'=>$row[8],
                'kelurahan_desa_id' => $kelurahanDesa->id
            ]);
            //$tps->kelurahan_desas()->attach($kelurahanDesa->id);
        }
        return Dpt::firstOrCreate([
            'nama'=>$row[1],
            'jenis_kelamin'=>$row[2],
            'usia'=>$row[3],
            'rt'=>strlen($row[4]) > 3 ? "000" : $row[4],
            'rw'=>strlen($row[5]) > 3 ? "000" : $row[5],
            'nik'=>$row[6],
            'ket' => $row[7],
            'alamat'=>$row[8],
            'tps_id'=>$tps->id,
        ]);
    }

    private function metode_2(array $row){
        if($this->kabupaten_kota_id == 0 || $this->kabupaten_kota_id == null){
            throw new Exception("Kabupaten Kota Not Found");
        }
        if($row[0] == "" || $row[7] == "" || strtolower($row[0]) == 'kec_id' || $row[2] == null){
            Log::info("Kosong : ".json_encode($row));
            return null;
        }
        
        $kecamatan = Kecamatan::where('nama',$row[1])->where('kabupaten_kota_id',$this->kabupaten_kota_id)->first();
        if(!$kecamatan){
            throw new Exception("Kecamatan Not Found");
            $kecamatan = Kecamatan::create([
                'nama'=>$row[1],
                'kabupaten_kota_id'=>$this->kabupaten_kota_id,
            ]);
        }
        $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama',$row[3])->first();
        if(!$kelurahanDesa){
            throw new Exception("Kelurahan/Desa Not Found");
            $kelurahanDesa = KelurahanDesa::create([
                'nama'=>$row[3],
                'kecamatan_id'=>$kecamatan->id,
            ]);
        }

        $offsetKolomTanggal = 0;

        foreach ($row as $key => $value) {
            if($key > 8){
                if(str_contains($value,"|") && count(explode("|",$value)) > 2){
                    break;
                } else {
                    $offsetKolomTanggal += 1;
                }
            }
            
        }
       
        $tanggal_lahir = $row[9+$offsetKolomTanggal];
        $pattern = '/[A-Za-z]/';
        
        // if (preg_match($pattern, $tanggal_lahir)) {
            
        // } 
        $usia = $this->getAgeFromDate($tanggal_lahir);
        if(!$usia){
            Log::channel('datalog')->info(json_encode($row));
            Log::info("Format Salah : ".json_encode($row));
            return null;
        }

        if($usia < 17){
            return null;
        }

        $offsetRtRw = 0;
        foreach ($row as $key => $value) {
            if($key > 12){
                if(isset($row[$key+1]) && is_numeric($row[$key]) && is_numeric($row[$key+1]) && !preg_match($pattern, $row[$key+1])){
                    break;
                } else {
                    $offsetRtRw += 1;
                }
            }
            
        }

        $tpsId = $row[19+$offsetRtRw];
        $nomorTps = $row[20+$offsetRtRw];
        // if($nomorTps == null && strlen($tpsId) > 3){
        //     $nomorTps = (int)substr($tpsId, -2);
        // } else if(strlen($nomorTps) > 3){
        //     $tpsId = $nomorTps;
        //     $nomorTps = (int)substr($nomorTps, -2);
        // }
        
        if(($nomorTps == 0 || !is_numeric($nomorTps) || strlen($nomorTps) > 3) && $this->kelurahan_desa_id == $kelurahanDesa->id){
            $nomorTps = $this->tps;
        }

        if($nomorTps == 0 || !is_numeric($nomorTps) || strlen($nomorTps) > 3){
            Log::channel('datalog')->info(json_encode($row));
            Log::info("Nomor TPS Salah (".$nomorTps.") : ".json_encode($row));
            return;
        }
        $this->tps = $nomorTps;
        $this->kelurahan_desa_id = $kelurahanDesa->id;
        

        if((strlen((string)$row[13+$offsetRtRw]) > 3 || strlen((string)$row[14+$offsetRtRw]) > 3 || (string)$row[13+$offsetRtRw] === "" || $row[13+$offsetRtRw] === null) || (int)$row[13+$offsetRtRw] == 0){
            return null;
            Log::channel('datalog')->info(json_encode($row));
            Log::info("RT/RW Salah (".$row[13+$offsetRtRw]."/".$row[14+$offsetRtRw].") : ".json_encode($row));
            return;
        }

        $tps = Tps::where('nomor',(int)$nomorTps)->where('kelurahan_desa_id',$kelurahanDesa->id)->first();
       
        if(!$tps){
            return null;
            throw new Exception("Tps Not Found");
            $tps = Tps::create([
                'nomor'=>(int)$nomorTps,
                'rt_rw'=>$row[13+$offsetRtRw].'/'.$row[14+$offsetRtRw],
                'kelurahan_desa_id' => $kelurahanDesa->id
            ]);
            //$tps->kelurahan_desas()->attach($kelurahanDesa->id);
        }

        if($row[9+$offsetKolomTanggal+2] != "L" && $row[9+$offsetKolomTanggal+2] != "P"){
            return null;
        }

        // $dpt = Dpt::where('tps_id',$tps->id)
        // ->where('nama',trim($row[7]))
        // ->where('jenis_kelamin',$row[9+$offsetKolomTanggal+2])
        // ->where('usia',$usia)
        // ->where('');

        // $dpt = Dpt::where([
        //     'tps_id'=>$tps->id,
        //     'nama'=>strtoupper(trim($row[7])),
        //     'jenis_kelamin'=>$row[9+$offsetKolomTanggal+2],
        //     'usia'=>(int)$usia,
        //     'rt'=>(int)$row[13+$offsetRtRw],
        // ])->first();

        $cekNik = Dpt::where('nik',$row[6])->first();
        if($cekNik){
            return null;
        }

        $cekDpt = Dpt::where([
                'tps_id'=>$tps->id,
                'nama'=>strtoupper(trim($row[7])),
                'jenis_kelamin'=>$row[9+$offsetKolomTanggal+2],
                'usia'=>(int)$usia,
                'rt'=>(int)$row[13+$offsetRtRw],
                'rw'=>(int)$row[14+$offsetRtRw],
            ])->first();
        
        if($cekDpt){
            $cekDpt->update([
                'nik'=>$row[6],
                'no_kk'=>$row[5],
                'alamat'=>$row[12+$offsetRtRw],
            ]);
        } else {
            $cekDpt = Dpt::firstOrCreate([
                'nama'=>$row[7],
                'jenis_kelamin'=>$row[9+$offsetKolomTanggal+2],
                'usia'=>$usia,
                'rt'=>(int)$row[13+$offsetRtRw],
                'rw'=>(int)$row[14+$offsetRtRw],
                'no_kk'=>$row[5],
                'nik'=>$row[6],
                'alamat'=>$row[12+$offsetRtRw],
                'tps_id'=>$tps->id,
            ]);
        }   

       
        return $cekDpt;
        
        // return Dpt::firstOrCreate([
        //     'nama'=>$row[7],
        //     'jenis_kelamin'=>$row[9+$offsetKolomTanggal+2],
        //     'usia'=>$usia,
        //     'rt'=>strlen($row[13+$offsetRtRw]) > 3 ? "0" : $row[13+$offsetRtRw],
        //     'rw'=>strlen($row[14+$offsetRtRw]) > 3 ? "0" : $row[14+$offsetRtRw],
        //     'no_kk'=>$row[5],
        //     'nik'=>$row[6],
        //     'alamat'=>$row[12+$offsetRtRw],
        //     'tps_id'=>$tps->id,
        // ]);
        
    }

    public function collection(Collection $rows)
    {
        foreach ($rows as $row) 
        {
            if(strtolower($row[0]) == 'no' && !isset($row[9]) && ($row[9] == '' || $row[9] == null) || !isset($row[2]) || $row[2] == null){
                continue;
            }
            $kabKota = KabupatenKota::where('nama',$this->normalizeKota($row[12]))->first();
            if(!$kabKota){
                continue;
            }
            $kecamatan = Kecamatan::where('nama',$row[11])->where('kabupaten_kota_id',$kabKota->id)->first();
            if(!$kecamatan){
                $kecamatan = Kecamatan::create([
                    'nama'=>$row[11],
                    'kabupaten_kota_id'=>$kabKota->id,
                ]);
            }
            $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama',$row[10])->first();
            if(!$kelurahanDesa){
                $kelurahanDesa = KelurahanDesa::create([
                    'nama'=>$row[10],
                    'kecamatan_id'=>$kecamatan->id,
                ]);
            }
            $tps = Tps::where('nomor',$row[9])->where('kelurahan_desa_id',$kelurahanDesa->id)->first();
            if(!$tps){
                
                $tps = Tps::create([
                    'nomor'=>$row[9],
                    'rt_rw'=>$row[4].'/'.$row[5],
                    'alamat'=>$row[8],
                    'kelurahan_desa_id' => $kelurahanDesa->id
                ]);
                //$tps->kelurahan_desas()->attach($kelurahanDesa->id);
            }
            Dpt::firstOrCreate([
                'nama'=>$row[1],
                'jenis_kelamin'=>$row[2],
                'usia'=>$row[3],
                'rt'=>strlen($row[4]) > 3 ? "000" : $row[4],
                'rw'=>strlen($row[5]) > 3 ? "000" : $row[5],
                'nik'=>$row[6],
                'ket' => $row[7],
                'alamat'=>$row[8],
                'tps_id'=>$tps->id,
            ]);
        }
    }
    

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if($row[0] == "KEC_ID"){
            $this->metode = "2";
        }
        $model = null;
        try {
            switch ($this->metode) {
                case '2':
                    $model = $this->metode_2($row);
                    break;
                
                default:
                    $model = $this->metode_1($row);
                    break;
            }
        } catch (\Throwable $th) {
            Log::channel('datalog')->info(json_encode($row));
            Log::error($th);
            Log::info("ERROR: ".json_encode($row));
        }
        return $model;
    }

    public function chunkSize(): int
    {
        return 2000;
    }
}
