<?php

namespace App\Http\Controllers;

use App\DataTables\UserKoordinatorsDataTable;
use App\Exports\FormatImportKoordinatorExport;
use App\Exports\UserKoordinatorsExport;
use App\Helpers\Helper;
use App\Imports\UserKoordinatorsImport;
use App\Jobs\KirimNotifWa;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Provinsi;
use App\Models\Partai;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;

class UserKoordinatorController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {
    //     if (auth()->user()->role == "koordinator-kelurahan-desa") {
    //         return abort(404);
    //     }
    //     if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
    //         return abort(404);
    //     }
    //     if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
    //         return abort(404);
    //     }
    //     if (request()->koordinator == "") {
    //         return abort(404);
    //     }
    //     $q = request()->query('q');

    //     if (request()->export) {
    //         $exportClass = new UserKoordinatorsExport;
    //         $exportClass->q = $q;
    //         $exportClass->koordinator = request()->koordinator;
    //         return Excel::download($exportClass, 'data_koordinator-' . request()->koordinator . '_' . date("YmdHis") . '.xlsx');
    //     }

    //     $datas = User::with('tps.kelurahan_desa', 'kelurahan_desa', 'partai', 'multi_tps', 'dpt')
    //         ->whereIn('role', ['koordinator-kabupaten-kota', 'koordinator-kecamatan', 'koordinator-kelurahan-desa']);
    //     if ($q != "") {
    //         $datas = $datas->where(function ($w) use ($q) {
    //             $w->where('nama', 'like', '%' . $q . '%')
    //                 ->orWhere('no_telp', 'like', '%' . $q . '%')
    //                 ->orWhereHas('tps', function ($wtps) use ($q) {
    //                     $wtps->where('nomor', $q);
    //                 });
    //         });
    //     }

    //     if (request()->koordinator) {
    //         $datas = $datas->where('role', 'koordinator-' . request()->koordinator);
    //     }

    //     if (auth()->user()->role == "koordinator-kelurahan-desa") {
    //         $datas = $datas->whereHas('tps', function ($w) {
    //             $w->where('kelurahan_desa_id', auth()->user()->kelurahan_desa_id);
    //         });
    //     }

    //     if (auth()->user()->role == "koordinator-kecamatan") {
    //         $datas = $datas->whereHas('tps.kelurahan_desa', function ($w) {
    //             $w->where('kecamatan_id', auth()->user()->kecamatan_id);
    //         });
    //     }

    //     if (auth()->user()->role == "koordinator-kabupaten-kota") {
    //         $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
    //             $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
    //         });
    //     }

    //     if (request()->kelurahan_desa_id) {
    //         $datas = $datas->where('kelurahan_desa_id', request()->kelurahan_desa_id);
    //     } else if (request()->kecamatan_id) {
    //         $datas = $datas->whereHas('kelurahan_desa', function ($w) {
    //             $w->where('kecamatan_id', request()->kecamatan_id);
    //         });
    //     } else if (request()->kabupaten_kota_id) {
    //         $datas = $datas->whereHas('kelurahan_desa', function ($w) {
    //             $w->whereHas('kecamatan', function ($w) {
    //                 $w->where('kabupaten_kota_id', request()->kabupaten_kota_id);
    //             });
    //         });
    //     } else if (request()->provinsi_id) {
    //         $datas = $datas->whereHas('kelurahan_desa', function ($w) {
    //             $w->whereHas('kecamatan', function ($w) {
    //                 $w->whereHas('kabupaten_kota', function ($w) {
    //                     $w->where('provinsi_id', request()->provinsi_id);
    //                 });
    //             });
    //         });
    //     }

    //     $datas = $datas->orderBy('created_at', 'DESC')->paginate(10)->appends(['q' => $q, 'koordinator' => request()->koordinator ?? "kelurahan-desa"]);
    //     $provinsis = Provinsi::all();
    //     return view('user-koordinator.index', compact('datas', 'q', 'provinsis'));
    // }

    public function index(UserKoordinatorsDataTable $dataTable)
    {
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        // if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
        //     return abort(404);
        // }
        if (request()->koordinator == "") {
            return abort(404);
        }

        if (request()->export) {
            $exportClass = new UserKoordinatorsExport;
            $exportClass->koordinator = request()->koordinator;
            return Excel::download($exportClass, 'data_koordinator-' . request()->koordinator . '_' . date("YmdHis") . '.xlsx');
        }
        $provinsis = Provinsi::all();
        $partais = Partai::all();
        return $dataTable->render('user-koordinator.index', compact('provinsis', 'partais'));
    }

    public function create()
    {
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
            return abort(404);
        }
        if (request()->koordinator == "") {
            return abort(404);
        }
        if (auth()->user()->role != "admin") {
            return abort(402);
        }
        $provinsis = Provinsi::all();
        $kabupatenKotas = KabupatenKota::all();
        $kecamatans = Kecamatan::all();
        $kelurahanDesas = KelurahanDesa::all();
        $tps = Tps::with('kelurahan_desa')->get();
        // generate random password with number and word and 8 length
        $password = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
        $partais = Partai::all();
        return view('user-koordinator.create', compact('provinsis', 'kabupatenKotas', 'kecamatans', 'kelurahanDesas', 'tps', 'password', 'partais'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
            return abort(404);
        }
        if (request()->koordinator == "") {
            return abort(404);
        }
        if (auth()->user()->role != "admin") {
            return abort(402);
        }
        $request->validate([
            // 'dpt_id' => 'required',
            // 'no_telp' => 'required|unique:users,no_telp,NULL,NULL,deleted_at,NULL',
            'no_wa' => 'required|unique:users,no_telp,NULL,NULL,deleted_at,NULL',
            'password' => 'required|min:5',
            'nama'=>'required'
        ]);
        $dpt = Dpt::find($request->dpt_id);

        DB::beginTransaction();
        try {
            $status = "sesuai";
            if ($dpt != null) {
                $cekUser = User::where('dpt_id', $dpt->id)->where('role', 'koordinator-' . request()->koordinator)->where('tps_id', $request->tps_id)->first();
                if ($cekUser) {
                    $status = "sudah ada";
                }
                if ($request->has('multi_tps_id') && request()->koordinator == "kelurahan-desa") {
                    $cekUser = User::where('role', 'koordinator-' . request()->koordinator)->whereHas('multi_tps', function ($w) {
                        $w->whereIn('tps_id', request()->multi_tps_id);
                    })->first();
                    if ($cekUser) {
                        $status = "sudah ada";
                    }
                }
            } else {
                $status = "tidak sesuai";
            }
            $koordinator = User::create([
                'nama' => $request->nama,
                'nik' => $request->nik,
                'email' => $request->email,
                'password' => bcrypt($request->password),
                'role' => 'koordinator-' . request()->koordinator,
                'no_telp' => $request->no_wa,
                'no_wa' => $request->no_wa,
                'provinsi_id' => $request->provinsi_id,
                'kabupaten_kota_id' => $request->kabupaten_kota_id,
                'kecamatan_id' => $request->kecamatan_id,
                'kelurahan_desa_id' => $request->kelurahan_desa_id,
                'tps_id' => @$request->tps_id ?? @$request->multi_tps_id[0],
                'dpt_id' => $request->dpt_id,
                'status' => $status,
                'partai_id' => $request->partai_id,
            ]);
            if ($request->has('multi_tps_id')) {
                $koordinator->multi_tps()->attach($request->multi_tps_id);
            }
            if ($request->has('no_wa')) {



                try {
$msg = '[Pesan Otomatis] 
Anda telah terdaftar sebagai Koordinator '.request()->koordinator.' untuk aplikasi *Pilkada Zona ' . env("APP_NAME") . '* : 
Nama : *'.$koordinator->nama.'*
No Wa : *'.$koordinator->no_wa.'*';
$msg .= "\n";
if($request->koordinator == "kelurahan-desa"){
    $msg .= 'Wilayah Bertugas : *'.@$koordinator->kelurahan_desa->nama.'*';
} else if($request->koordinator == "kecamatan"){
    $msg .= 'Wilayah Bertugas : *'.@$koordinator->kecamatan->nama.'*';
} else if($request->koordinator == "kabupaten-kota"){
    $msg .= 'Wilayah Bertugas : *'.@$koordinator->kabupaten_kota->nama.'*';
}

$msg .= "\n";
$msg .= 'Silahkan login menggunakan no whatsapp anda di :
' . route('login') . '

Silahkan menunggu arahan dari koordinator/admin zona masing-masing.

';
if(auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532"){
    $msg .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
    $msg .= "*".auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
}
                    if($request->koordinator == "kelurahan-desa"){
                        $user_koor = User::where('role', 'koordinator-kecamatan')->where('kecamatan_id', $request->kecamatan_id)->where('partai_id', $request->partai_id)->get()->toArray();
                        if (count($user_koor) > 0) {
                            $msg .= "atau bisa menghubungi koordinator kecamatan : \n";
                            $random_keys = count($user_koor) > 2 ? array_rand($user_koor, min(2, count($user_koor))) : array_keys($user_koor);
                            foreach ($random_keys as $key) {
                                $msg .= "*".$user_koor[$key]['nama'] . "* : " . $user_koor[$key]['no_wa'] . "\n";
                            }
                        }
                        
                    } else if($request->koordinator == "kecamatan"){
                        $user_koor = User::where('role', 'koordinator-kabupaten-kota')->where('kabupaten_kota_id', $request->kabupaten_kota_id)->where('partai_id', $request->partai_id)->get()->toArray();
                        if (count($user_koor) > 0) {
                            $msg .= "atau bisa menghubungi koordinator kabupaten/kota : \n";
                            $random_keys = count($user_koor) > 2 ? array_rand($user_koor, min(2, count($user_koor))) : array_keys($user_koor);
                            foreach ($random_keys as $key) {
                                $msg .= "*".$user_koor[$key]['nama'] . "* : " . $user_koor[$key]['no_wa'] . "\n";
                            }
                        }
                       
                    } else if($request->koordinator == "kabuapten-kota"){
                        $user_admin = User::where('role', 'admin')->whereNotIn('no_wa', ['081348039947', '08115809532', '085161890114'])->where('partai_id', $request->partai_id)->get()->toArray();
                        if (count($user_admin) > 0) {
                            $msg .= "atau bisa menghubungi admin : \n";
                            $msg .= "*Dewi Risnawati* : 089604169403 \n";
                            $random_keys = count($user_admin) > 2 ? array_rand($user_admin, min(2, count($user_admin))) : array_keys($user_admin);
                            if(auth()->user()->role == "admin" && auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532" && auth()->user()->no_wa != "085161890114"){
                                $msg .= "*".auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
                            }
                            foreach ($random_keys as $key) {
                                $msg .= "*".$user_admin[$key]['nama'] . "* : " . $user_admin[$key]['no_wa'] . "\n";
                            }
                        }
                    }
                    
                    
                } catch (\Throwable $th) {
                    //throw $th;
                    Log::error($th);
$msg = '[Pesan Otomatis] 
Anda telah terdaftar sebagai Koordinator '.request()->koordinator.' untuk aplikasi *Pilkada Zona ' . env("APP_NAME") . '* : 
Nama : *'.$koordinator->nama.'*
No Wa : *'.$koordinator->no_wa.'*

Silahkan login menggunakan no whatsapp anda di :
' . route('login') . '

Silahkan menunggu arahan dari koordinator/admin zona masing-masing.

';

if(auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532"){
    $msg .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
    $msg .= "*".auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
}
                }
                Helper::sendWa($koordinator->no_wa, $msg);
            }
            DB::commit();
            Helper::addUserLog("Menambah data user koordinator-" . request()->koordinator . " " . $koordinator->nama,json_encode($koordinator));
            return redirect()->route('user-koordinator.index', ['koordinator' => request()->koordinator])->with('success', 'Data berhasil disimpan : ' . $koordinator->nama);
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->withInput($request->all())->with('error', 'Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(User $koordinator)
    {
        return view('user-koordinator.show', compact('koordinator'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
            return abort(404);
        }
        if (request()->koordinator == "") {
            return abort(404);
        }
        if (auth()->user()->role != "admin") {
            return abort(402);
        }
        $koordinator = User::findOrFail($id);
        $provinsis = Provinsi::all();
        $kabupatenKotas = KabupatenKota::all();
        $kecamatans = Kecamatan::all();
        $kelurahanDesas = KelurahanDesa::all();
        $tps = Tps::with('kelurahan_desa')->get();
        $partais = Partai::all();
        return view('user-koordinator.edit', ['data' => $koordinator, 'provinsis' => $provinsis, 'kabupatenKotas' => $kabupatenKotas, 'kecamatans' => $kecamatans, 'kelurahanDesas' => $kelurahanDesas, 'tps' => $tps, 'partais' => $partais]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
            return abort(404);
        }
        if (request()->koordinator == "") {
            return abort(404);
        }
        if (auth()->user()->role != "admin") {
            return abort(402);
        }
        $koordinator = User::findOrFail($id);
        $request->validate([
            'nama' => 'required',
            // 'no_telp' => 'required|unique:users,no_telp,' . $koordinator->id . ',id,deleted_at,NULL',
            'no_wa' => 'required|unique:users,no_wa,' . $koordinator->id . ',id,deleted_at,NULL',
        ]);

        if (request()->koordinator == "kabupaten-kota") {
            $request->validate([
                'kabupaten_kota_id' => 'required',
            ]);
        }

        if (request()->koordinator == "kecamatan") {
            $request->validate([
                'kecamatan_id' => 'required',
            ]);
        }

        if (request()->koordinator == "kelurahan-desa") {
            $request->validate([
                'kelurahan_desa_id' => 'required',
            ]);
        }

        $dpt = Dpt::find($request->dpt_id);
        $status = $koordinator->status;
        if ($dpt != null) {
            if ($status == "sudah ada") {
                $cekUser = User::where('dpt_id', $dpt->id)
                    ->where('id', '!=', $koordinator->id)
                    ->where('tps_id', $request->tps_id)->first();
                if (!$cekUser) {
                    $status = "sesuai";
                }
            }
            if ($status == "tidak sesuai" && $request->dpt_id) {
                $cekDpt = Dpt::where('id', $request->dpt_id)->where('tps_id', $request->tps_id)->first();
                if ($cekDpt) {
                    $status = "sesuai";
                }
            }
        } else {
            $status = "tidak sesuai";
        }

        if ($request->has('multi_tps_id') && request()->koordinator == "kelurahan-desa") {
            $cekUser = User::where('role', 'koordinator-' . request()->koordinator)
            ->whereHas('multi_tps', function ($w) {
                $w->whereIn('tps_id', request()->multi_tps_id);
            })->where('id', '!=', $koordinator->id)->count();
            if ($cekUser >= 2) {
                $status = "sudah ada";
            } else {
                $status = "sesuai";
            }
        }

        if (request()->koordinator == "kecamatan") {
            $cekUser = User::where('role', 'koordinator-' . request()->koordinator)->where('id', '!=', $koordinator->id)->where('kecamatan_id', $request->kecamatan_id)->count();
            if ($cekUser >= 3) {
                $status = "sudah ada";
            }else {
                $status = "sesuai";
            }
        }

        DB::beginTransaction();
        try {
            $no_wa = str_replace("'","",$request->no_wa);
            //remove all symbol and alphabet from $no_wa
            $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);

            //check if first character not 0
            if(mb_substr($no_wa, 0, 1) != '0'){
                $no_wa = '0'.$no_wa;
            }
            $koordinator->update([
                'nama' => $request->nama,
                'nik' => $request->nik,
                'email' => $request->email,
                'no_telp' => $no_wa,
                'no_wa' => $no_wa,
                'provinsi_id' => $request->provinsi_id,
                'kabupaten_kota_id' => $request->kabupaten_kota_id,
                'kecamatan_id' => $request->kecamatan_id,
                'kelurahan_desa_id' => $request->kelurahan_desa_id,
                'tps_id' => @$request->tps_id ?? @$request->multi_tps_id[0],
                'dpt_id' => $request->dpt_id,
                'partai_id' => $request->partai_id,
                'status' => $status
            ]);

            if ($request->has('multi_tps_id')) {
                $koordinator->multi_tps()->sync($request->multi_tps_id);
            }

            if ($request->password_baru) {
                $request->validate([
                    'password_baru' => 'required|min:5',
                ]);
                $koordinator->update([
                    'password' => bcrypt($request->password_baru)
                ]);
            }
            DB::commit();
            Helper::addUserLog("Mengubah data user koordinator-" . request()->koordinator . " " . $koordinator->nama,json_encode($koordinator));
            return redirect()->route('user-koordinator.index', ['koordinator' => request()->koordinator])->with('success', 'Data berhasil diubah : ' . $koordinator->nama);
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->withInput($request->all())->with('error', 'Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
            return abort(404);
        }
        if (request()->koordinator == "") {
            return abort(404);
        }
        $koordinator = User::findOrFail($id);
        DB::beginTransaction();
        try {
            $koordinator->delete();
            $cekUser = User::where('dpt_id', $koordinator->dpt_id)->where('role', $koordinator->role)->where('status', 'sudah ada')->where('id', '!=', $koordinator->id)->where('tps_id', $koordinator->tps_id)->count();
            if ($cekUser == 1) {
                User::where('dpt_id', $koordinator->dpt_id)->where('role', $koordinator->role)->where('status', 'sudah ada')->where('id', '!=', $koordinator->id)->where('tps_id', $koordinator->tps_id)->update([
                    'status' => 'sesuai'
                ]);
            }
            DB::commit();
            Helper::addUserLog("Menghapus data user koordinator-" . request()->koordinator . " " . $koordinator->nama,json_encode($koordinator));
            return redirect()->route('user-koordinator.index', ['koordinator' => request()->koordinator])->with('success', 'Data berhasil dihapus : ' . $koordinator->nama);
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('user-koordinator.index', ['koordinator' => request()->koordinator])->with('error', 'Data gagal dihapus');
        }
    }

    public function ajaxDpt(Request $request)
    {
        $tps_id = $request->tps_id;
        $datas = Dpt::where('tps_id', $tps_id)->get();
        return response()->json($datas);
    }

    public function importView()
    {   
        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kecamatan" && request()->koordinator != "kelurahan-desa") {
            return abort(404);
        }
        if (auth()->user()->role == "koordinator-kabupaten-kota" && request()->koordinator == "kabupaten-kota") {
            return abort(404);
        }
        if (request()->koordinator == "") {
            return abort(404);
        }
        if (auth()->user()->role != "admin") {
            return abort(402);
        }

        if (request()->export) {
            $exportClass = new FormatImportKoordinatorExport(auth()->user(), request()->koordinator);
            return Excel::download($exportClass, 'format_import_koordinator_'.str_replace("-","_",request()->koordinator).'_' . date("YmdHis") . '.xlsx');
        }
        Session::forget('import_errors');
        Session::forget('users');
        return view('user-koordinator.import');
    }

    public function import(Request $request)
    {   
        if (auth()->user()->role != "admin") {
            return abort(402);
        }
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        $file = $request->file('file');
        DB::beginTransaction();
        try {
            $model = new UserKoordinatorsImport;
            $import = Excel::import($model, $file);
            DB::commit();
            $users = $model->users;

            foreach ($users as $user) {
                if ($user['no_wa'] == null || $user['no_wa'] == "" || env("APP_ENV") == "local"){
                    continue;
                }
                    
//                 $msg = 'Anda telah terdaftar sebagai saksi untuk aplikasi *Pilkada ' . env("APP_NAME") . '* : 
// Silahkan login di 
// ' . route('login');
try {
$msg = '[Pesan Otomatis] 
Anda telah terdaftar sebagai Koordinator '.request()->koordinator.' untuk aplikasi *Pilkada Zona ' . env("APP_NAME") . '* : 
Nama : *'.$user['nama'].'*
No Wa : *'.$user['no_wa'].'*
Wilayah Bertugas : *'.(@$user['kelurahan_desa'] ?? @$user['kecamatan'] ?? @$user['kabupaten_kota']).'*
Silahkan login menggunakan no whatsapp anda di :
' . route('login') . '

Silahkan menunggu arahan dari koordinator/admin zona masing-masing.

    ';


if(auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532"){
    $msg .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
    $msg .= "*".auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
}
                        if($request->koordinator == "kelurahan-desa"){
                            $user_koor = User::where('role', 'koordinator-kecamatan')->where('kecamatan_id', $user['kecamatan_id'])->where('partai_id', $user['partai_id'])->get()->toArray();
                            if (count($user_koor) > 0) {
                                $msg .= "atau bisa menghubungi koordinator kecamatan : \n";
                                $random_keys = count($user_koor) > 2 ? array_rand($user_koor, min(2, count($user_koor))) : array_keys($user_koor);
                                foreach ($random_keys as $key) {
                                    $msg .= "*".$user_koor[$key]['nama'] . "* : " . $user_koor[$key]['no_wa'] . "\n";
                                }
                            }
                          
                            
                        } else if($request->koordinator == "kecamatan"){
                            $user_koor = User::where('role', 'koordinator-kabupaten-kota')->where('kabupaten_kota_id', $user['kabupaten_kota_id'])->where('partai_id', $user['partai_id'])->get()->toArray();
                            if (count($user_koor) > 0) {
                                $msg .= "atau bisa menghubungi koordinator kabupaten/kota : \n";
                                $random_keys = count($user_koor) > 2 ? array_rand($user_koor, min(2, count($user_koor))) : array_keys($user_koor);
                                foreach ($random_keys as $key) {
                                    $msg .= "*".$user_koor[$key]['nama'] . "* : " . $user_koor[$key]['no_wa'] . "\n";
                                }
                            }
                           
                        } else if($request->koordinator == "kabuapten-kota"){
                            $user_admin = User::where('role', 'admin')->whereNotIn('no_wa', ['081348039947', '08115809532', '085161890114'])->where('partai_id', $user['partai_id'])->get()->toArray();
                            if (count($user_admin) > 0) {
                                $msg .= "atau bisa menghubungi admin : \n";
                                $msg .= "*Dewi Risnawati* : 089604169403 \n";
                                $random_keys = count($user_admin) > 2 ? array_rand($user_admin, min(2, count($user_admin))) : array_keys($user_admin);
                                if(auth()->user()->role == "admin" && auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532" && auth()->user()->no_wa != "085161890114"){
                                    $msg .= "*".auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
                                }
                                foreach ($random_keys as $key) {
                                    $msg .= "*".$user_admin[$key]['nama'] . "* : " . $user_admin[$key]['no_wa'] . "\n";
                                }
                            }
                        }
                        
                        
                    } catch (\Throwable $th) {
                        //throw $th;
                        Log::error($th);
    $msg = '[Pesan Otomatis] 
    Anda telah terdaftar sebagai Koordinator '.request()->koordinator.' untuk aplikasi *Pilkada Zona ' . env("APP_NAME") . '* : 
    Nama : *'.$user['nama'].'*
    No Wa : *'.$user['no_wa'].'*
    
    Silahkan login menggunakan no whatsapp anda di :
    ' . route('login') . '
    
    Silahkan menunggu arahan dari koordinator/admin zona masing-masing.
    
    ';
    if(auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532"){
        $msg .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
        $msg .= "*".auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
    }
                    }
                dispatch(new KirimNotifWa($user['no_wa'], $msg));
            }
            Helper::addUserLog("Mengimport " . count($users) . " data user koordinator-" . request()->koordinator);
            Session::put('import_errors',$model->errors);
            Session::put('users',$model->users);
            // return redirect()->route('user-koordinator.index', ['koordinator' => request()->koordinator])->with('success', 'Berhasil mengimport ' . count($users) . ' user koordinator-' . request()->koordinator);
            return redirect()->route('user-koordinator.import-result', ['koordinator' => request()->koordinator])->with('success', 'Berhasil mengimport ' . count($users) . ' user koordinator-' . request()->koordinator);
        } catch (\Throwable $th) {
            DB::rollBack();
            Log::error($th);
            return redirect()->back()->with('error', 'Data gagal diimport : ' . $th->getMessage());
        }
    }

    public function importResult(){
        $import_errors =  Session::get('import_errors');
        $users =  Session::get('users');
        
        return view('user-koordinator.import-result',compact('import_errors','users'));
    }

    public function suratMandat($id)
    {
        $koordinator = User::with('kelurahan_desa','kecamatan','kabupaten_kota', 'provinsi','partai')->findOrFail($id);
        $users = User::has('partai')->with('kelurahan_desa','kecamatan','kabupaten_kota', 'partai')
        ->where('role','koordinator-'.request()->koordinator);

        if(request()->koordinator == "kelurahan-desa"){
            $users = $users->where('kelurahan_desa_id',$koordinator->kelurahan_desa_id);
        }

        if(request()->koordinator == "kecamatan"){
            $users = $users->where('kecamatan_id',$koordinator->kecamatan_id);
        }

        if(request()->koordinator == "kabupaten-kota"){
            $users = $users->where('kabupaten_kota_id',$koordinator->kabupaten_kota_id);
        }

        $users = $users->get();

        return view('user-koordinator.surat-mandat-'.request()->koordinator, compact('koordinator','users'));
    }

    public function suratMandatBulk()
    {
        $datas = Provinsi::query();

        if(request()->koordinator == 'kelurahan-desa'){
            $datas = Provinsi::with([
                'kabupaten_kotas' => function ($w) {
                    if (auth()->user()->role == "koordinator-kabupaten-kota") {
                        $w = $w->where('id', auth()->user()->kabupaten_kota_id);
                    }
    
                    if (request()->kabupaten_kota_id) {
                        $w = $w->where('id', request()->kabupaten_kota_id);
                    }
    
                    $w->with([
                        'kecamatans' => function ($w) {
                            if (auth()->user()->role == "koordinator-kecamatan") {
                                $w = $w->where('id', auth()->user()->kecamatan_id);
                            }
    
                            if (request()->kecamatan_id) {
                                $w = $w->where('id', request()->kecamatan_id);
                            }
    
                            $w->with([
                                'kelurahan_desas' => function ($w) {
                                    if (auth()->user()->role == "koordinator-kelurahan-desa") {
                                        $w = $w->where('id', auth()->user()->kelurahan_desa_id);
                                    }
    
                                    if (request()->kelurahan_desa_id) {
                                        $w = $w->where('id', request()->kelurahan_desa_id);
                                    }

                                    $w = $w->whereHas('koordinators', function ($w) {
                                        if (request()->partai_id) {
                                            $w = $w->where('partai_id', request()->partai_id);
                                        }
                                    });

                                    $w->with([
                                        'koordinators' => function ($w) {
                                            if (request()->partai_id) {
                                                $w = $w->where('partai_id', request()->partai_id);
                                            }
                                        }
                                    ]);
                                }
                            ]);
                        }
                    ]);
                }
            ]);
        }

        if(request()->koordinator == "kecamatan"){
            $datas = Provinsi::with([
                'kabupaten_kotas' => function ($w) {
                    if (auth()->user()->role == "koordinator-kabupaten-kota") {
                        $w = $w->where('id', auth()->user()->kabupaten_kota_id);
                    }
    
                    if (request()->kabupaten_kota_id) {
                        $w = $w->where('id', request()->kabupaten_kota_id);
                    }

                    $w->with([
                        'kecamatans' => function ($w) {
                            if (auth()->user()->role == "koordinator-kecamatan") {
                                $w = $w->where('id', auth()->user()->kecamatan_id);
                            }
    
                            if (request()->kecamatan_id) {
                                $w = $w->where('id', request()->kecamatan_id);
                            }

                            $w = $w->whereHas('koordinators', function ($w) {
                                if (request()->partai_id) {
                                    $w = $w->where('partai_id', request()->partai_id);
                                }
                            });
    
                            $w->with([
                                'koordinators' => function ($w) {
                                    if (request()->partai_id) {
                                        $w = $w->where('partai_id', request()->partai_id);
                                    }
                                }
                            ]);
                        }
                    ]);
    
                    
                }
            ]);
        }

        if(request()->koordinator == "kabupaten-kota"){
            $datas = Provinsi::with([
                'kabupaten_kotas' => function ($w) {
                    if (auth()->user()->role == "koordinator-kabupaten-kota") {
                        $w = $w->where('id', auth()->user()->kabupaten_kota_id);
                    }
    
                    if (request()->kabupaten_kota_id) {
                        $w = $w->where('id', request()->kabupaten_kota_id);
                    }

                    $w = $w->whereHas('koordinators', function ($w) {
                        if (request()->partai_id) {
                            $w = $w->where('partai_id', request()->partai_id);
                        }
                    });
    
                    $w->with([
                        'koordinators' => function ($w) {
                            if (request()->partai_id) {
                                $w = $w->where('partai_id', request()->partai_id);
                            }
                        }
                    ]);
                }
            ]);
        }



        $datas = $datas->get();

        

        // $pdf = Pdf::loadView('saksi.surat-mandat-bulk', [
        //     'datas'=>$datas
        // ]);
        // $pdf->setWarnings(true);
        // $pdf->setOption(['isRemoteEnabled' => true]);
        // return $pdf->download('invoice.pdf');
        return view('user-koordinator.surat-mandat-bulk-'.request()->koordinator, compact('datas'));
    }
}
