<?php

namespace App\Http\Controllers;

use App\DataTables\SaksisDataTable;
use App\Exports\FormatImportSaksiExport;
use App\Exports\SaksisExport;
use App\Helpers\Helper;
use App\Imports\SaksiImport;
use App\Jobs\KirimNotifWa;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Provinsi;
use App\Models\Partai;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;

class SaksiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {
    //     $q = request()->query('q');

    //     if (request()->export) {
    //         $exportClass = new SaksisExport;
    //         $exportClass->q = $q;
    //         return Excel::download($exportClass, 'data_saksi_' . date("YmdHis") . '.xlsx');
    //     }

    //     $datas = User::with('tps.kelurahan_desa', 'kelurahan_desa', 'partai', 'dpt')->where('role', 'saksi');
    //     if ($q != "") {
    //         $datas = $datas->where(function ($w) use ($q) {
    //             $w->where('nama', 'like', '%' . $q . '%')
    //                 ->orWhere('no_telp', 'like', '%' . $q . '%')
    //                 ->orWhereHas('tps', function ($wtps) use ($q) {
    //                     $wtps->where('nomor', $q);
    //                 });
    //         });
    //     }

    //     if (auth()->user()->role == "koordinator-kelurahan-desa") {
    //         $datas = $datas->whereHas('tps', function ($w) {
    //             $w->whereIn('kelurahan_desa_id', @auth()->user()->multi_tps->pluck('id')->toArray() ?? []);
    //         });
    //     }

    //     if (auth()->user()->role == "koordinator-kecamatan") {
    //         $datas = $datas->whereHas('tps.kelurahan_desa', function ($w) {
    //             $w->where('kecamatan_id', auth()->user()->kecamatan_id);
    //         });
    //     }

    //     if (auth()->user()->role == "koordinator-kabupaten-kota") {
    //         $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
    //             $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
    //         });
    //     }
    //     $datas = $datas->orderBy('created_at', 'DESC')->paginate(10)->appends(['q' => $q]);
    //     $provinsis = Provinsi::all();
    //     $partais = Partai::all();
    //     return view('saksi.index', compact('datas', 'q','provinsis', 'partais'));
    // }

    public function index(SaksisDataTable $dataTable)
    {

        if (request()->export) {
            $exportClass = new SaksisExport;
            return Excel::download($exportClass, 'data_saksi_' . date("YmdHis") . '.xlsx');
        }
        $provinsis = Provinsi::all();
        $partais = Partai::all();
        return $dataTable->render('saksi.index', compact('provinsis', 'partais'));
    }

    public function create()
    {
        $provinsis = Provinsi::all();
        $kabupatenKotas = KabupatenKota::all();
        $kecamatans = Kecamatan::all();
        $kelurahanDesas = KelurahanDesa::all();
        $tps = Tps::with('kelurahan_desa')->get();
        // generate random password with number and word and 8 length
        $password = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
        $partais = Partai::all();
        return view('saksi.create', compact('provinsis', 'kabupatenKotas', 'kecamatans', 'kelurahanDesas', 'tps', 'password', 'partais'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            // 'dpt_id' => 'required',
            // 'no_telp' => 'required|unique:users,no_telp,NULL,NULL,deleted_at,NULL',
            'no_wa' => 'required|unique:users,no_wa,NULL,NULL,deleted_at,NULL',
            'password' => 'required|min:5',
            'nama' => 'required'
        ]);

        $dpt = Dpt::find($request->dpt_id);

        DB::beginTransaction();
        try {
            $status = "sesuai";
            if ($dpt != null) {
                $cekUser = User::where('dpt_id', $request->dpt_id)
                    ->where('role', 'saksi')
                    ->where('tps_id', $request->tps_id)->first();
                if ($cekUser) {
                    $status = "sudah ada";
                }

                if (strtoupper($dpt->nama) != strtoupper($request->nama)) {
                    $status = "tidak sesuai";
                }

                $cekUser = User::whereHas('suaras', function ($w) use ($request) {
                    $w->where('tps_id', $request->tps_id);
                })->where('role', 'saksi')->count();
                if ($cekUser >= 2) {
                    $status = "sudah ada";
                }
            } else {
                $status = "tidak sesuai";
            }
            $no_wa = str_replace("'", "", $request->no_wa);
            //remove all symbol and alphabet from $no_wa
            $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);

            //check if first character not 0
            if (mb_substr($no_wa, 0, 1) != '0') {
                $no_wa = '0' . $no_wa;
            }
            $saksi = User::create([
                'nama' => $request->nama,
                'nik' => $request->nik,
                'email' => $request->email,
                'password' => bcrypt($request->password),
                'role' => 'saksi',
                'no_telp' => $no_wa,
                'no_wa' => $no_wa,
                'provinsi_id' => $request->provinsi_id,
                'kabupaten_kota_id' => $request->kabupaten_kota_id,
                'kecamatan_id' => $request->kecamatan_id,
                'kelurahan_desa_id' => $request->kelurahan_desa_id,
                'tps_id' => $request->tps_id,
                'dpt_id' => $request->dpt_id,
                'status' => $status,
                'partai_id' => $request->partai_id,
            ]);
            if ($request->has('no_wa') && env("APP_ENV") != "local") {

                $msg = '[Pesan Otomatis] 
Anda telah terdaftar sebagai saksi untuk aplikasi *Pilkada Zona ' . env("APP_NAME") . '* : 
Nama : *' . $saksi->nama . '*
No Wa : *' . $saksi->no_wa . '*
TPS Bertugas : *' . $saksi->tps->nomor . ' / ' . $saksi->tps->kelurahan_desa->nama . '*
Silahkan login menggunakan no whatsapp anda di :
' . route('login') . '

Silahkan menunggu arahan dari koordinator masing-masing.

';
if (auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532") {
    $msg .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
    $msg .= "*" . auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
}
                try {
                    
                    $msg .= "\n";
                    $user_koordes = User::where('role', 'koordinator-kelurahan-desa')->where('kelurahan_desa_id', $request->kelurahan_desa_id)->where('partai_id', $request->partai_id)->whereHas('multi_tps', function ($w) use ($request) {
                        $w->where('tps_id', $request->tps_id);
                    })->get();
                    $user_koorkab = User::where('role', 'koordinator-kabupaten-kota')->where('kabupaten_kota_id', $request->kabupaten_kota_id)->where('partai_id', $request->partai_id)->get()->toArray();
                    if (count($user_koordes) > 0) {

                        $msg .= "atau bisa menghubungi koordinator kelurahan/desa : \n";
                        foreach ($user_koordes as $koordes) {
                            $msg .= "*" . $koordes->nama . "* : " . $koordes->no_wa . "\n";
                        }
                    } else if (count($user_koorkab) > 0) {
                        $msg .= "atau bisa menghubungi koordinator kabupaten/kota : \n";
                        $random_keys = count($user_koorkab) > 2 ? array_rand($user_koorkab, min(2, count($user_koorkab))) : array_keys($user_koorkab);
                        foreach ($random_keys as $key) {
                            $msg .= "*" . $user_koorkab[$key]['nama'] . "* : " . $user_koorkab[$key]['no_wa'] . "\n";
                        }
                    }
                } catch (\Throwable $th) {
                    //throw $th;
                }
                Helper::sendWa($request->no_wa, $msg);
            }
            DB::commit();
            if ($dpt) {
                Helper::addUserLog("Menambah user saksi Nama : " . $request->nama . " | DPT : " . $dpt->nama,json_encode($saksi));
            } else {
                Helper::addUserLog("Menambah user saksi Nama : " . $request->nama,json_encode($saksi));
            }
            return redirect()->route('saksi.index')->with('success', 'Data berhasil disimpan : ' . $saksi->nama . ' | TPS ' . @$saksi->tps->nomor);
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            dd($th);
            return redirect()->back()->withInput($request->all())->with('error', 'Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(User $saksi)
    {
        return view('saksi.show', compact('saksi'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $saksi = User::findOrFail($id);
        $provinsis = Provinsi::all();
        $kabupatenKotas = KabupatenKota::all();
        $kecamatans = Kecamatan::all();
        $kelurahanDesas = KelurahanDesa::all();
        $tps = Tps::with('kelurahan_desa')->get();
        $partais = Partai::all();
        return view('saksi.edit', ['data' => $saksi, 'provinsis' => $provinsis, 'kabupatenKotas' => $kabupatenKotas, 'kecamatans' => $kecamatans, 'kelurahanDesas' => $kelurahanDesas, 'tps' => $tps, 'partais' => $partais]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $saksi = User::findOrFail($id);
        $request->validate([
            //'no_telp' => 'required|unique:users,no_telp,' . $saksi->id . ',id,deleted_at,NULL',
            'no_wa' => 'required|unique:users,no_wa,' . $saksi->id . ',id,deleted_at,NULL',
            'nama' => 'required'
        ]);

        $dpt = Dpt::find($request->dpt_id);

        DB::beginTransaction();
        try {
            $status = $saksi->status;
            if ($dpt != null) {
                // if ($status == "sudah ada") {
                //     $cekUser = User::where('dpt_id', $request->dpt_id)
                //         ->where('id', '!=', $saksi->id)
                //         ->where('tps_id', $request->tps_id)->first();
                //     if (!$cekUser) {
                //         $status = "sesuai";
                //     }
                // }
                if ($status == "tidak sesuai" && $request->dpt_id) {
                    $cekDpt = Dpt::where('id', $request->dpt_id)->where('tps_id', $request->tps_id)->first();
                    if ($cekDpt) {
                        if (strtoupper($cekDpt->nama) == strtoupper($request->nama)) {
                            $status = "sesuai";
                        } else {
                            $status = "tidak sesuai";
                        }
                    }
                }
                $cekUser = User::whereHas('suaras', function ($w) use ($request) {
                    $w->where('tps_id', $request->tps_id);
                })->where('id', '!=' . $saksi->id)->where('role', 'saksi')->count();
                if ($cekUser >= 2) {
                    $status = "sudah ada";
                } else {
                    $status = "sesuai";
                }
            } else {
                $status = "tidak sesuai";
            }

            $no_wa = str_replace("'", "", $request->no_wa);
            //remove all symbol and alphabet from $no_wa
            $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);

            //check if first character not 0
            if (mb_substr($no_wa, 0, 1) != '0') {
                $no_wa = '0' . $no_wa;
            }
            $saksi->update([
                'nama' => $request->nama,
                'nik' => $request->nik,
                'email' => $request->email,
                'role' => 'saksi',
                'no_telp' => $no_wa,
                'no_wa' => $no_wa,
                'provinsi_id' => $request->provinsi_id,
                'kabupaten_kota_id' => $request->kabupaten_kota_id,
                'kecamatan_id' => $request->kecamatan_id,
                'kelurahan_desa_id' => $request->kelurahan_desa_id,
                'tps_id' => $request->tps_id,
                'dpt_id' => $request->dpt_id,
                'status' => $status,
                'partai_id' => $request->partai_id,
            ]);

            if ($request->password_baru) {
                $request->validate([
                    'password_baru' => 'required|min:5',
                ]);
                $saksi->update([
                    'password' => bcrypt($request->password_baru)
                ]);
            }
            DB::commit();
            if ($dpt) {
                Helper::addUserLog("Mengubah user saksi Nama : " . $request->nama . " | DPT : " . $dpt->nama,json_encode($saksi));
            } else {
                Helper::addUserLog("Mengubah user saksi Nama : " . $request->nama,json_encode($saksi));
            }
            return redirect()->route('saksi.index')->with('success', 'Data berhasil diubah : ' . $saksi->nama . ' | TPS ' . @$saksi->tps->nomor);
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->withInput($request->all())->with('error', 'Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $saksi = User::with('suara', 'suara.suara_details', 'suara.file_lampirans', 'tps')->findOrFail($id);
        DB::beginTransaction();
        try {
            if ($saksi->suara) {
                $saksi->suara->file_lampirans()->delete();
                $saksi->suara->suara_details()->delete();
                $saksi->suara()->delete();
            }
            $saksi->delete();
            $cekUser = User::where('dpt_id', $saksi->dpt_id)->where('role', $saksi->role)->where('status', 'sudah ada')->where('id', '!=', $saksi->id)->where('tps_id', $saksi->tps_id)->count();
            if ($cekUser == 1) {
                User::where('dpt_id', $saksi->dpt_id)->where('role', $saksi->role)->where('status', 'sudah ada')->where('id', '!=', $saksi->id)->where('tps_id', $saksi->tps_id)->update([
                    'status' => 'sesuai'
                ]);
            }

            // $cekUser = User::whereHas('suaras',function($w)use($saksi){
            //     $w->where('tps_id',$saksi->tps_id);
            // })->where('role',$saksi->role)
            // ->where('status','sudah ada')->count();
            // if($cekUser >= 2){
            //     User::whereHas('suaras',function($w)use($saksi){
            //         $w->where('tps_id',$saksi->tps_id);
            //     })->where('role',$saksi->role)
            //     ->where('status','sudah ada')->update([
            //         'status'=>'sesuai'
            //     ]);
            // }
            DB::commit();
            Helper::addUserLog("Menghapus user saksi " . $saksi->nama, json_encode($saksi));
            return redirect()->route('saksi.index')->with('success', 'Data berhasil dihapus : ' . $saksi->nama . ' | TPS ' . @$saksi->tps->nomor);
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->with('error', 'Data gagal dihapus');
        }
    }

    public function ajaxDpt(Request $request)
    {
        $tps_id = $request->tps_id;
        $datas = Dpt::where('tps_id', $tps_id)->get();
        return response()->json($datas);
    }

    public function importView()
    {
        if (request()->export) {
            $exportClass = new FormatImportSaksiExport(auth()->user());
            return Excel::download($exportClass, 'format_import_saksi_' . date("YmdHis") . '.xlsx');
        }
        Session::forget('import_errors');
        Session::forget('users');
        return view('saksi.import');
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        $file = $request->file('file');
        DB::beginTransaction();
        try {
            $model = new SaksiImport;
            $import = Excel::import($model, $file);
            DB::commit();
            $users = $model->users;

            foreach ($users as $user) {
                if (!isset($user['no_wa']) && $user['no_wa'] == null || $user['no_wa'] == "" || env("APP_ENV") == "local") {
                    continue;
                }

                $msg = '[Pesan Otomatis] 
Anda telah terdaftar sebagai saksi untuk aplikasi *Pilkada Zona ' . env("APP_NAME") . '* : 
Nama : *' . $user['nama'] . '*
No Wa : *' . $user['no_wa'] . '*
TPS Bertugas : *' . $user['tps'] . ' / ' . $user['kelurahan_desa'] . '*
Silahkan login menggunakan no whatsapp anda di :
' . route('login') . '

Silahkan menunggu arahan dari koordinator masing-masing.

';
if (auth()->user()->no_wa != "081348039947" && auth()->user()->no_wa != "08115809532") {
    $msg .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
    $msg .= "*" . auth()->user()->nama . "* : " . auth()->user()->no_wa . "\n";
}
                try {
                    
                    $msg .= "\n";
                    $user_koordes = User::where('role', 'koordinator-kelurahan-desa')->where('kelurahan_desa_id', $user['kelurahan_desa_id'])->where('partai_id', $user['partai_id'])->whereHas('multi_tps', function ($w) use ($user) {
                        $w->where('tps_id', $user['tps_id']);
                    })->get();
                    $user_koorkab = User::where('role', 'koordinator-kabupaten-kota')->where('kabupaten_kota_id', $user['kabupaten_kota_id'])->where('partai_id', $user['partai_id'])->get()->toArray();
                    if (count($user_koordes) > 0) {
                        $msg .= "atau bisa menghubungi koordinator kelurahan/desa : \n";
                        foreach ($user_koordes as $koordes) {
                            $msg .= "*" . $koordes->nama . "* : " . $koordes->no_wa . "\n";
                        }


                    } else if (count($user_koorkab) > 0) {
                        $msg .= "atau bisa menghubungi koordinator kabupaten/kota : \n";
                        $random_keys = count($user_koorkab) > 2 ? array_rand($user_koorkab, min(2, count($user_koorkab))) : array_keys($user_koorkab);
                        foreach ($random_keys as $key) {
                            $msg .= "*" . $user_koorkab[$key]['nama'] . "* : " . $user_koorkab[$key]['no_wa'] . "\n";
                        }
                    }
                } catch (\Throwable $th) {
                    //throw $th;
                }
                dispatch(new KirimNotifWa($user['no_wa'], $msg));
            }
            Helper::addUserLog("Melakukan import " . count($users) . " user saksi");
            //return redirect()->route('saksi.index')->with('success', 'Berhasil mengimport ' . count($users) . ' saksi. Silahkan periksa kembali data yang sudah diimport. (informasi login akan segera dikirim ke no wa saksi)');
            Session::put('import_errors', $model->errors);
            Session::put('users', $model->users);
            return redirect()->route('saksi.import-result')->with('success', 'Berhasil mengimport ' . count($users) . ' saksi. Silahkan periksa kembali data yang sudah diimport. (informasi login akan segera dikirim ke no wa saksi)');
        } catch (\Throwable $th) {
            DB::rollBack();
            Log::error($th);
            return redirect()->back()->with('error', 'Data gagal diimport : ' . $th->getMessage());
        }
    }

    public function suratMandat($id)
    {
        $saksi = User::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi', 'partai')->findOrFail($id);
        $users = User::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi', 'partai')
            ->where('role', 'saksi')->where('tps_id', $saksi->tps_id)->get();
        return view('saksi.surat-mandat', compact('saksi', 'users'));
    }

    public function importResult()
    {
        $import_errors = Session::get('import_errors');
        $users = Session::get('users');

        return view('saksi.import-result', compact('import_errors', 'users'));
    }

    public function suratMandatBulk()
    {
        $datas = Provinsi::with([
            'kabupaten_kotas' => function ($w) {
                if (auth()->user()->role == "koordinator-kabupaten-kota") {
                    $w = $w->where('id', auth()->user()->kabupaten_kota_id);
                }

                if (request()->kabupaten_kota_id) {
                    $w = $w->where('id', request()->kabupaten_kota_id);
                }

                $w->with([
                    'kecamatans' => function ($w) {
                        if (auth()->user()->role == "koordinator-kecamatan") {
                            $w = $w->where('id', auth()->user()->kecamatan_id);
                        }

                        if (request()->kecamatan_id) {
                            $w = $w->where('id', request()->kecamatan_id);
                        }

                        $w->with([
                            'kelurahan_desas' => function ($w) {
                                if (auth()->user()->role == "koordinator-kelurahan-desa") {
                                    $w = $w->where('id', auth()->user()->kelurahan_desa_id);
                                }

                                if (request()->kelurahan_desa_id) {
                                    $w = $w->where('id', request()->kelurahan_desa_id);
                                }

                                $w->with([
                                    'tps' => function ($w) {
                                        if (request()->partai_id) {
                                            $w = $w->whereHas('saksis', function ($w) {
                                                if (request()->partai_id) {
                                                    $w = $w->where('partai_id', request()->partai_id);
                                                }
                                            });
                                        }
                                        $w->with([
                                            'saksis' => function ($w) {
                                                if (request()->partai_id) {
                                                    $w = $w->where('partai_id', request()->partai_id);
                                                }
                                            }
                                        ]);
                                    }
                                ]);
                            }
                        ]);
                    }
                ]);
            }
        ]);



        $datas = $datas->get();

        

        // $pdf = Pdf::loadView('saksi.surat-mandat-bulk', [
        //     'datas'=>$datas
        // ]);
        // $pdf->setWarnings(true);
        // $pdf->setOption(['isRemoteEnabled' => true]);
        // return $pdf->download('invoice.pdf');
        return view('saksi.surat-mandat-bulk', compact('datas'));
    }
}
