<?php

namespace App\Http\Controllers\Saksi;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;

class InputSuaraController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $suara = Suara::with(relations: 'suara_details')->where('tps_id', $user->tps_id)->first();
        $calons = Calon::orderBy('nomor', 'asc')->get()->map(function ($calon) use ($suara) {

            return [
                'id' => $calon->id,
                "nomor" => $calon->nomor ,
                "nama_calon" => $calon->nama_calon,
                "nama_wakil_calon" =>$calon->nama_wakil_calon,
                "votes" => (int)($suara && $suara->suara_details->count() > 0) ? $suara->suara_details->where('calon_id', $calon->id)->first()->jumlah_suara : 0
            ];
        })->toArray();
        //$token = Session::get('api_token');
        // Session::remove("warning");
        // if($suara && $suara->status == "reject"){
        //     Session::put("warning","Input suara anda ditolak, silahkan cek kembali dan submit ulang");
        // }
        $totalDpt = Dpt::where('tps_id', $user->tps_id)->count();
        return view('dashboard-saksi.input-suara.index', compact('calons', 'suara',  'totalDpt'));
    }

    public function save(Request $request)
    {   

        return redirect()->back()->with('warning','Belum waktunya pengambilan suara')->withInput($request->all());
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return redirect()->back()->with('warning','Belum waktunya pengambilan suara')->withInput($request->all());
        }
        try {
            $user = Auth::user();
            $suara = Suara::with('multi_user','suara_details')->where('tps_id', $user->tps_id)->first();
            // $bermasalah_paslon = array_sum($request->jumlah_suara) != $request->suara_sah;
            // $bermasalah_hak_pilih = $request->jumlah_hak_pilih != ($request->suara_sah + $request->suara_tidak_sah);
            // $menang = @$request->jumlah_suara[0] ?? 0 > @$request->jumlah_suara[1] ?? 0;
            if (!$suara) {
                $suara = Suara::create([
                    'user_id' => $user->id,
                    'tps_id' => $user->tps_id,
                    'tanggal' => date("Y-m-d"),
                    'total_suara' => array_sum($request->jumlah_suara ?? []) + ($request->suara_tidak_sah ?? 0),
                    'suara_tidak_sah' => $request->suara_tidak_sah ?? 0,
                    'suara_sah' => $request->suara_sah ?? 0,
                    // 'jumlah_dpt' => $request->jumlah_dpt,
                    // 'jumlah_hak_pilih' => $request->jumlah_hak_pilih,
                    'jumlah_dpt'=>0,
                    'jumlah_hak_pilih'=>0,
                    'jumlah_surat_suara_digunakan'=>0,
                    // 'bermasalah_paslon' => $bermasalah_paslon,
                    // 'bermasalah_hak_pilih' => $bermasalah_hak_pilih,
                    // 'menang'=>$menang,
                    'status' => 'approve',
                    
                ]);
                $suara->multi_user()->attach([$user->id]);
            } else {
                tap($suara)->update([
                    'total_suara' => array_sum($request->jumlah_suara ?? []) + ($request->suara_tidak_sah  ?? 0),
                    'suara_tidak_sah' => $request->suara_tidak_sah ?? 0,
                    'suara_sah' => $request->suara_sah ?? 0,
                    // 'jumlah_dpt' => $request->jumlah_dpt,
                    // 'jumlah_hak_pilih' => $request->jumlah_hak_pilih,
                    'jumlah_dpt'=>0,
                    'jumlah_hak_pilih'=>0,
                    'jumlah_surat_suara_digunakan'=>0,
                    // 'bermasalah_paslon' => $bermasalah_paslon,
                    // 'bermasalah_hak_pilih' => $bermasalah_hak_pilih,
                    // 'menang'=>$menang,
                    'status' => 'approve',
                    
                ]);
                $multi_user_id = @$suara->multi_user->pluck('id')->toArray() ?? [$user->id];
                if(!in_array($user->id,$multi_user_id)){
                    $multi_user_id[] = $user->id;
                }
                $suara->multi_user()->sync($multi_user_id);
            }
            if(isset($request->jumlah_suara) && is_array($request->jumlah_suara)){
                foreach ($request->jumlah_suara as $calon_id => $value) {
                    $suara->suara_details()->updateOrCreate([
                        'calon_id' => $calon_id
                    ], [
                        'jumlah_suara' => $value
                    ]);
                }
            }
            
            Helper::addUserLog("Menyimpan suara untuk TPS : ".$user->tps->nomor,json_encode($suara));
            return redirect()->route('user-saksi.input-suara.index')->with('success', 'Suara berhasil disimpan');
        } catch (\Throwable $th) {
            //throw $th;
            Log::error($th);
            return redirect()->back()->with('error','Suara gagal disimpan')->withInput($request->all());
        }
    }
}
