<?php

namespace App\Http\Controllers\Saksi;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ChangePasswordController extends Controller
{
    public function index(){
        return view('dashboard-saksi.change-password.index');
    }

    public function change(Request $request){
        $user = Auth::user();

        $request->validate([
            'password_lama' => 'required|min:5',
            'password_baru' => 'required|min:5'
        ]);

        $cek = Hash::check($request->password_lama, $user->password);

        if($cek){
            $user->update([
                'password'=>bcrypt($request->password_baru)
            ]);
            return redirect()->back()->with('success', 'Change password success');
        }

        return redirect()->back()->with('warning', 'Old Password is wrong');
    }
}
