<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\User;
use Ichtrojan\Otp\Models\Otp as ModelsOtp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Ichtrojan\Otp\Otp;
use Illuminate\Support\Facades\Log;

class LoginController extends Controller
{
    public function index()
    {
        return view('auth.login');
    }

    // public function auth(Request $request){

    //     $request->validate([
    //         'no_wa' => 'required|max:20',
    //         'password' => 'required'
    //     ]);

    //     $credentials = $request->only('no_wa', 'password');
    //     $cek = auth()->attempt($credentials);

    //     if($cek){
    //         Helper::addUserLog("Login ke aplikasi");
    //         if(auth()->user()->role == "saksi"){
    //             if($request->no_wa == $request->password){
    //                 return redirect()->route('user-saksi.change-password.index')->with('warning','Silahkan update password anda');

    //             }
    //             return redirect()->route('user-saksi.home');
    //         } else {
    //             if($request->no_wa == $request->password){
    //                 return redirect()->route('setting.new-password')->with('warning','Silahkan update password anda');
    //             }
    //             return redirect()->route('dashboard');
    //         }
    //     }

    //     return redirect()->back()->with('warning', 'No Telp or Password is wrong');
    // }

    public function auth(Request $request)
    {

        $request->validate([
            'no_wa' => 'required|max:20|min:10',
        ]);
        $cekUser = User::where('no_wa', $request->no_wa)->first();
        if ($cekUser) {
            $otp_key = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
            Session::put('otp',$otp_key);
            $password = $cekUser->no_wa.Helper::getIp().date("Ymd").$otp_key;
            $encrypt = openssl_encrypt($cekUser->no_wa,"AES-128-ECB",$password);
            if ($cekUser->id == 1) {
                return redirect()->route('cek-password.page', ['no_wa'=>$cekUser->no_wa,'token'=>$encrypt]);
            } else {
                $lastOtp = ModelsOtp::where('identifier',$request->no_wa)->latest()->first();
                $otp = null;
                if($lastOtp){
                    $lastTime = new \DateTime($lastOtp->created_at);
                    $lastTime->add(new \DateInterval('PT' . 2 . 'M'));

                    if ($lastTime > new \DateTime()) {
                        $otp = $lastOtp;
                        //return redirect()->back()->with('warning', 'Anda sebelumnya sudah mencoba untuk login. Silahkan tunggu 2 menit sebelum mencoba login kembali');
                    }
                }

                if($otp == null){
                    $otp = (new Otp)->generate($request->no_wa, 'numeric', 6, 5);
                }
                
                if(env("APP_ENV") != "local"){
                    $message = "Kode OTP untuk login aplikasi *Pilkada " . env("APP_NAME") . "* : ";
                    $message .= "\n";
                    $message .= $otp->token;
                    $message .= "\n";
                    $message .= "\n";
                    $kontakAdmins = Helper::kontakAdmin($cekUser->partai_id,$cekUser->kabupaten_kota_id);
                    if(count($kontakAdmins) > 0){
                        $message .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
                        foreach ($kontakAdmins as $kontak) {
                            $message .= "*".$kontak['nama']."* : ".$kontak['no_wa']." \n";
                        }
                    }
                    // $message .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
                    // $message .= "*Dewi Risnawati* : 089604169403 \n";
                    // $message .= "*Kusnadi* : 085247088167 \n";
                    // if (env("WA_KONTAK_ADMIN")) {
                    //     $message .= "*".env("NAMA_KONTAK_ADMIN")."* : ".env("WA_KONTAK_ADMIN")." \n";
                    // }
                    // if (env("WA_KONTAK_ADMIN_2")) {
                    //     $message .= "*".env("NAMA_KONTAK_ADMIN_2")."* : ".env("WA_KONTAK_ADMIN_2")." \n";
                    // }
                    
                    Helper::sendWa($cekUser->no_wa, $message);
                }
    
                return redirect()->route('cek-otp.page', ['no_wa'=>$cekUser->no_wa,'token'=>$encrypt]);
            }

            
        }

        return redirect()->back()->with('warning', 'Tidak ditemukan akun dengan no whatsapp ini');
    }

    public function otpPage($no_wa)
    {   
        
        if(!request()->token){
            return redirect('/login');
        }
        $otp_key = Session::get('otp');;
        $password = $no_wa.Helper::getIp().date("Ymd").$otp_key;
        $decrypt = openssl_decrypt(request()->token,"AES-128-ECB",$password);
        
        if(md5($no_wa) !== md5($decrypt)){
            return redirect('/login');
        }
        $cekUser = User::where('no_wa', $no_wa)->first();
        if (!$cekUser) {
            return redirect()->route('login');
        }
        $kontakAdmins = Helper::kontakAdmin($cekUser->partai_id,$cekUser->kabupaten_kota_id);
        return view('auth.cek-otp', compact('no_wa','kontakAdmins'));
    }

    public function otpAuth(Request $request)
    {
        
        $cekUser = User::where('no_wa', $request->no_wa)->first();
        if(!$cekUser){
            return redirect()->back()->with('warning', 'User tidak ditemukan');
        }
        $otp = $request->no_1.$request->no_2.$request->no_3.$request->no_4.$request->no_5.$request->no_6;
        $cek = (new Otp)->validate($request->no_wa, $otp);
        //get last6digit from $cekUser->no_wa
        $last6digit = substr($cekUser->no_wa, -6);
        if($cek->status || env("APP_ENV") == "local" || ($last6digit == $otp && $cekUser->role == "saksi")){
            
            $cekAuth = auth()->login($cekUser);
            try {
                Helper::addUserLog("Login ke aplikasi",json_encode([
                    "otp"=>$otp,
                    "status"=>$cek->status,
                    "last_6_digit"=>$last6digit
                ]));
            } catch (\Throwable $th) {
                //throw $th;
                Log::error($th);
            }
            if (auth()->user()->role == "saksi") {
                return redirect()->route('user-saksi.home');
            } else {
                return redirect()->route('dashboard');
            }
        }
        return redirect()->back()->with('warning', 'Tidak dapat melakukan verifikasi OTP');
    }

    public function resendOtp($no_wa){
        $cekUser = User::where('no_wa', $no_wa)->first();
        if(!$cekUser){
            return redirect('/login');
        }
        $lastOtp = ModelsOtp::where('identifier',$no_wa)->latest()->first();
        if($lastOtp){
            $lastTime = new \DateTime($lastOtp->created_at);
            $lastTime->add(new \DateInterval('PT' . 5 . 'M'));

            if ($lastTime > new \DateTime()) {
                return redirect()->back()->with('warning', 'Mohon tunggu 5 menit sebelum mengirim kode otp lagi');
            }
        }
        $otp = (new Otp)->generate($no_wa, 'numeric', 6, 5);
        $message = "Kode OTP untuk login aplikasi *Pilkada " . env("APP_NAME") . "* : ";
        $message .= "\n";
        $message .= $otp->token;
        $message .= "\n";
        $message .= "\n";
        $kontakAdmins = Helper::kontakAdmin($cekUser->partai_id,$cekUser->kabupaten_kota_id);
        if(count($kontakAdmins) > 0){
            $message .= "jika ada yang ingin ditanyakan silahkan hubungi : \n";
            foreach ($kontakAdmins as $kontak) {
                $message .= "*".$kontak['nama']."* : ".$kontak['no_wa']." \n";
            }
        }
        
        // $message .= "*Dewi Risnawati* : 089604169403 \n";
        // $message .= "*Kusnadi* : 085247088167 \n";
        // if (env("WA_KONTAK_ADMIN")) {
        //     $message .= "*".env("NAMA_KONTAK_ADMIN")."* : ".env("WA_KONTAK_ADMIN")." \n";
        // }
        // if (env("WA_KONTAK_ADMIN_2")) {
        //     $message .= "*".env("NAMA_KONTAK_ADMIN_2")."* : ".env("WA_KONTAK_ADMIN_2")." \n";
        // }
        
        Helper::sendWa($no_wa, $message);
        $otp_key = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 8);
        Session::put('otp',$otp_key);
        $password = $no_wa.Helper::getIp().date("Ymd").$otp_key;
        $encrypt = openssl_encrypt($no_wa,"AES-128-ECB",$password);
        return redirect()->route('cek-otp.page', ['no_wa'=>$no_wa,'token'=>$encrypt])->with('success','Otp berhasil dikirim ulang');
    }

    public function passwordPage($no_wa)
    {
        $cekUser = User::where('no_wa', $no_wa)->first();
        if (!$cekUser) {
            return redirect()->route('login');
        }
        return view('auth.cek-password', compact('no_wa'));
    }

    public function passwordAuth(Request $request)
    {   
        $request->validate([
            'no_wa' => 'required|max:20|min:10',
            'password' => 'required'
        ]);

        $credentials = $request->only('no_wa', 'password');
        $cek = auth()->attempt($credentials);

        if ($cek) {
            Helper::addUserLog("Login ke aplikasi");
            if (auth()->user()->role == "saksi") {
                // if ($request->no_wa == $request->password) {
                //     return redirect()->route('user-saksi.change-password.index')->with('warning', 'Silahkan update password anda');

                // }
                return redirect()->route('user-saksi.home');
            } else {
                // if ($request->no_wa == $request->password) {
                //     return redirect()->route('setting.new-password')->with('warning', 'Silahkan update password anda');
                // }
                return redirect()->route('dashboard');
            }
        }

        return redirect()->back()->with('warning', 'No Telp or Password is wrong');
    }
}
