<?php

namespace App\Http\Controllers;

use App\DataTables\KelurahanDesasDataTable;
use App\Helpers\Helper;
use App\Models\KelurahanDesa;
use App\Models\Kecamatan;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class KelurahanDesaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = KelurahanDesa::with('kecamatan.kabupaten_kota')->where('nama','like','%'.$q.'%');
    //     if(request()->kecamatan_id){
    //         $datas = $datas->where('kecamatan_id',request()->kecamatan_id);
    //     } else if(request()->kabupaten_kota_id){
    //         $datas = $datas->whereHas('kecamatan',function($w){
    //             $w->where('kabupaten_kota_id',request()->kabupaten_kota_id);
    //         });
    //     } else if(request()->provinsi_id){
    //         $datas = $datas->whereHas('kecamatan',function($w){
    //             $w->whereHas('kabupaten_kota',function($w){
    //                 $w->where('provinsi_id',request()->provinsi_id);
    //             });
    //         });
    //     }
    //     $datas = $datas->paginate(10)->appends(['q'=>$q]);
    //     $provinsis = Provinsi::all();
    //     return view('kelurahan-desa.index',compact('datas','q','provinsis'));
    // }

    public function index(KelurahanDesasDataTable $dataTable)
    {   
        $provinsis = Provinsi::all();
        return $dataTable->render('kelurahan-desa.index',compact('provinsis'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {   
        $kecamatans = Kecamatan::all();
        return view('kelurahan-desa.create',compact('kecamatans'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|unique:kelurahan_desas,nama,NULL,NULL,deleted_at,NULL',
            'kecamatan_id' => 'required|exists:kecamatans,id'
        ]);

        DB::beginTransaction();
        try {
            $kelurahanDesa = KelurahanDesa::create($request->all());
            DB::commit();
            Helper::addUserLog("Menambah data kelurahan/desa ".$kelurahanDesa->nama);
            return redirect()->route('master-data.kelurahan-desa.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kelurahan-desa.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(KelurahanDesa $kelurahanDesa)
    {
        return view('kelurahan-desa.show',compact('kelurahanDesa'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {   
        $kelurahanDesa = KelurahanDesa::findOrFail($id);
        $kecamatans = Kecamatan::all();
        return view('kelurahan-desa.edit',['data'=>$kelurahanDesa,'kecamatans'=>$kecamatans]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {   
        $kelurahanDesa = KelurahanDesa::findOrFail($id);
        $request->validate([
            'nama' => 'required|unique:kelurahan_desas,nama,'.$kelurahanDesa->id,
            'kecamatan_id' => 'required|exists:kecamatans,id'
        ]);

        DB::beginTransaction();
        try {
            $kelurahanDesa->update($request->all());
            DB::commit();
            Helper::addUserLog("Mengubah data kelurahan/desa ".$kelurahanDesa->nama);
            return redirect()->route('master-data.kelurahan-desa.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kelurahan-desa.index')->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {   
        $kelurahanDesa = KelurahanDesa::findOrFail($id);
        if($kelurahanDesa->tps()->count() > 0){
            return redirect()->back()->with('warning','Data tidak bisa dihapus, data ini masih dipakai di data lain'); 
        }
        DB::beginTransaction();
        try {
            $kelurahanDesa->delete();
            DB::commit();
            Helper::addUserLog("Menghapus data kelurahan/desa ".$kelurahanDesa->nama);
            return redirect()->route('master-data.kelurahan-desa.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kelurahan-desa.index')->with('error','Data gagal dihapus');
        }
    }
}
