<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Imports\NoWaImport;
use App\Models\User;
use Ichtrojan\Otp\Otp;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class GeneratorOtpController extends Controller
{
    public function index(){
        if(auth()->user()->role != "admin" && auth()->user()->role != "koordinator-kabupaten-kota"){
            return abort(404);
        }
        return view('generator-otp.index');
    }

    public function generate(Request $request){
        if($request->hasFile('file')){
            $request->validate([
                'file' => 'required|mimes:xlsx,xls,csv'
            ]);
            $importClass = new NoWaImport;
            $import = Excel::import($importClass,$request->file);
            $no_wa_arr = $importClass->no_was;
            $request->no_wa = implode("\r\n",$no_wa_arr);
        } else {
            $no_wa_arr = explode("\r\n",$request->no_wa);
        }
        $cekUsers = User::whereIn('no_wa', $no_wa_arr)->get();
        $results = [];
        // if(!$cekUser){
        //     return redirect()->back()->with('warning','user dengan no wa : '.$request->no_wa.' tidak ditemukan');
        // }
        // if($cekUser->role != "saksi"){
        //     return redirect()->back()->with('warning','hanya untuk user saksi');
        // }

        foreach ($no_wa_arr as $no_wa) {
            if(trim($no_wa) != ""){
                $otp = (new Otp)->generate($no_wa, 'numeric', 6, 5);
                $results[$no_wa] = $otp->token;
            }
            $cek = $cekUsers->where('no_wa',$no_wa)->first();
            if($cek && $cek->role !== "saksi"){
                return redirect()->back()->with('warning','hanya untuk user saksi : '.$no_wa)->withInput($request->all());
            }
        }
        
        Helper::addUserLog("generate OTP untuk no wa : ".implode(", ",$no_wa_arr));
        return view('generator-otp.index',['results'=>$results,'no_wa'=>$request->no_wa]);
    }
}
