<?php

namespace App\Http\Controllers;

use App\DataTables\DptsDataTable;
use App\Helpers\Helper;
use App\Imports\DptImport;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Partai;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class DptController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Dpt::with('tps.kelurahan_desa.kecamatan.kabupaten_kota');
    //     if($q != ""){
    //         $datas = $datas->where(function($w)use($q){
    //             $w->where('nama','like','%'.$q.'%')
    //             ->orWhere('nik',$q)
    //             ->orWhere('rt',$q)
    //             ->orWhere('rw',$q)
    //             // ->orWhereHas('tps',function($wt)use($q){
    //             //     $wt->where('nomor','like','%'.$q.'%');
    //             // })
    //             ;
    //         });
    //     }
    //     if(auth()->user()->role == "koordinator-kelurahan-desa"){
    //         $datas = $datas->whereHas('tps',function($w){
    //             $w->where('kelurahan_desa_id',auth()->user()->kelurahan_desa_id);
    //         });
    //     }

    //     if(auth()->user()->role == "koordinator-kecamatan"){
    //         $datas = $datas->whereHas('tps.kelurahan_desa',function($w){
    //             $w->where('kecamatan_id',auth()->user()->kecamatan_id);
    //         });
    //     }

    //     if(auth()->user()->role == "koordinator-kabupaten-kota"){
    //         $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan',function($w){
    //             $w->where('kabupaten_kota_id',auth()->user()->kabupaten_kota_id);
    //         });
    //     }
    //     $datas = $datas->orderBy('created_at','DESC')->paginate(10)->appends(['q'=>$q]);
    //     return view('dpt.index',compact('datas','q'));
    // }

    public function index(DptsDataTable $dataTable)
    {
      
        $provinsis = Provinsi::all();
        return $dataTable->render('dpt.index', compact('provinsis'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {   
        $provinsis = Provinsi::all();
        return view('dpt.create',compact('provinsis'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required',
            'jenis_kelamin'=>'required'
        ]);

        DB::beginTransaction();
        try {
            $dpt = Dpt::create($request->all());
            DB::commit();
            Helper::addUserLog("Menambah dpt : ".$dpt->nama." | ".$dpt->nik);
            return redirect()->route('dpt.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('dpt.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Dpt $dpt)
    {
        return view('dpt.show',compact('dpt'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {   
        $dpt = Dpt::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->findOrFail($id);
        $provinsis = Provinsi::all();
        return view('dpt.edit',['data'=>$dpt,'provinsis'=>$provinsis]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,$id)
    {
        $request->validate([
            'nama' => 'required',
            'jenis_kelamin'=>'required'
        ]);
        $dpt = Dpt::findOrFail($id);

        DB::beginTransaction();
        try {
            if($request->tps_id != $dpt->tps_id){
                $dpt->users()->update(['status'=>'tidak sesuai']);
            }
            $dpt->update($request->all());
            if($request->nik){
                $dpt->users()->update(['nik'=>$request->nik]);
            }
            
            DB::commit();
            Helper::addUserLog("Mengubah dpt : ".$dpt->nama." | ".$dpt->nik);
            return redirect()->route('dpt.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {   
        $dpt = Dpt::findOrFail($id);
        if($dpt->users()->count() > 0){
            return redirect()->back()->with('error','Data tidak dapat dihapus karena masih terkait dengan data user');
        }
        DB::beginTransaction();
        try {
            $dpt->delete();
            DB::commit();
            Helper::addUserLog("Menghapus dpt : ".$dpt->nama." | ".$dpt->nik);
            return redirect()->route('dpt.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('dpt.index')->with('error','Data gagal dihapus');
        }
    }

    public function importView(){
        $kabupatenKotas = KabupatenKota::all();
        return view('dpt.import',compact('kabupatenKotas'));
    }

    public function import(Request $request){
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        $file = $request->file('file');
        $newImport = new DptImport();
        if($request->has('kabupaten_kota_id') && $request->kabupaten_kota_id != null){
            $newImport->metode = "2";
            $newImport->kabupaten_kota_id = $request->kabupaten_kota_id;
        }
        DB::beginTransaction();
        $import = Excel::import($newImport,$file);
        DB::commit();
        Helper::addUserLog("Mengimport data dpt");
        return redirect()->route('dpt.index')->with('success','Proses import sedang dilakukan silahkan tunggu beberapa saat lagi...');
    }
}
