<?php

namespace App\Http\Controllers;

use App\Imports\DpsImport;
use App\Models\Dps;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class DpsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {   
        $q = request()->query('q');
        $datas = Dps::with('tps.kelurahan_desa.kecamatan.kabupaten_kota');
        if($q != ""){
            $datas = $datas->where('nama','like','%'.$q.'%');
        }
        if(auth()->user()->role == "koordinator-kelurahan-desa"){
            $datas = $datas->whereHas('tps',function($w){
                $w->where('kelurahan_desa_id',auth()->user()->kelurahan_desa_id);
            });
        }

        if(auth()->user()->role == "koordinator-kecamatan"){
            $datas = $datas->whereHas('tps.kelurahan_desa',function($w){
                $w->where('kecamatan_id',auth()->user()->kecamatan_id);
            });
        }

        if(auth()->user()->role == "koordinator-kabupaten-kota"){
            $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan',function($w){
                $w->where('kabupaten_kota_id',auth()->user()->kabupaten_kota_id);
            });
        }
        $datas = $datas->orderBy('created_at','DESC')->paginate(10)->appends(['q'=>$q]);
        return view('dps.index',compact('datas','q'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {   
        $provinsis = Provinsi::all();
        return view('dps.create',compact('provinsis'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required',
            'jeni_kelamin'=>'required'
        ]);

        DB::beginTransaction();
        try {
            Dps::create($request->all());
            DB::commit();
            return redirect()->route('dps.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('dps.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Dps $dps)
    {
        return view('dps.show',compact('dps'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {   
        $dps = Dps::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->findOrFail($id);
        $provinsis = Provinsi::all();
        return view('dps.edit',['data'=>$dps,'provinsis'=>$provinsis]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,$id)
    {
        $request->validate([
            'nama' => 'required',
            'jeni_kelamin'=>'required'
        ]);
        $dps = Dps::findOrFail($id);

        DB::beginTransaction();
        try {
            $dps->update($request->all());
            DB::commit();
            return redirect()->route('dps.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('dps.index')->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {   
        $dps = Dps::findOrFail($id);
        DB::beginTransaction();
        try {
            $dps->delete();
            DB::commit();
            return redirect()->route('dps.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('dps.index')->with('error','Data gagal dihapus');
        }
    }

    public function importView(){
        return view('dps.import');
    }

    public function import(Request $request){
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        $file = $request->file('file');
        DB::beginTransaction();
        $import = Excel::import(new DpsImport,$file);
        DB::commit();
        return redirect()->route('dps.index')->with('success','Data berhasil diimport');
    }
}
