<?php

namespace App\Http\Controllers;

use App\Models\Calon;
use App\Models\Dps;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Suara;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;

class DashboardController extends Controller
{
    public function index()
    {

        $semuaData = Cache::remember('semua_data_dashboard', 45, function () {
            $jumlahDps = Dps::query();
            $jumlahDpt = Dpt::query();
            $jumlahTps = Tps::query();
            $jumlahSaksi = User::where('role', 'saksi');
            $jumlahUser = User::count('id');
            $jumlahKoordinatorKelurahanDesa = User::where('role', 'koordinator-kelurahan-desa');
            $jumlahKoordinatorKecamatan = User::where('role', 'koordinator-kecamatan');

            if (auth()->user()->role == "koordinator-kelurahan-desa") {
                $jumlahDps = $jumlahDps->whereHas('tps', function ($w) {
                    $w->where('kelurahan_desa_id', auth()->user()->kelurahan_desa_id);
                });

                // $jumlahDps = $jumlahDps->where('kelurahan_desa_id',auth()->user()->kelurahan_desa_id);

                // $jumlahDpt = $jumlahDpt->where('kelurahan_desa_id',auth()->user()->kelurahan_desa_id);
                $jumlahDpt = $jumlahDpt->whereHas('tps', function ($w) {
                    $w->where('kelurahan_desa_id', auth()->user()->kelurahan_desa_id);
                });

                $jumlahSaksi = $jumlahSaksi->where('kelurahan_desa_id', auth()->user()->kelurahan_desa_id);

                $jumlahKoordinatorKelurahanDesa = $jumlahKoordinatorKelurahanDesa->where('kelurahan_desa_id', auth()->user()->kelurahan_desa_id);
            }

            if (auth()->user()->role == "koordinator-kecamatan") {
                $jumlahDps = $jumlahDps->whereHas('tps.kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', auth()->user()->kecamatan_id);
                });

                $jumlahDpt = $jumlahDpt->whereHas('tps.kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', auth()->user()->kecamatan_id);
                });

                $jumlahTps = $jumlahTps->whereHas('kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', auth()->user()->kecamatan_id);
                });

                $jumlahSaksi = $jumlahSaksi->whereHas('kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', auth()->user()->kecamatan_id);
                });

                $jumlahKoordinatorKelurahanDesa = $jumlahKoordinatorKelurahanDesa->whereHas('kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', auth()->user()->kecamatan_id);
                });

                $jumlahKoordinatorKecamatan = $jumlahKoordinatorKecamatan->where('kecamatan_id', auth()->user()->kecamatan_id);


            }

            if (auth()->user()->role == "koordinator-kabupaten-kota") {
                $jumlahDps = $jumlahDps->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });

                $jumlahDpt = $jumlahDpt->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });

                $jumlahTps = $jumlahTps->whereHas('kelurahan_desa.kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });

                $jumlahSaksi = $jumlahSaksi->whereHas('kelurahan_desa.kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });

                $jumlahKoordinatorKelurahanDesa = $jumlahKoordinatorKelurahanDesa->whereHas('kelurahan_desa.kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });

                $jumlahKoordinatorKecamatan = $jumlahKoordinatorKecamatan->whereHas('kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });

            }

            $jumlahDps = $jumlahDps->count('id');
            $jumlahDpt = $jumlahDpt->count('id');
            $jumlahTpsClone = clone $jumlahTps;
            $jumlahTpsTerinput = $jumlahTpsClone->has('suaras')->count('id');
            $jumlahTps = $jumlahTps->count('id');
            $jumlahSaksi = $jumlahSaksi->count('id');
            $jumlahKoordinatorKelurahanDesa = $jumlahKoordinatorKelurahanDesa->count('id');
            $jumlahKoordinatorKecamatan = $jumlahKoordinatorKecamatan->count('id');
            // $kabupatenKotas = KabupatenKota::select('kabupaten_kotas.id','kecamatans.id',DB::raw('COUNT(dpt.id) as total_dpt'))
            // ->with('kecamatans')
            // ->join('kecamatans', 'kecamatans.kabupaten_kota_id', '=', 'kabupaten_kotas.id')
            // ->join('kelurahan_desas', 'kelurahan_desas.kecamatan_id', '=', 'kecamatans.id')
            // ->join('tps', 'tps.kelurahan_desa_id', '=', 'kelurahan_desas.id')
            // ->leftJoin('dpt', 'dpt.tps_id', '=', 'tps.id')
            // ->groupBy('kabupaten_kotas.id', 'kecamatans.id')
            // ->get();
            $kabupatenKotas = KabupatenKota::select('kabupaten_kotas.*')
                ->join('kecamatans', 'kecamatans.kabupaten_kota_id', '=', 'kabupaten_kotas.id')
                ->with([
                    'kecamatans' => function ($wk) {
                        $wk->select('kecamatans.id', 'kecamatans.nama', 'kecamatans.kabupaten_kota_id', DB::raw('COUNT(dpt.id) as total_dpt'))
                            ->join('kelurahan_desas', 'kelurahan_desas.kecamatan_id', '=', 'kecamatans.id')
                            ->join('tps', 'tps.kelurahan_desa_id', '=', 'kelurahan_desas.id')
                            ->leftJoin('dpt', 'dpt.tps_id', '=', 'tps.id')
                            ->groupBy('kecamatans.id');
                    }
                ])
                ->groupBy('kabupaten_kotas.id')
                ->get();
            $apexChartData = [];
            foreach ($kabupatenKotas as $kabupatenKota) {
                $hash = md5($kabupatenKota->nama);
                $color = substr($hash, 0, 6);
                $apexChartData[] = [
                    "nama" => $kabupatenKota->nama,
                    "colors" => [
                        "#" . $color
                    ],
                    "series" => [
                        [
                            "name" => "DPT",
                            "data" => $kabupatenKota->kecamatans->map(function ($k) {
                                return [
                                    "x" => $k->nama,
                                    "y" => $k->total_dpt,
                                    "fillColor" => "#" . substr(md5($k->nama), 0, 6)
                                ];
                            })->toArray()
                        ]
                    ]
                ];
            }

            $kotasTps = Cache::remember('kotasTps', 120, function () {
                return KabupatenKota::has(relation: 'kecamatans')->with([
                    'kecamatans.kelurahan_desas' => function ($w) {
                        $w->with([
                            'tps' => function ($wt) {
                                $wt->withCount('suaras')->withCount('dpt')->withSum('suaras', 'total_suara');
                            }
                        ]);
                    }
                ])->get();
            });
            $chartTpsData = [];
            $chartDptData = [];
            $chartSuaraData = [];

            foreach ($kotasTps as $kota) {
                $chartTpsData[$kota->nama] = [];
                $chartDptData[$kota->nama] = [];
                foreach ($kota->kecamatans as $kecamatan) {
                    $chartTpsData[$kota->nama][$kecamatan->nama] = [];
                    $chartDptData[$kota->nama][$kecamatan->nama] = [];
                    foreach ($kecamatan->kelurahan_desas as $kelurahan_desa) {
                        $chartTpsData[$kota->nama][$kecamatan->nama][$kelurahan_desa->nama] = $kelurahan_desa->tps->count();
                        $chartDptData[$kota->nama][$kecamatan->nama][$kelurahan_desa->nama] = $kelurahan_desa->tps->sum('dpt_count');
                        $chartSuaraData[$kota->nama][$kecamatan->nama][$kelurahan_desa->nama] = $kelurahan_desa->tps->sum('suaras_sum_total_suara');
                    }
                }
            }

            $calons = Calon::withSum('suara_details', 'jumlah_suara')->orderBy('nomor', 'asc')->get();
            $tidakSah = Suara::sum('suara_tidak_sah');
            $request = request();
            $calonSuaraPerKota = Calon::select('calons.id as calon_id', 'calons.nomor as calon_nomor', 'suaras.tps_id', 'calons.nama_calon as calon', 'calons.nama_wakil_calon as wakil_calon', 'kabupaten_kotas.id as kabupaten_kota_id', 'kabupaten_kotas.nama as kota', DB::raw('SUM(suara_details.jumlah_suara) as total_suara'), DB::raw('SUM(suaras.suara_tidak_sah) as total_suara_tidak_sah'))
                ->join('suara_details', function ($join) {
                    $join->on('suara_details.calon_id', '=', 'calons.id')
                        ->on('suara_details.deleted_at', 'is', DB::raw('NULL'));
                })
                ->join('suaras', function ($join) {
                    $join->on('suaras.id', '=', 'suara_details.suara_id')
                        ->on('suaras.status', '=', DB::raw('"approve"'))
                        ->on('suaras.deleted_at', 'is', DB::raw('NULL'));
                })
                ->join('tps', 'tps.id', '=', 'suaras.tps_id')
                ->join('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
                ->join('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
                ->join('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
                ->where(function ($w) use ($request) {
                    if ($request->kabupaten_kota_id != "") {
                        $w->where('kabupaten_kotas.id', $request->kabupaten_kota_id);
                    }

                    if ($request->kecamatan_id != "") {
                        $w->where('kecamatans.id', $request->kecamatan_id);
                    }

                    if ($request->kelurahan_desa_id != "") {
                        $w->where('kelurahan_desas.id', $request->kelurahan_desa_id);
                    }
                })
                ->orderBy('calon_nomor', 'asc')
                ->groupBy('calon_id', 'kabupaten_kotas.id')
                ->get();
            $dataPerKota = [];
            foreach ($kotasTps as $kota) {
                $data = [
                    "id" => $kota->id,
                    "nama" => $kota->nama,
                    "jumlah_dpt" => $kota->kecamatans->sum(function ($d) {
                        return $d->kelurahan_desas->sum(function ($d) {
                            return $d->tps->sum('dpt_count');
                        });
                    }),
                    "jumlah_suara" => $kota->kecamatans->sum(function ($d) {
                        return $d->kelurahan_desas->sum(function ($d) {
                            return $d->tps->sum('suaras_sum_total_suara');
                        });
                    }),
                    "jumlah_tps" => $kota->kecamatans->sum(function ($d) {
                        return $d->kelurahan_desas->sum(function ($w) {
                            return $w->tps->count();
                        });
                    }),
                    "jumlah_tps_terinput" => $kota->kecamatans->sum(function ($d) {
                        return $d->kelurahan_desas->sum(function ($d) {
                            return $d->tps->where('suaras_count', '>', 0)->count();
                        });
                    }),
                    "jumlah_dpt_belum_nyoblos" => $kota->kecamatans->sum(function ($d) {
                        return $d->kelurahan_desas->sum(function ($d) {
                            return $d->tps->where('suaras_count', 0)->sum('dpt_count');
                        });
                    })
                ];
                $calonnya = $calonSuaraPerKota->where('kabupaten_kota_id', $kota->id)->toArray();
                $data['calons'] = [];
                foreach ($calonnya as $c) {
                    $data['calons'][] = $c;
                }
                $dataPerKota[] = $data;

            }
            return [
                "jumlahDps"=>$jumlahDps,
                "jumlahTps"=>$jumlahTps,
                "jumlahTpsTerinput"=>$jumlahTpsTerinput,
                "jumlahSaksi"=>$jumlahSaksi,
                "jumlahDpt"=>$jumlahDpt,
                "jumlahKoordinatorKelurahanDesa"=>$jumlahKoordinatorKelurahanDesa,
                "jumlahKoordinatorKecamatan"=>$jumlahKoordinatorKecamatan,
                "kabupatenKotas"=>$kabupatenKotas,
                "apexChartData"=>$apexChartData,
                "chartTpsData"=>$chartTpsData,
                "chartDptData"=>$chartDptData,
                "calons"=>$calons,
                "tidakSah"=>$tidakSah,
                "chartSuaraData"=>$chartSuaraData,
                "dataPerKota"=>$dataPerKota
            ];
            //return compact('jumlahDps', 'jumlahTps', 'jumlahTpsTerinput', 'jumlahSaksi', 'jumlahDpt', 'jumlahKoordinatorKelurahanDesa', 'jumlahKoordinatorKecamatan', 'kabupatenKotas', 'apexChartData', 'chartTpsData', 'chartDptData', 'calons', 'tidakSah', 'chartSuaraData', 'dataPerKota');
        });
        return view('dashboard', $semuaData);
    }
}
