<?php

namespace App\Http\Controllers;

use App\DataTables\CalonsDataTable;
use App\Helpers\Helper;
use App\Models\Calon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class CalonController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Calon::where(function($w)use($q){
    //         $w->where('nama_calon','like','%'.$q.'%')
    //         ->orWhere('nama_wakil_calon','like','%'.$q.'%');
    //     })->paginate(10)->appends(['q'=>$q]);
    //     return view('calon.index',compact('datas','q'));
    // }

    public function index(CalonsDataTable $dataTable)
    {
        return $dataTable->render('calon.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('calon.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama_calon' => 'required'
        ]);

        DB::beginTransaction();
        try {
            $calon = Calon::create($request->all());
            DB::commit();
            Helper::addUserLog("Menambah data calon ".$calon->nama_calon." / ".$calon->nama_wakil_calon);
            return redirect()->route('master-data.calon.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.calon.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Calon $calon)
    {
        return view('calon.show',compact('calon'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Calon $calon)
    {
        return view('calon.edit',['data'=>$calon]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Calon $calon)
    {
        $request->validate([
            'nama_calon' => 'required'
        ]);

        DB::beginTransaction();
        try {
            $calon->update($request->all());
            DB::commit();
            Helper::addUserLog("Mengubah data calon ".$calon->nama_calon." / ".$calon->nama_wakil_calon);
            return redirect()->route('master-data.calon.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.calon.index')->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Calon $calon)
    {   
        if($calon->suara_details()->count() > 0){
            return redirect()->back()->with('warning','Data tidak bisa dihapus, data ini masih dipakai di data lain'); 
        }
        DB::beginTransaction();
        try {
            $calon->delete();
            DB::commit();
            Helper::addUserLog("Menghapus data calon ".$calon->nama_calon." / ".$calon->nama_wakil_calon);
            return redirect()->route('master-data.calon.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.calon.index')->with('error','Data gagal dihapus');
        }
    }
}
