<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiInputSuaraController extends Controller
{
    public function getData(){
        $user = Auth::user();
        $suara = Suara::where('tps_id', $user->tps_id)->first();
        $calons = Calon::orderBy('nomor', 'asc')->get()->map(function ($calon) use ($suara) {

            return [
                'id' => $calon->id,
                "name" => $calon->nomor . ' : ' . $calon->nama_calon . ' - ' . $calon->nama_wakil_calon,
                "votes" => $suara ? (int)(@$suara->suara_details->where('calon_id', $calon->id)->first()->jumlah_suara ?? 0) : 0,
                "image"=>url($calon->foto_pasangan)
            ];
        })->toArray();

        $totalDpt = Dpt::where('tps_id', $user->tps_id)->count();

        return response()->json([
            'data'=>[
                'suara'=>$suara,
                'calons'=>$calons,
                'total_dpt'=>$totalDpt
            ]
        ]);
    }

    public function save(Request $request){
        return response()->json([
            'message'=>"Belum waktunya penginputan suara"
        ],500);
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return response()->json([
                'message'=>"Belum waktunya penginputan suara"
            ],500);
        }
        $user = Auth::user();
        $suara = Suara::with('multi_user','suara_details')->where('tps_id',$user->tps_id)->first();
        $jsonData = json_decode($request->getContent(), false);
        // $bermasalah_paslon = collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;}) != $jsonData->validVotes;
        // $bermasalah_hak_pilih = $jsonData->jumlah_hak_pilih != ($jsonData->validVotes + $jsonData->invalidVotes);
        // $menang = @$jsonData->candidates[0]->votes ?? 0 > @$jsonData->candidates[1]->votes ?? 0;
        if(!$suara){
            $suara = Suara::create([
                'user_id'=>$user->id,
                'tps_id'=>$user->tps_id,
                'tanggal'=>date("Y-m-d"),
                'total_suara'=>(int)collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;})+(int)$jsonData->invalidVotes,
                'suara_tidak_sah'=>(int)$jsonData->invalidVotes,
                // 'jumlah_dpt'=>$jsonData->jumlah_dpt,
                // 'jumlah_hak_pilih'=>$jsonData->jumlah_hak_pilih,
                'jumlah_dpt'=>0,
                'jumlah_hak_pilih'=>0,
                'suara_sah'=>(int)$jsonData->validVotes,
                // 'bermasalah_paslon'=>$bermasalah_paslon,
                // 'bermasalah_hak_pilih'=>$bermasalah_hak_pilih,
                // 'menang'=>$menang,
                'status'=>'approve',
                'jumlah_surat_suara_digunakan'=>0,
            ]);
            $suara->multi_user()->attach([$user->id]);
        } else {
            tap($suara)->update([
                'total_suara'=>(int)collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;})+(int)$jsonData->invalidVotes,
                'suara_tidak_sah'=>(int)$jsonData->invalidVotes,
                // 'jumlah_dpt'=>$jsonData->jumlah_dpt,
                // 'jumlah_hak_pilih'=>$jsonData->jumlah_hak_pilih,
                'jumlah_dpt'=>0,
                'jumlah_hak_pilih'=>0,
                'suara_sah'=>(int)$jsonData->validVotes,
                // 'bermasalah_paslon'=>$bermasalah_paslon,
                // 'bermasalah_hak_pilih'=>$bermasalah_hak_pilih,
                // 'menang'=>$menang,
                'status'=>'approve',
                'jumlah_surat_suara_digunakan'=>0,
            ]);

            $multi_user_id = @$suara->multi_user->pluck('id')->toArray() ?? [$user->id];
            if(!in_array($user->id,$multi_user_id)){
                $multi_user_id[] = $user->id;
            }
            $suara->multi_user()->sync($multi_user_id);
        }

        foreach ($jsonData->candidates as $candidate) {
            $suara->suara_details()->updateOrCreate([
                'calon_id'=>$candidate->id
            ],[
                'jumlah_suara'=>(int)$candidate->votes,
            ]);
        }
        Helper::addUserLog("Menyimpan suara untuk TPS : ".$user->tps->nomor,json_encode($suara));
        return response()->json([
            'data'=>$suara
        ]);
    }
}
