<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ApiChangePasswordController extends Controller
{
    public function change(Request $request){
        $user = Auth::user();

        $request->validate([
            'password_lama' => 'required|min:5',
            'password_baru' => 'required|min:5'
        ]);

        $cek = Hash::check($request->password_lama, $user->password);

        if($cek){
            $user->update([
                'password'=>bcrypt($request->password_baru)
            ]);
            return response()->json([
                'message'=>'Change password success'
            ]);
        }

        return response()->json([
                'message'=>'Old Password is wrong'
            ],402);
    }
}
