<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Provinsi;
use App\Models\Suara;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class ApiZonaInfoController extends Controller
{
    public function info(Request $request)
    {


        $semuaData = Cache::remember('semua_data', 60, function () use ($request) {
            $jumlahDpt = Dpt::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->whereHas('tps', function ($w) use ($request) {
                        $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                    });
                }
            })->count('id');
            $jumlahTps = Tps::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })->count('id');

            $jumlahTpsTerinput = Tps::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })->withCount('suaras')->having('suaras_count', '>', 0)->count('id');
            $jumlahDptTpsBelumTerinput = Dpt::leftJoin('suaras', 'suaras.tps_id', 'dpt.tps_id')->where('suaras.id', '=', null)->count('dpt.id');
            $jumlahSaksi = User::where('role', 'saksi')->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('kecamatan_id', $request->kecamatan_id);
                }
                if ($request->kelurahan_desa_id != "") {
                    $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })->count('id');
            $jumlahInputSuara = User::where('role', 'saksi')->withCount('suaras')->having('suaras_count', '>', 0)->count();
            $jumlahUser = User::count('id');
            $jumlahKoordinatorKelurahanDesa = User::where('role', 'koordinator-kelurahan-desa')->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('kecamatan_id', $request->kecamatan_id);
                }
                if ($request->kelurahan_desa_id != "") {
                    $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })->count('id');
            $jumlahKoordinatorKecamatan = User::where('role', 'koordinator-kecamatan')->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('kecamatan_id', $request->kecamatan_id);
                }
            })->count('id');


            $storageUsage = $this->getStorageUsage();
            $cpuUsage = $this->getCpuUsage();
            $memoryUsage = $this->getMemoryUsage();
            $suaraCalons = $this->jumlahSuaraCalon($request);
            $suaraKabupatenKota = $this->jumlahSuaraKabupatenKota($request);
            $dptKabupatenKota = $this->jumlahDptKabupatenKota($request);
            $tpsKabupatenKota = $this->jumlahTpsKabupatenKota($request);
            $saksiKabupatenKota = $this->jumlahSaksiKabupatenKota($request);
            $koorkabKabupatenKota = $this->jumlahKoordinatorKabupatenKotaKabupatenKota($request);
            $koorcamKabupatenKota = $this->jumlahKoordinatorKecamatanKabupatenKota($request);
            $koordesKabupatenKota = $this->jumlahKoordinatorKelurahanDesaKabupatenKota($request);
            $jumlahSuara = Suara::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->whereHas('tps', function ($w) use ($request) {
                        $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                    });
                }
            })->sum('total_suara');
            $jumlahDptTps = Suara::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->whereHas('tps', function ($w) use ($request) {
                        $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                    });
                }
            })->sum('jumlah_dpt');
            $jumlahSuaraSah = Suara::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->whereHas('tps', function ($w) use ($request) {
                        $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                    });

                }
            })->sum('suara_sah');
            $jumlahSuaraTidakSah = Suara::where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->whereHas('tps', function ($w) use ($request) {
                        $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                    });
                }
            })->sum('suara_tidak_sah');

            return [
                'jumlah_dpt' => (int) $jumlahDpt,
                "jumlah_dpt_belum_nyoblos"=>(int)$jumlahDptTpsBelumTerinput,
                "jumlah_dpt_tps" => (int) $jumlahDptTps,
                'jumlah_suara' => (int) $jumlahSuara,
                "suara_sah" => (int) $jumlahSuaraSah,
                "suara_tidak_sah" => (int) $jumlahSuaraTidakSah,
                'jumlah_tps' => (int) $jumlahTps,
                'jumlah_tps_terinput'=>(int) $jumlahTpsTerinput,
                'jumlah_saksi' => (int) $jumlahSaksi,
                'jumlah_input_suara' => (int)$jumlahInputSuara,
                'jumlah_user' => (int) $jumlahUser,
                'jumlah_koordinator_kelurahan_desa' => (int) $jumlahKoordinatorKelurahanDesa,
                'jumlah_koordinator_kecamatan' => (int) $jumlahKoordinatorKecamatan,
                'storage_usage' => $storageUsage,
                'cpu_usage' => $cpuUsage,
                'memory_usage' => $memoryUsage,
                'suara_calon' => $suaraCalons,
                'suara_kabupaten_kota' => $suaraKabupatenKota,
                'dpt_kabupaten_kota' => $dptKabupatenKota,
                'tps_kabupaten_kota' => $tpsKabupatenKota,
                'saksi_kabupaten_kota' => $saksiKabupatenKota,
                'koorkab_kabupaten_kota' => $koorkabKabupatenKota,
                'koorcam_kabupaten_kota' => $koorcamKabupatenKota,
                'koordes_kabupaten_kota' => $koordesKabupatenKota
            ];
        });


        return response()->json($semuaData);
    }

    private function jumlahSuaraCalon(Request $request)
    {
        $calons = Calon::withSum([
            'suara_details' => function ($w) use ($request) {
                $w->whereHas('suara', function ($w) use ($request) {
                    $w->where('status', 'approve');

                    if ($request->kabupaten_kota_id != "") {
                        $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                            $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                        });
                    }

                    if ($request->kecamatan_id != "") {
                        $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                            $w->where('kecamatan_id', $request->kecamatan_id);
                        });
                    }

                    if ($request->kelurahan_desa_id != "") {
                        $w->whereHas('tps', function ($w) use ($request) {
                            $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                        });
                    }
                });


            }
        ], 'jumlah_suara')->get();

        $calons = $calons->map(function ($data) {
            return [
                "id" => $data->id,
                "nomor" => $data->nomor,
                "nama_calon" => $data->nama_calon,
                "nama_wakil_calon" => $data->nama_wakil_calon,
                "foto_pasangan" => url($data->foto_pasangan),
                "jumlah_suara" => (int) $data->suara_details_sum_jumlah_suara
            ];
        })->toArray();

        $suaraTidakSah = Suara::where('status', 'approve');
        if ($request->kabupaten_kota_id != "") {
            $suaraTidakSah = $suaraTidakSah->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
            });
        }

        if ($request->kecamatan_id != "") {
            $suaraTidakSah = $suaraTidakSah->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                $w->where('kecamatan_id', $request->kecamatan_id);
            });
        }

        if ($request->kelurahan_desa_id != "") {
            $suaraTidakSah = $suaraTidakSah->whereHas('tps', function ($w) use ($request) {
                $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
            });
        }
        $calons[] = [
            "jumlah_suara_tidak_sah" => (int) $suaraTidakSah->sum('suara_tidak_sah')
        ];
        return $calons;
    }

    private function jumlahSuaraKabupatenKota(Request $request)
    {
        $kotas = KabupatenKota::all();
        $calonSuaraPerKota = Calon::select('calons.id as calon_id', 'suaras.tps_id', 'calons.nama_calon as calon', 'calons.nama_wakil_calon as wakil_calon', 'kabupaten_kotas.id as kabupaten_kota_id', 'kabupaten_kotas.nama as kota', DB::raw('SUM(suara_details.jumlah_suara) as total_suara'), DB::raw('SUM(suaras.suara_tidak_sah) as total_suara_tidak_sah'))
            ->join('suara_details', function ($join) {
                $join->on('suara_details.calon_id', '=', 'calons.id')
                    ->on('suara_details.deleted_at', 'is', DB::raw('NULL'));
            })
            ->join('suaras', function ($join) {
                $join->on('suaras.id', '=', 'suara_details.suara_id')
                    ->on('suaras.status', '=', DB::raw('"approve"'))
                    ->on('suaras.deleted_at', 'is', DB::raw('NULL'));
            })
            ->join('tps', 'tps.id', '=', 'suaras.tps_id')
            ->join('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->join('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->join('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('kabupaten_kotas.id', $request->kabupaten_kota_id);
                }

                if ($request->kecamatan_id != "") {
                    $w->where('kecamatans.id', $request->kecamatan_id);
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->where('kelurahan_desas.id', $request->kelurahan_desa_id);
                }
            })
            ->groupBy('calon_id', 'kabupaten_kotas.id')
            ->get();

        $calons = Calon::all();
        $hasil = [];

        foreach ($kotas as $index => $kota) {
            $hasil[$index] = [
                "id" => $kota->id,
                "nama" => $kota->nama,
                "total_suara" => 0,
                "total_suara_tidak_sah" => 0,
                "calon" => []
            ];

            foreach ($calons as $calon) {
                $hasil[$index]['calon'][] = [
                    "id" => $calon->id,
                    "nama_calon" => $calon->nama_calon,
                    "nama_wakil_calon" => $calon->nama_wakil_calon,
                    'total_suara' => 0,
                ];
            }


        }


        foreach ($calonSuaraPerKota as $suara) {

            $index = -1;
            foreach ($hasil as $key => $value) {
                if ($value['id'] == $suara->kabupaten_kota_id) {
                    $index = $key;
                    break;
                }
            }
            if ($index >= 0) {
                foreach ($hasil[$index]['calon'] as $key => $calon) {
                    if ($calon['id'] == $suara->calon_id) {
                        $hasil[$index]['calon'][$key] = [
                            "id" => $suara->calon_id,
                            "nama_calon" => $suara->calon,
                            "nama_wakil_calon" => $suara->wakil_calon,
                            'total_suara' => (int) $suara->total_suara,
                        ];
                    }
                }

                $hasil[$index]['total_suara'] += (int) $suara->total_suara;
                $hasil[$index]['total_suara_tidak_sah'] = (int) $suara->total_suara_tidak_sah;
            }
        }

        foreach ($hasil as $key => $value) {
            $hasil[$key]['total_suara'] += $hasil[$key]['total_suara_tidak_sah'];
        }




        return $hasil;

    }

    private function jumlahDptKabupatenKota(Request $request)
    {
        $dptPerKota = Dpt::select(DB::raw('COUNT(*) as jumlah_dpt'), 'kabupaten_kotas.id', 'kabupaten_kotas.nama')
            ->leftJoin('tps', 'tps.id', '=', 'dpt.tps_id')
            ->leftJoin('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->leftJoin('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->leftJoin('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('tps.kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('tps.kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->whereHas('tps', function ($w) use ($request) {
                        $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                    });
                }
            })
            ->groupBy('kabupaten_kotas.id')
            ->get();
        return $dptPerKota;

    }

    private function jumlahTpsKabupatenKota(Request $request)
    {
        $tpsPerKota = Tps::select(DB::raw('COUNT(*) as jumlah_tps'), 'kabupaten_kotas.id', 'kabupaten_kotas.nama')
            ->leftJoin('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->leftJoin('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->leftJoin('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->whereHas('kelurahan_desa.kecamatan', function ($w) use ($request) {
                        $w->where('kabupaten_kota_id', $request->kabupaten_kota_id);
                    });
                }

                if ($request->kecamatan_id != "") {
                    $w->whereHas('kelurahan_desa', function ($w) use ($request) {
                        $w->where('kecamatan_id', $request->kecamatan_id);
                    });
                }

                if ($request->kelurahan_desa_id != "") {
                    $w->where('kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })
            ->groupBy('kabupaten_kotas.id')
            ->get();
        return $tpsPerKota;

    }

    private function jumlahSaksiKabupatenKota(Request $request)
    {
        $saksiPerKota = User::select(DB::raw('COUNT(*) as jumlah_saksi'), 'kabupaten_kotas.id', 'kabupaten_kotas.nama')
            ->where('role', 'saksi')
            ->join('tps', 'tps.id', '=', 'users.tps_id')
            ->join('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->join('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->join('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('users.kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('users.kecamatan_id', $request->kecamatan_id);
                }
                if ($request->kelurahan_desa_id != "") {
                    $w->where('users.kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })
            ->groupBy('kabupaten_kotas.id')
            ->get();
        return $saksiPerKota;
    }

    private function jumlahKoordinatorKabupatenKotaKabupatenKota(Request $request)
    {
        $koorkabPerKota = User::select(DB::raw('COUNT(*) as jumlah_koorkab'), 'kabupaten_kotas.id', 'kabupaten_kotas.nama')
            ->where('role', 'koordinator-kabupaten-kota')
            ->join('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'users.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('users.kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('users.kecamatan_id', $request->kecamatan_id);
                }
                if ($request->kelurahan_desa_id != "") {
                    $w->where('users.kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })
            ->groupBy('kabupaten_kotas.id')
            ->get();
        return $koorkabPerKota;
    }

    private function jumlahKoordinatorKecamatanKabupatenKota(Request $request)
    {
        $koorcamPerKota = User::select(DB::raw('COUNT(*) as jumlah_koorcam'), 'kabupaten_kotas.id', 'kabupaten_kotas.nama')
            ->where('role', 'koordinator-kecamatan')
            ->join('kecamatans', 'kecamatans.id', '=', 'users.kecamatan_id')
            ->join('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('users.kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('users.kecamatan_id', $request->kecamatan_id);
                }
                if ($request->kelurahan_desa_id != "") {
                    $w->where('users.kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })
            ->groupBy('kabupaten_kotas.id')
            ->get();
        return $koorcamPerKota;
    }

    private function jumlahKoordinatorKelurahanDesaKabupatenKota(Request $request)
    {
        $koordesPerKota = User::select(DB::raw('COUNT(*) as jumlah_koordes'), 'kabupaten_kotas.id', 'kabupaten_kotas.nama')
            ->where('role', 'koordinator-kelurahan-desa')
            ->join('kelurahan_desas', 'kelurahan_desas.id', '=', 'users.kelurahan_desa_id')
            ->join('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->join('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where(function ($w) use ($request) {
                if ($request->kabupaten_kota_id != "") {
                    $w->where('users.kabupaten_kota_id', $request->kabupaten_kota_id);
                }
                if ($request->kecamatan_id != "") {
                    $w->where('users.kecamatan_id', $request->kecamatan_id);
                }
                if ($request->kelurahan_desa_id != "") {
                    $w->where('users.kelurahan_desa_id', $request->kelurahan_desa_id);
                }
            })
            ->groupBy('kabupaten_kotas.id')
            ->get();
        return $koordesPerKota;
    }

    private function getStorageUsage()
    {
        $data = Cache::remember('storage_usage', 60, function () {
            $total_space = disk_total_space("/");
            $free_space = disk_free_space("/");
            $used_space = $total_space - $free_space;
            $totalDB = DB::select('SELECT 
            ROUND(sum(data_length + index_length)/1024/1024) AS "db_size"
        FROM information_schema.TABLES 
        WHERE TABLE_SCHEMA = "' . env("DB_DATABASE") . '"
        GROUP BY TABLE_SCHEMA;')[0]->db_size;

            $data = [
                'total' => round($total_space / (1024 * 1024 * 1024), 2),
                'used' => round($used_space / (1024 * 1024 * 1024), 2),
                'free' => round($free_space / (1024 * 1024 * 1024), 2),
                'totalDB' => (int) $totalDB
            ];
            return $data;
        });

        return $data;
    }

    private function getCpuUsage()
    {
        $cpuUsage = Cache::remember('cpu_usage', 60, function () {
            $cpuUsage = 0;
            if (stristr(PHP_OS, 'win')) {
                // For Windows
                $output = shell_exec("wmic cpu get loadpercentage");
                if ($output) {
                    $lines = explode("\n", trim($output));
                    $cpuUsage = intval($lines[1]);
                }
            } else {
                // For Unix/Linux
                $loads = sys_getloadavg();
                $core_nums = trim(shell_exec("grep -P '^processor' /proc/cpuinfo|wc -l"));
                $load = round($loads[0] / ($core_nums + 1) * 100, 2);
                //$cpuUsage = $load[0] * 100;
                $cpuUsage = $load;
            }
            return $cpuUsage;
        });

        return $cpuUsage;
    }

    private function getMemoryUsage()
    {
        $data = Cache::remember('memory_usage', 60, function () {
            $totalMemory = 0;
            $usedMemory = 0;

            if (stristr(PHP_OS, 'win')) {
                // For Windows
                $output = shell_exec("wmic OS get FreePhysicalMemory,TotalVisibleMemorySize /Value");
                if ($output) {
                    preg_match('/TotalVisibleMemorySize=(\d+)/', $output, $totalMemoryMatch);
                    preg_match('/FreePhysicalMemory=(\d+)/', $output, $freeMemoryMatch);

                    $totalMemory = $totalMemoryMatch[1] * 1024; // KB to Bytes
                    $freeMemory = $freeMemoryMatch[1] * 1024;   // KB to Bytes
                    $usedMemory = $totalMemory - $freeMemory;
                }
            } else {
                // For Unix/Linux
                $output = shell_exec("free -b");
                if ($output) {
                    $lines = explode("\n", $output);
                    $memoryLine = explode(" ", preg_replace('!\s+!', ' ', $lines[1]));
                    $totalMemory = intval($memoryLine[1]);
                    $usedMemory = intval($memoryLine[2]);
                }
            }

            return [
                'total' => $totalMemory,
                'used' => $usedMemory,
                'free' => $totalMemory - $usedMemory,
            ];
        });

        return $data;
    }


}
