<?php

namespace App\Http\Controllers\Api;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiSaveSuaraController extends Controller
{
    public function save(Request $request){
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return response()->json([
                'message'=>"Belum waktunya penginputan suara"
            ],500);
        }
        $user = Auth::user();
        $suara = Suara::where('tps_id',$user->tps_id)->first();
        $jsonData = json_decode($request->getContent(), false);
        if(!$suara){
            $suara = Suara::create([
                'user_id'=>$user->id,
                'tps_id'=>$user->tps_id,
                'tanggal'=>date("Y-m-d"),
                'total_suara'=>(int)collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;})+$jsonData->invalidVotes,
                // 'suara_tidak_sah'=>$jsonData->invalidVotes
                'suara_tidak_sah'=> 0
            ]);
        } else {
            tap($suara)->update([
                'total_suara'=>(int)collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;})+$jsonData->invalidVotes,
                // 'suara_tidak_sah'=>$jsonData->invalidVotes
                'suara_tidak_sah'=> 0
            ]);
        }

        foreach ($jsonData->candidates as $candidate) {
            $suara->suara_details()->updateOrCreate([
                'calon_id'=>$candidate->id
            ],[
                'jumlah_suara'=>$candidate->votes
            ]);
        }
        Helper::addUserLog("Menyimpan suara untuk TPS : ".$user->tps->nomor,json_encode($suara));
      
        return response()->json($suara);
    }
}
