<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\KabupatenKota;
use App\Models\Tps;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ApiJumlahTpsController extends Controller
{
    public function jumlahTpsKabupatenKota($provinsi_id)
    {
        $kotas = KabupatenKota::all();
        $tpsPerKota = Tps::select(DB::raw('COUNT(*) as jumlah_tps'),'kabupaten_kotas.id','kabupaten_kotas.nama')
            ->leftJoin('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->leftJoin('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->leftJoin('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where('kabupaten_kotas.provinsi_id', $provinsi_id)
            ->groupBy( 'kabupaten_kotas.id')
            ->get();
        return response()->json($tpsPerKota);
   
    }
}
