<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ApiJumlahDptController extends Controller
{
    public function jumlahDptKabupatenKota($provinsi_id)
    {
        $dptPerKota = Dpt::select(DB::raw('COUNT(*) as jumlah_dpt'),'kabupaten_kotas.id','kabupaten_kotas.nama')
            ->leftJoin('tps', 'tps.id', '=', 'dpt.tps_id')
            ->leftJoin('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->leftJoin('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->leftJoin('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where('kabupaten_kotas.provinsi_id', $provinsi_id)
            ->groupBy( 'kabupaten_kotas.id')
            ->get();
        return response()->json($dptPerKota);
   
    }
}
