<?php

namespace App\Http\Controllers;

use App\Models\Dps;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Pengumuman;
use App\Models\Suara;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class AjaxController extends Controller
{

    function __construct()
    {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: *');
        header('Access-Control-Allow-Headers: *');
    }
    public function ajaxKabupatenKota(Request $request)
    {
        $provinsi_id = $request->provinsi_id;
        $datas = KabupatenKota::where('provinsi_id', $provinsi_id);
        if (auth()->user()) {
            $user = Auth::user()->load('kelurahan_desa.kecamatan');
            if ($user->role == "koordinator-kabupaten-kota") {
                $datas = $datas->where('id', $user->kabupaten_kota_id);
            }
            if ($user->role == "koordinator-kecamatan") {
                $datas = $datas->where('id', $user->kecamatan->kabupaten_kota_id);
            }
            if ($user->role == "koordinator-kelurahan-desa") {
                $datas = $datas->where('id', $user->kelurahan_desa->kecamatan->kabupaten_kota_id);
            }
        }
        return response()->json($datas->get());
    }
    public function ajaxKecamatan(Request $request)
    {
        $kabupaten_kota_id = $request->kabupaten_kota_id;
        $datas = Kecamatan::query();
        if ($kabupaten_kota_id != "" && $kabupaten_kota_id != null) {
            $datas = $datas->where('kabupaten_kota_id', $kabupaten_kota_id);
        }
        if (auth()->user()) {
            $user = Auth::user()->load('kelurahan_desa.kecamatan');
            if ($user->role == "koordinator-kecamatan") {
                $datas = $datas->where('id', $user->kecamatan_id);
            }
            if ($user->role == "koordinator-kelurahan-desa") {
                $datas = $datas->where('id', $user->kelurahan_desa->kecamatan_id);
            }
        }
        return response()->json($datas->get());
    }
    public function ajaxKelurahanDesa(Request $request)
    {
        $kecamatan_id = $request->kecamatan_id;
        $datas = KelurahanDesa::query();
        if ($kecamatan_id != "" && $kecamatan_id != null) {
            $datas = $datas->where('kecamatan_id', $kecamatan_id);
        }
        $user = Auth::user();
        if ($user) {
            if ($user->role == "koordinator-kelurahan-desa") {
                $datas = $datas->where('id', $user->kelurahan_desa_id);
            }
        }
        return response()->json($datas->get());
    }
    public function ajaxTps(Request $request)
    {
        $kelurahan_desa_id = $request->kelurahan_desa_id;
        // $datas = Tps::whereHas('kelurahan_desas',function($w)use($kelurahan_desa_id){
        //     $w->where('kelurahan_desa_id',$kelurahan_desa_id);
        // })->get();
        $datas = Tps::query();
        if ($kelurahan_desa_id != "" && $kelurahan_desa_id != null) {
            $datas = $datas->where('kelurahan_desa_id', $kelurahan_desa_id);
        }
        $user = Auth::user();
        if ($user) {
            if ($user->role == "koordinator-kelurahan-desa") {
                $datas = $datas->whereIn('id', @$user->multi_tps->pluck('id')->toArray() ?? []);
            }
        }
        return response()->json($datas->get());
    }
    public function ajaxDps(Request $request)
    {
        $tps_id = $request->tps_id;
        $datas = Dps::where('tps_id', $tps_id)->get();
        return response()->json($datas);
    }

    public function ajaxDpt(Request $request)
    {
        $tps_id = $request->tps_id;
        $datas = Dpt::whereIn('tps_id', explode(",", $tps_id))->get();
        return response()->json($datas);

    }

    public function ajaxUserSaksi(Request $request)
    {
        $kelurahan_desa_id = $request->kelurahan_desa_id;
        $datas = User::where('role', 'saksi')->where('kelurahan_desa_id', $kelurahan_desa_id)->get();
        return response()->json($datas);
    }

    public function saveSuara(Request $request)
    {
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return response()->json([
                'message'=>"Belum waktunya penginputan suara"
            ],403);
        }
        $user = Auth::user();
        $suara = Suara::with('multi_user','suara_details')->where('tps_id', $user->tps_id)->first();
        $jsonData = json_decode($request->getContent(), false);
        // $bermasalah_paslon = collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;}) != $jsonData->validVotes;
        // $bermasalah_hak_pilih = $jsonData->jumlah_hak_pilih != ($jsonData->validVotes + $jsonData->invalidVotes);
        // $menang = @$jsonData->candidates[0]->votes ?? 0 > @$jsonData->candidates[1]->votes ?? 0;
        if (!$suara) {
            $suara = Suara::create([
                'user_id' => $user->id,
                'tps_id' => $user->tps_id,
                'tanggal' => date("Y-m-d"),
                'total_suara' => (int)collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;}) + (int)($jsonData->invalidVotes ?? 0),
                'suara_tidak_sah' => $jsonData->invalidVotes ?? 0,
                // 'jumlah_dpt'=>$jsonData->jumlah_dpt,
                // 'jumlah_hak_pilih'=>$jsonData->jumlah_hak_pilih,
                'jumlah_dpt' => 0,
                'jumlah_hak_pilih' => 0,
                'suara_sah' => $jsonData->validVotes ?? 0,
                // 'bermasalah_paslon'=>$bermasalah_paslon,
                // 'bermasalah_hak_pilih'=>$bermasalah_hak_pilih,
                // 'menang'=>$menang,
                'status' => 'approve',
                'jumlah_surat_suara_digunakan' => 0,
            ]);
            $suara->multi_user()->attach([$user->id]);
        } else {
            $suara->update([
                'total_suara' => (int)collect($jsonData->candidates)->sum(function($v){return (int)$v->votes;}) + (int)($jsonData->invalidVotes),
                'suara_tidak_sah' => $jsonData->invalidVotes ?? 0,
                // 'jumlah_dpt'=>$jsonData->jumlah_dpt,
                // 'jumlah_hak_pilih'=>$jsonData->jumlah_hak_pilih,
                'jumlah_dpt' => 0,
                'jumlah_hak_pilih' => 0,
                'suara_sah' => $jsonData->validVotes ?? 0,
                // 'bermasalah_paslon'=>$bermasalah_paslon,
                // 'bermasalah_hak_pilih'=>$bermasalah_hak_pilih,
                // 'menang'=>$menang,
                'status' => 'approve',
                'jumlah_surat_suara_digunakan' => 0,
            ]);
            $multi_user_id = @$suara->multi_user->pluck('id')->toArray() ?? [$user->id];
            if (!in_array($user->id, $multi_user_id)) {
                $multi_user_id[] = $user->id;
            }
            $suara->multi_user()->sync($multi_user_id);
        }



        foreach ($jsonData->candidates as $candidate) {
            $suara->suara_details()->updateOrCreate([
                'calon_id' => $candidate->id
            ], [
                'jumlah_suara' => $candidate->votes,
            ]);
        }


        return response()->json($suara);
    }

    public function syncStatusUser()
    {
        $users = User::with('tps', 'dpt')->where('role', '!=', 'admin')->get();
        foreach ($users as $user) {
            $status = "sesuai";
            if ($user->dpt_id == null) {
                $cekDpt = Dpt::where(function ($w) use ($user) {
                    $w->where(function ($w) use ($user) {
                        $w->where('nik', $user->nik)->where('nik', '!=', '')->where('nik', '!=', null);
                    })->orWhere('nama', $user->nama);
                })->where('tps_id', $user->tps_id)->first();
                if (!$cekDpt) {
                    $status = "tidak sesuai";
                }
            }

            if ($status == "sesuai") {
                $cekUser = User::where(function ($w) use ($user) {
                    $w->where(function ($w) use ($user) {
                        $w->where('nik', $user->nik)->where('nik', '!=', '')->where('nik', '!=', null);
                    })->orWhere('nama', $user->nama);
                })->where('id', '!=', $user->id)->where('role', $user->role)->where('tps_id', $user->tps_id)->first();
                if ($cekUser) {
                    $status = "sudah ada";
                } else {
                    $cekUser = User::where('no_wa', $user->no_wa)->count();
                    if ($cekUser > 1) {
                        $status = "sudah ada";
                    }
                }


            }


            if ($user->status != $status) {
                $user->update([
                    'status' => $status
                ]);
            }
        }
        return count($users);
    }

    public function syncNoWaUser()
    {
        $users = User::whereNull('no_wa')->where('no_telp', '!=', null)->get();
        foreach ($users as $user) {
            $user->update([
                'no_wa' => $user->no_telp
            ]);
        }
        return count($users);
    }

    public function syncNikUser()
    {
        $users = User::with('dpt')->where('role', '!=', 'admin')->whereNull('nik')->get();
        foreach ($users as $user) {
            if ($user->dpt && $user->dpt->nik != null) {
                $user->update([
                    'nik' => $user->dpt->nik
                ]);
            }
        }
        return count($users);
    }

    public function fixNoWaUser()
    {
        $users = User::where('no_wa', '!=', null)->where('role', '!=', 'admin')->get();
        foreach ($users as $user) {
            $no_wa = str_replace("'", "", $user->no_wa);
            //remove all symbol and alphabet from $no_wa
            $no_wa = preg_replace('/[^\p{L}\p{N}\s]/u', '', $no_wa);

            //check if first character not 0
            if (mb_substr($no_wa, 0, 1) != '0') {
                $no_wa = '0' . $no_wa;
            }
            $user->update([
                'no_wa' => $no_wa
            ]);
        }
        return count($users);
    }

    public function fixNikUser()
    {
        $users = User::with('dpt')->where('role', '!=', 'admin')->get();
        foreach ($users as $user) {
            $user->update([
                'nik' => preg_replace('/[^\p{L}\p{N}\s]/u', '', $user->nik)
            ]);
        }
        return count($users);

    }

    public function updateAktifPengumuman($id)
    {
        $pengumuman = Pengumuman::find($id);
        $pengumuman->update([
            'aktif' => !$pengumuman->aktif
        ]);
        return response()->json(['message' => 'success']);
    }
}
