<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

class UserKoordinatorsExport implements FromCollection,WithHeadings,WithMapping,ShouldAutoSize
{   
    public $q = "";
    public $koordinator = "kelurahan-desa";
    private $no = 0;
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {   
        $q = $this->q;
        $datas = User::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi', 'kelurahan_desa','partai','multi_tps','dpt')
        ->whereIn('role', ['koordinator-kabupaten-kota','koordinator-kecamatan','koordinator-kelurahan-desa']);
        if ($q != "") {
            $datas = $datas->where(function ($w) use ($q) {
                $w->where('nama', 'like', '%' . $q . '%')
                ->orWhere('no_telp','like','%'.$q.'%')
                ->orWhereHas('tps', function ($wtps) use ($q) {
                    $wtps->where('nomor', $q);
                });
            });
        }

        $datas = $datas->where('role','koordinator-'.$this->koordinator);

        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            $datas = $datas->where('kelurahan_desa_id', auth()->user()->kelurahan_desa_id);
        }

        if (auth()->user()->role == "koordinator-kecamatan") {
            $datas = $datas->where('kecamatan_id', auth()->user()->kecamatan_id);
        }

        if (auth()->user()->role == "koordinator-kabupaten-kota") {
            $datas = $datas->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
        }

        

       
        $datas = $datas->orderBy('created_at', 'DESC')->get();
        return $datas;
    }

    public function headings(): array
    {
        return [
            '#',
            'NIK',
            'NAMA',
            'NO TELP',
            'NO WA',
            'EMAIL',
            'PARTAI',
            'KOORDINATOR',
            'TPS TUGAS',
            'KEL/DES TUGAS',
            'KEC TUGAS',
            'KAB/KOT TUGAS',
            'PROV TUGAS'
        ];
    }

    public function map($user): array
    {   
        $this->no ++;
        return [
            $this->no,
            $user->nik,
            $user->nama,
            $user->no_telp,
            $user->no_wa,
            $user->email,
            $user->partai->nama,
            $this->koordinator,
            $this->koordinator == "kelurahan-desa"?implode(";",$user->multi_tps->pluck('nomor')->toArray()):$user->tps->nomor,
            $user->kelurahan_desa->nama,
            $user->kecamatan->nama,
            $user->kabupaten_kota->nama,
            $user->provinsi->nama,
        ];
    }

    // public function columnFormats(): array
    // {
    //     return [
    //         'B' => '0',
    //         'D' => '0',
    //     ];
    // }
}
