<?php

namespace App\Exports;

use App\Models\Tps;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class TpssExport implements FromCollection,WithHeadings,WithMapping,ShouldAutoSize
{   
    private $no = 0;
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $datas = Tps::with('kelurahan_desa.kecamatan.kabupaten_kota')->withCount('suaras');
        if(request()->kelurahan_desa_id){
            $datas = $datas->where('kelurahan_desa_id',request()->kelurahan_desa_id);
        } else if(request()->kecamatan_id){
            $datas = $datas->whereHas('kelurahan_desa',function($w){
                $w->where('kecamatan_id',request()->kecamatan_id);
            });
        } else if(request()->kabupaten_kota_id){
            $datas = $datas->whereHas('kelurahan_desa',function($w){
                $w->whereHas('kecamatan',function($w){
                    $w->where('kabupaten_kota_id',request()->kabupaten_kota_id);
                });
            });
        } else if(request()->provinsi_id){
            $datas = $datas->whereHas('kelurahan_desa',function($w){
                $w->whereHas('kecamatan',function($w){
                    $w->whereHas('kabupaten_kota',function($w){
                        $w->where('provinsi_id',request()->provinsi_id);
                    });
                });
            });
        }

        if(request()->status == "sudah"){
            $datas = $datas->having('suaras_count','=',1);
        }

        if(request()->status == "belum"){
            $datas = $datas->having('suaras_count','=',0);
        }

        return $datas->get();
    }

    public function headings(): array
    {
        $headings = [
            '#',
            'NOMOR',
            'KELURAHAN/DESA',
            'KECAMATAN',
            'KABUPATEN/KOTA',
            'STATUS'
        ];

        return $headings;
    }

    public function map($data): array
    {   
        $this->no ++;
        $values = [
            $this->no,
            $data->nomor,
            $data->kelurahan_desa->nama,
            $data->kelurahan_desa->kecamatan->nama,
            $data->kelurahan_desa->kecamatan->kabupaten_kota->nama,
            $data->suaras_count > 0 ? "Sudah" : "Belum",
        ];
        

        return $values;
    }
}
