<?php

namespace App\Exports;

use App\Models\Suara;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class SuarasExport implements FromCollection,WithHeadings,WithMapping,ShouldAutoSize
{   
    private $no = 0;

    public $calons;

    public function __construct($calons)
    {   
       $this->calons = $calons;
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $datas = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota','user','multi_user.partai')
        ->withCount('multi_user')
        ->with(['tps'=>function($w){
            $w->withCount('dpt');
        }])
        ->with(['suara_details'=>function($w){
            $w->orderBy('calon_id','asc');
        }]);

        $datas = $datas
        ->leftJoin(DB::raw('file_lampirans as l1'),function($j){
            $j->on('l1.suara_id','=','suaras.id')
            ->on('l1.nama','=',DB::raw('"lembar-1"'));
        })
        ->leftJoin(DB::raw('file_lampirans as l2'),function($j){
            $j->on('l2.suara_id','=','suaras.id')
            ->on('l2.nama','=',DB::raw('"lembar-2"'));
        })
        ->leftJoin(DB::raw('file_lampirans as l3'),function($j){
            $j->on('l3.suara_id','=','suaras.id')
            ->on('l3.nama','=',DB::raw('"lembar-3"'));
        });


        if(auth()->user()->role == "koordinator-kelurahan-desa"){
            $datas = $datas->whereHas('tps',function($w){
                $w->where('kelurahan_desa_id',auth()->user()->kelurahan_desa_id);
            });
        }

        if(auth()->user()->role == "koordinator-kecamatan"){
            $datas = $datas->whereHas('tps.kelurahan_desa',function($w){
                $w->where('kecamatan_id',auth()->user()->kecamatan_id);
            });
        }

        if(auth()->user()->role == "koordinator-kabupaten-kota"){
            $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan',function($w){
                $w->where('kabupaten_kota_id',auth()->user()->kabupaten_kota_id);
            });
        }
    
        if (request()->kelurahan_desa_id) {
            $datas = $datas->whereHas('tps',function($w){
                $w->where('kelurahan_desa_id', request()->kelurahan_desa_id);
            });
        } else if (request()->kecamatan_id) {
            $datas = $datas->whereHas('tps',function($w){
                $w->whereHas('kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', request()->kecamatan_id);
                });
            });
        } else if (request()->kabupaten_kota_id) {
            $datas = $datas->whereHas('tps',function($w){
                $w->whereHas('kelurahan_desa', function ($w) {
                    $w->whereHas('kecamatan', function ($w) {
                        $w->where('kabupaten_kota_id', request()->kabupaten_kota_id);
                    });
                });
            });
        } else if (request()->provinsi_id) {
            $datas = $datas->whereHas('tps',function($w){
                $w->whereHas('kelurahan_desa', function ($w) {
                    $w->whereHas('kecamatan', function ($w) {
                        $w->whereHas('kabupaten_kota', function ($w) {
                            $w->where('provinsi_id', request()->provinsi_id);
                        });
                    });
                });
            });
        }

        if (request()->partai_id) {
            $datas = $datas->whereHas('multi_user',function($w){
                $w->where('partai_id', request()->partai_id);
            });
        }
       
        
        $selects = ['suaras.*',DB::raw('l1.id as lembar_1'),DB::raw('l2.id as lembar_2'),DB::raw('l3.id as lembar_3')];
        foreach ($this->calons as $calon) {
            $datas = $datas->leftJoin('suara_details as paslon_'.$calon->nomor,function($w)use($calon){
                $w->on('paslon_'.$calon->nomor.'.suara_id','=','suaras.id')
                ->on('paslon_'.$calon->nomor.'.calon_id','=',DB::raw($calon->id));
            });
            $selects[] = DB::raw('SUM(paslon_'.$calon->nomor.'.jumlah_suara) as jumlah_suara_paslon_'.$calon->nomor);
            
        }
        $datas = $datas->select($selects);
        $datas = $datas->orderBy('created_at','DESC')->groupBy('suaras.id');
        return $datas->get();
    }

    public function headings(): array
    {
        $headings = [
            '#',
            'DIBUAT',
            'KABUPATEN/KOTA',
            'KECAMATAN',
            'KELURAHAN/DESA',
            'TPS'
        ];

        foreach ($this->calons as $calon) {
            $headings[] = "PASLON ".$calon->nomor;
        }

        $headings[] = "SAKSI BERTUGAS";
        $headings[] = "PARTAI";

        return $headings;
    }

    public function map($data): array
    {   
        $this->no ++;
        $values = [
            $this->no,
            $data->created_at->format('Y-m-d H:i:s'),
            $data->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama,
            $data->tps->kelurahan_desa->kecamatan->nama,
            $data->tps->kelurahan_desa->nama,
            $data->tps->nomor,
        ];
        foreach ($this->calons as $calon) {
            $values[] = $data->{"jumlah_suara_paslon_".$calon->nomor};
        }
        $values[] = implode(", ",(isset($data->multi_user))?$data->multi_user->pluck('nama')->toArray() : []);
        $values[] = implode(", ",(isset($data->multi_user))?$data->multi_user->pluck('partai.nama')->toArray() : []);

        return $values;
    }
}
