<?php
namespace App\Exports\Sheets;

use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Partai;
use App\Models\Tps;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

class MasterDataSheet implements FromView, WithTitle,ShouldAutoSize,WithEvents
{   
    public $user;

    public function __construct($user)
    {   
       $this->user = $user;
    }

    public function view(): View
    {   
        $multiDropdown = [];
        $user = auth()->user();
        $kabupatenKotas = KabupatenKota::with(['kecamatans'=>function($w)use($user){
            if ($user->role == "koordinator-kecamatan") {
                $w = $w->where('id',auth()->user()->kecamatan_id);
            }
    
            if ($user->role == "koordinator-kelurahan-desa") {
                $w = $w->where('id',$user->kecamatan_id)->with(['kelurahan_desas'=>function($w)use($user){
                    $w = $w->where('id',$user->kelurahan_desa_id);
                }]);
            } else {
                $w = $w->with('kelurahan_desas');
            }
        }]);

        if (auth()->user()->role != "admin") {
            $kabupatenKotas = $kabupatenKotas->where('id',auth()->user()->kabupaten_kota_id);
        }

        $kabupatenKotas = $kabupatenKotas->get();
        
        $partais = Partai::all();
        foreach ($kabupatenKotas as $kabupatenKota) {
            $multiDropdown[$kabupatenKota->id] = [
                "nama"=>$kabupatenKota->nama,
                "sub_data"=>[]
            ];
            foreach ($kabupatenKota->kecamatans as $kecamatan) {
                $multiDropdown[$kabupatenKota->id]["sub_data"][$kecamatan->id] = [
                    "nama"=>$kecamatan->nama,
                ];
                foreach ($kecamatan->kelurahan_desas as $desa) {
                    $multiDropdown[$kabupatenKota->id]["sub_data"][$kecamatan->id]['sub_data'][$desa->id] = [
                        "nama"=>$desa->nama,
                        "sub_data"=>$desa->tps()->orderBy(DB::raw('CAST(`nomor` AS SIGNED)'),'ASC')->pluck('nomor','id')->toArray()
                    ];
                }
            }
        }
        return view('saksi.template-excel-master-data',compact('kabupatenKotas','multiDropdown','partais'));
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'MASTER_DATA';
    }

    public function registerEvents(): array
    {   
        $user = $this->user;
        $kabupatenKotas = KabupatenKota::with(['kecamatans'=>function($w)use($user){
            if ($user->role == "koordinator-kecamatan") {
                $w = $w->where('id',auth()->user()->kecamatan_id);
            }
    
            if ($user->role == "koordinator-kelurahan-desa") {
                $w = $w->where('id',$user->kecamatan_id)->with(['kelurahan_desas'=>function($w)use($user){
                    $w = $w->where('id',$user->kelurahan_desa_id);
                }]);
            } else {
                $w = $w->with('kelurahan_desas');
            }
        }]);

        if (auth()->user()->role != "admin") {
            $kabupatenKotas = $kabupatenKotas->where('id',auth()->user()->kabupaten_kota_id);
        }

        $kabupatenKotas = $kabupatenKotas->get();
        $partais =  Partai::all();

        return [
            
            AfterSheet::class => function(AfterSheet $event)use($kabupatenKotas,$partais) {
                
                $event->sheet->getDelegate()->getParent()->addNamedRange(
                    new \PhpOffice\PhpSpreadsheet\NamedRange(
                        'ListPartais',
                        $event->sheet->getDelegate(),
                        '$A$'.(count($kabupatenKotas)+1).':$'.Coordinate::stringFromColumnIndex((count($partais)+1)).'$'.(count($kabupatenKotas)+1)
                    )
                );
               
                $event->sheet->getDelegate()->getParent()->addNamedRange(
                    new \PhpOffice\PhpSpreadsheet\NamedRange(
                        'ListKabupatenKota',
                        $event->sheet->getDelegate(),
                        '$A$1:$A$'.count($kabupatenKotas)
                    )
                );
                $offset = count($kabupatenKotas)+2;
                $index = count($kabupatenKotas)+3;
                $tpsrange = [];
                $kelrange = [];
                foreach ($kabupatenKotas as $index_kab_kota => $kabupatenKota) {
                    
                    $event->sheet->getDelegate()->getParent()->addNamedRange(
                        new \PhpOffice\PhpSpreadsheet\NamedRange(
                            "KEC_".str_replace(' ','_',str_replace("'",'',$kabupatenKota->nama)),
                            $event->sheet->getDelegate(),
                            '$B$'.($index_kab_kota+1).':$'.Coordinate::stringFromColumnIndex(($kabupatenKota->kecamatans->count()+1)).'$'.($index_kab_kota+1)
                        )
                    );
                    
                    foreach ($kabupatenKota->kecamatans as $index_kec => $kecamatan) {
                        $kelrange[$kecamatan->nama] = '$C$'.($offset+($index_kab_kota+1)+($index_kec+1)+1).':$C$'.($kecamatan->kelurahan_desas->count()+($offset+($index_kab_kota+1)+($index_kec+1)+1));
                        $event->sheet->getDelegate()->getParent()->addNamedRange(
                            new \PhpOffice\PhpSpreadsheet\NamedRange(
                                "KEL_DES_".str_replace(' ','_',str_replace("'","",$kecamatan->nama)),
                                $event->sheet->getDelegate(),
                                '$C$'.($offset+($index_kab_kota+1)+($index_kec+1)+1).':$C$'.($kecamatan->kelurahan_desas->count()+($offset+($index_kab_kota+1)+($index_kec+1)))
                            )
                        );
                        
                        foreach ($kecamatan->kelurahan_desas as $index_desa => $kelurahan_desa) {
                            
                            $tps_count = $kelurahan_desa->tps()->count();
                           
                            $event->sheet->getDelegate()->getParent()->addNamedRange(
                                new \PhpOffice\PhpSpreadsheet\NamedRange(
                                    "TPS_".str_replace(' ','_',str_replace("'","",str_replace("-","_",$kelurahan_desa->nama))),
                                    $event->sheet->getDelegate(),
                                    '$D$'.($offset+($index_kab_kota+1)+($index_kec+1)+($index_desa+1)).':$'.Coordinate::stringFromColumnIndex(($tps_count+3))."$".($offset+($index_kab_kota+1)+($index_kec+1)+($index_desa+1))
                                )
                            );
                        }
                        $offset += $kecamatan->kelurahan_desas->count();
    
                    }
                    $offset += $kabupatenKota->kecamatans->count();
                    
                }
               
            },
        ];
    }

}