<?php

namespace App\Console\Commands;

use App\Models\Tps;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class DeleteTps extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tps:delete-tps';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            Tps::whereDoesntHave('users')->delete();
            $this->info('Sukses menghapus data tps');
        } catch (\Throwable $th) {
            Log::error($th);
            $this->error('Gagal menghapus data tps');
        }
    }
}
