<?php

namespace App\Console\Commands;

use App\Models\FileLampiran;
use App\Models\Suara;
use App\Models\SuaraDetail;
use App\Models\Userable;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;

class ClearSuara extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'suara:clear-suara';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear all suara and file lampiran';

    /**
     * Execute the console command.
     */
    public function handle()
    {   
       
        try {
            Schema::disableForeignKeyConstraints();
            FileLampiran::truncate();
            Userable::truncate();
            SuaraDetail::truncate();
            Suara::truncate();
            Schema::enableForeignKeyConstraints();
            $this->info('Sukses menghapus data suara dan file lampiran');
        } catch (\Throwable $th) {
            Log::error($th);
            $this->error('Gagal menghapus data suara dan file lampiran');
        }
    }
}
