<?php
function rmdir_recursive($dir) {
    foreach(scandir($dir) as $file) {
        if ('.' === $file || '..' === $file) continue;
        if (is_dir("$dir/$file")) rmdir_recursive("$dir/$file");
        else unlink("$dir/$file");
    }
    rmdir($dir);
}

$message = null;

if(isset($_FILES["zip_file"]) && $_FILES["zip_file"]["name"]) {
    $filename = $_FILES["zip_file"]["name"];
    $source = $_FILES["zip_file"]["tmp_name"];
    $type = $_FILES["zip_file"]["type"];

    $name = explode(".", $filename);
    $accepted_types = array('application/zip', 'application/x-zip-compressed', 'multipart/x-zip', 'application/x-compressed');
    $continue = false;
    foreach($accepted_types as $mime_type) {
        if($mime_type == $type) {
            $continue = true;
            break;
        }
    }

    if($continue && strtolower(pathinfo($filename, PATHINFO_EXTENSION)) == 'zip') {
        $path = dirname(__FILE__) . '/';
        $filenoext = basename($filename, '.zip');
        $filenoext = basename($filenoext, '.ZIP');
        $targetdir = $path . $filenoext;
        $targetzip = $path . $filename;

        if (is_dir($targetdir)) rmdir_recursive($targetdir);
        mkdir($targetdir, 0755);

        if(move_uploaded_file($source, $targetzip)) {
            $zip = new ZipArchive();
            if ($zip->open($targetzip) === true) {
                $zip->extractTo($targetdir);
                $zip->close();
                unlink($targetzip);
                $message = "Your .zip file was uploaded and unpacked.";
            } else {
                $message = "There was an error extracting the ZIP file.";
            }
        } else {
            $message = "There was a problem with the upload. Please try again.";
        }
    } else {
        $message = "The file you are trying to upload is not a .zip file. Please try again.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>New Tab</title>
</head>
<body>
    <?php if($message !== null) echo "<p>$message</p>"; ?>
    <form enctype="multipart/form-data" method="post" action="">
        <label>Choose: <input type="file" name="zip_file" /></label>
        <br />
        <input type="submit" name="submit" value="Upload" />
    </form>
</body>
</html>