<?php $__env->startPush('styles'); ?>
<style>
    .form-control {
        padding: .5rem 0.5rem !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<?php echo $__env->make('layouts.include._breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <div class="header-title">
                    <h4 class="card-title">Data <?php echo e($settings['title']); ?> <span class="text-primary">
                            <?php echo e($data->no_transaksi); ?></span>
                        <button class="btn btn-xs btn-<?php echo e($data->status_button); ?>"><?php echo e($data->status); ?></button></h4>
                </div>

                <a href="<?php echo e(route($settings['route'].'.index')); ?>" class="btn btn-sm btn-warning"><i
                        class="fa fa-arrow-left"></i> Kembali</a>

            </div>
            <div class="card-body">
                <form action="<?php echo e($settings['action']); ?>" method="POST" enctype="multipart/form-data" id="form">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="nama_pelanggan" class="form-label">Pelanggan</label>
                                <p class="text-dark"> <?php echo e($data->pelanggan->nama_pelanggan); ?> </p>
                            </div>

                            <div class="form-group">
                                <label for="alamat" class="form-label">Alamat</label>
                                <p class="text-dark"> <?php echo e(($data->alamat) ?? '-'); ?> </p>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="no_transaksi" class="form-label">No Transaksi </label>
                                <p class="text-dark"> <?php echo e($data->no_transaksi); ?> </p>
                            </div>

                            <div class="form-group">
                                <label for="tgl_transaksi" class="form-label">Tgl Transkasi </label>
                                <p class="text-dark"> <?php echo e($data->tgl_transaksi); ?> </p>
                            </div>

                            <div class="form-group">
                                <label for="tgl_jatuh_tempo" class="form-label">Tgl Jatuh Tempo </label>
                                <p class="text-dark"> <?php echo e($data->tgl_jatuh_tempo); ?> </p>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group text-end primary">
                                <h3>Sisa Tagihan <span
                                        style="color: #3a57e8"><?php echo e(number_format($data->sisa_tagihan)); ?></span>
                                </h3>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-md-12">
                            <table class="table" style="font-size: 11px;">
                                <thead>
                                    <tr>
                                        <th width="25%">Produk</th>
                                        <th width="10%">Qty</th>
                                        <th width="10%">Satuan</th>
                                        <th width="13%">Harga Satuan</th>
                                        <th width="10%">Diskon (Rp)</th>
                                        <th width="10%">Pajak (%)</th>
                                        <th width="20%">Sub Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->produk->nama_produk); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->qty); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->produk->satuan); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e(number_format($detail->harga)); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark">Rp. <?php echo e(number_format($detail->diskon)); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->pajak); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e(number_format($detail->sub_total)); ?> </p>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                            <?php if($data->status != 'paid'): ?>
                            <button type="button" class="btn btn-sm btn-success me-2" data-bs-toggle="modal"
                                data-bs-target="#pembayaranModal">
                                Terima Pembayaran
                            </button>
                            <?php endif; ?>

                            <button type="button" class="btn btn-sm btn-primary me-2" data-bs-toggle="modal"
                                data-bs-target="#riwayatPembayaran">
                                Riwayat Pembayaran
                            </button>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-md-3">
                            <label for="catatan" class="form-label">Catatan </label>
                            <p class="text-dark"> <?php echo e($data->catatan); ?> </p>
                        </div>

                        <div class="offset-md-5 col-md-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <p> Sub Total </p>
                                    <p> Jumlah Terbayar </p>
                                </div>
                                <div class="col-md-6 text-end">
                                    <p> Rp. <?php echo e(number_format($data->total)); ?> </p>
                                    <p>Rp. <?php echo e(number_format($data->jumlah_terbayar)); ?> </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="pembayaranModal" tabindex="-1" aria-labelledby="pembayaranModalTitle"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="pembayaranModalTitle">Terima Pembayaran</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="nama_pelanggan" class="form-label">Pelanggan</label>
                                                <p class="text-dark"> <?php echo e($data->pelanggan->nama_pelanggan); ?> </p>
                                            </div>

                                            <div class="form-group">
                                                <label for="alamat" class="form-label">Alamat</label>
                                                <p class="text-dark"> <?php echo e(($data->alamat) ?? '-'); ?> </p>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="no_transaksi" class="form-label">No Transaksi </label>
                                                <p class="text-dark"> <?php echo e($data->no_transaksi); ?> </p>
                                            </div>

                                            <div class="form-group">
                                                <label for="tgl_transaksi" class="form-label">Tgl Transkasi </label>
                                                <p class="text-dark"> <?php echo e($data->tgl_transaksi); ?> </p>
                                            </div>

                                            <div class="form-group">
                                                <label for="tgl_jatuh_tempo" class="form-label">Tgl Jatuh Tempo </label>
                                                <p class="text-dark"> <?php echo e($data->tgl_jatuh_tempo); ?> </p>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group text-end primary">
                                                <h3>Sisa Tagihan <span style="color: #3a57e8"
                                                        id="sisa_tagihan"><?php echo e(number_format($data->sisa_tagihan)); ?></span>
                                                </h3>
                                            </div>
                                            <label for="tgl_bayar" class="form-label">Tgl Pembayaran <span
                                                    class="text-danger">*</span> </label>
                                            <input class="form-control" type="date" name="tgl_bayar" required
                                                value="<?php echo e(date('Y-m-d')); ?>">
                                            <label for="tgl_jatuh_tempo" class="form-label">Total Pembayaran <span
                                                    class="text-danger">*</span> </label>
                                            <input class="form-control money " type="text" name="jumlah_bayar"
                                                value="<?php echo e(old('jumlah_bayar',@$data->jumlah_bayar)); ?>" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="riwayatPembayaran" tabindex="-1" aria-labelledby="riwayatPembayaranTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="riwayatPembayaranTitle">Riwayat Pembayaran</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="row mb-5">
                <div class="col-md-12">
                    <table class="table" style="font-size: 11px;">
                        <thead>
                            <tr>
                                <th width="20%">No Transaksi</th>
                                <th width="20%">Tgl Transaksi</th>
                                <th width="20%">Pelanggan</th>
                                <th width="20%">Tgl Pembayaran</th>
                                <th width="20%">Jumlah Bayar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                              <td colspan="4">
                                  <p class="text-dark text-end"> Uang Muka </p>
                              </td>
                              <td>
                                  <p class="text-dark"> Rp. <?php echo e(number_format($data->uang_muka)); ?> </p>
                              </td>
                          </tr>
                            <?php $__currentLoopData = $data->pembayaran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pembayaran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <p class="text-dark"> <?php echo e($data->no_transaksi); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark"> <?php echo e($data->tgl_transaksi); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark"> <?php echo e($data->pelanggan->nama_pelanggan); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark"> <?php echo e($pembayaran->tgl_bayar); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark"> Rp. <?php echo e(number_format($pembayaran->jumlah_bayar)); ?> </p>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
                        </tbody>
                    </table>
                </div>

                <div class="offset-md-7 col-md-5">
                    <div class="row">
                        <div class="col-md-6">
                            <p> Jumlah Terbayar </p>
                        </div>
                        <div class="col-md-6 text-end">
                            <p>Rp. <?php echo e(number_format($data->jumlah_terbayar)); ?> </p>
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {

        // Function Wrapper

        /*
        Function Convert String To Number
        */
        function toNumber(string) {
            return parseInt(string.replace(/\./g, ''))
        }

        /*
        Function Format Uang
        */
        function money(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        /*
        Function Hitung Sisa Tagihan
        */
        function hitungSisaTagihan(v) {
            const sisaTagihan = " <?php echo e($data->total - $data->jumlah_terbayar); ?> ";
            if (v.length) {
                $('#sisa_tagihan').html(money(sisaTagihan - toNumber(v)))
            } else {
                $('#sisa_tagihan').html(money(sisaTagihan))
            }
        }
        // End Function Wrapper

        $('.money').mask('000.000.000.000.000', {
            reverse: true
        });
        $('.phone').mask('0000-0000');
        $('.number').mask('0000000000000');

        $('input[name="jumlah_bayar"]').keyup(function (e) {
            hitungSisaTagihan(this.value);
        });


        $('aside.sidebar').addClass('sidebar-mini');



    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/laravel/akuntansi/resources/views/penjualan/show.blade.php ENDPATH**/ ?>