


<?php $__env->startPush('styles'); ?>
<style>
    .form-control {
        padding: .5rem 0.5rem !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
<?php echo $__env->make('layouts.include._breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12 col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <div class="header-title">
                    <h4 class="card-title">Data <?php echo e($settings['title']); ?> <span class="text-primary">
                            <?php echo e($data->no_transaksi); ?></span>
                        <button class="btn btn-xs btn-<?php echo e($data->status_button); ?>"><?php echo e($data->status); ?></button></h4>
                </div>

                <a href="<?php echo e(route($settings['route'].'.index')); ?>" class="btn btn-sm btn-warning"><i
                        class="fa fa-arrow-left"></i> Kembali</a>

            </div>
            <div class="card-body">
                <form action="<?php echo e($settings['action']); ?>" method="POST" enctype="multipart/form-data" id="form">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="nama_pelanggan" class="form-label">Pelanggan</label>
                                <p class="text-dark"> <?php echo e($data->pelanggan->nama_pelanggan); ?> </p>
                            </div>

                            <div class="form-group">
                                <label for="alamat" class="form-label">Alamat</label>
                                <p class="text-dark"> <?php echo e(($data->alamat) ?? '-'); ?> </p>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="no_transaksi" class="form-label">No Transaksi </label>
                                <p class="text-dark"> <?php echo e($data->no_transaksi); ?> </p>
                            </div>

                            <div class="form-group">
                                <label for="tgl_transaksi" class="form-label">Tgl Transkasi </label>
                                <p class="text-dark"> <?php echo e($data->tgl_transaksi); ?> </p>
                            </div>

                            <div class="form-group">
                                <label for="tgl_jatuh_tempo" class="form-label">Tgl Jatuh Tempo </label>
                                <p class="text-dark"> <?php echo e($data->tgl_jatuh_tempo); ?> </p>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group text-end primary">
                                <h3>Sisa Tagihan <span style="color: #3a57e8" id="sisaTagihan">Rp. <?php echo e(number_format($data->sisa_tagihan)); ?></span>
                                </h3>
                            </div>
                            <div class="form-group text-end primary">
                                <a data-bs-toggle="modal"
                                data-bs-target="#jurnal">
                                <span style="color: #3a57e8">Lihat Jurnal</span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-md-12">
                            <table class="table" style="font-size: 11px;">
                                <thead>
                                    <tr>
                                        <th width="25%">Produk</th>
                                        <th width="10%">Qty</th>
                                        <th width="10%">Satuan</th>
                                        <th width="13%">Harga Satuan</th>
                                        <th width="10%">Diskon</th>
                                        <th width="10%">Pajak (%)</th>
                                        <th width="10%">Pajak Lain (%)</th>
                                        <th width="20%">Sub Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data->detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->produk->nama_produk); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->qty); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->produk->satuan); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e(number_format($detail->harga)); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark">Rp. <?php echo e(number_format($detail->diskon)); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->pajak); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e($detail->pajak_lain); ?> </p>
                                        </td>
                                        <td>
                                            <p class="text-dark"> <?php echo e(number_format($detail->sub_total)); ?> </p>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                            <?php if($data->status != 'paid'): ?>
                            <button type="button" class="btn btn-sm btn-success me-2" data-bs-toggle="modal"
                                data-bs-target="#pembayaranModal">
                                Terima Pembayaran
                            </button>
                            <?php endif; ?>

                            <button type="button" class="btn btn-sm btn-primary me-2" id="riwayat_pembayaran" data-bs-toggle="modal"
                                data-bs-target="#riwayatPembayaran">
                                Riwayat Pembayaran
                            </button>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-md-3">
                            <label for="catatan" class="form-label">Catatan </label>
                            <p class="text-dark"> <?php echo e($data->catatan); ?> </p>
                        </div>

                        <div class="offset-md-5 col-md-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <p> Sub Total </p>
                                    <p> Akun Pemotongan </p>
                                    <p> Pemotongan </p>
                                    <p> Jumlah Terbayar </p>
                                </div>
                                <div class="col-md-6 text-end">
                                    <p id="subTotal" data-value="<?php echo e($data->total); ?>"> Rp. <?php echo e(number_format($data->total)); ?> </p>
                                    <p> <?php echo e(@$data->akunPemotongan->nama_akun ?? "-"); ?></p>
                                    <p>Rp. <?php echo e(number_format($data->pemotongan)); ?></p>
                                    <p class="jumlahTerbayar">Rp. <?php echo e(number_format($data->jumlah_terbayar)); ?> </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="modal fade" id="pembayaranModal" tabindex="-1" aria-labelledby="pembayaranModalTitle"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="pembayaranModalTitle">Terima Pembayaran</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="nama_pelanggan" class="form-label">Pelanggan</label>
                                                <p class="text-dark"> <?php echo e($data->pelanggan->nama_pelanggan); ?> </p>
                                            </div>

                                            <div class="form-group">
                                                <label for="alamat" class="form-label">Alamat</label>
                                                <p class="text-dark"> <?php echo e(($data->alamat) ?? '-'); ?> </p>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="no_transaksi" class="form-label">No Transaksi </label>
                                                <p class="text-dark"> <?php echo e($data->no_transaksi); ?> </p>
                                            </div>

                                            <div class="form-group">
                                                <label for="tgl_transaksi" class="form-label">Tgl Transkasi </label>
                                                <p class="text-dark"> <?php echo e($data->tgl_transaksi); ?> </p>
                                            </div>

                                            <div class="form-group">
                                                <label for="tgl_jatuh_tempo" class="form-label">Tgl Jatuh Tempo </label>
                                                <p class="text-dark"> <?php echo e($data->tgl_jatuh_tempo); ?> </p>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group text-end primary">
                                                <h3>Sisa Tagihan <span style="color: #3a57e8"
                                                        id="sisa_tagihan"><?php echo e(number_format($data->sisa_tagihan)); ?></span>
                                                </h3>
                                            </div>
                                            <label for="tgl_bayar" class="form-label">Tgl Pembayaran <span
                                                    class="text-danger">*</span> </label>
                                            <input class="form-control" type="date" name="tgl_bayar" required
                                                value="<?php echo e(date('Y-m-d')); ?>">

                                            <label for="akun_id" class="form-label">Masuk Ke Akun <span class="text-danger">*</span> </label>
                                            <select class="form-control select2-modal" name="akun_id" tabindex="-1" required>
                                                <option value="">Pilih Akun</option>
                                                <?php $__currentLoopData = $akuns->where('kategori_akun_id', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $akun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($akun->id); ?>" <?php if($akun->id == old('akun_id',@$data->akun_id)): ?> selected <?php endif; ?>><?php echo e($akun->nama_akun); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                                
                                            <label for="tgl_jatuh_tempo" class="form-label">Total Pembayaran <span
                                                    class="text-danger">*</span> </label>
                                            <input class="form-control money " type="text" name="jumlah_bayar" value="<?php echo e(old('jumlah_bayar',@$data->jumlah_bayar)); ?>" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="riwayatPembayaran" tabindex="-1" aria-labelledby="riwayatPembayaranTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="riwayatPembayaranTitle">Riwayat Pembayaran</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="row mb-5">
                <div class="col-md-12">
                    <table class="table" style="font-size: 11px;">
                        <thead>
                            <tr>
                                <th width="20%">No Transaksi</th>
                                <th width="20%">Tgl Transaksi</th>
                                <th width="20%">Masuk Ke Akun</th>
                                <th width="20%">Pelanggan</th>
                                <th width="20%">Tgl Pembayaran</th>
                                <th width="20%">Jumlah Bayar</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data->pembayaran; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pembayaran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <p class="text-dark"> <?php echo e($data->no_transaksi); ?> </p>
                                    </td>
                                    <td>
                                        <p class="text-dark"> <?php echo e($data->tgl_transaksi); ?> </p>
                                    </td>
                                    <td>
                                        <p class="text-dark"> <?php echo e($pembayaran->akun->nama_akun); ?> </p>
                                    </td>
                                    <td>
                                        <p class="text-dark"> <?php echo e($data->pelanggan->nama_pelanggan); ?> </p>
                                    </td>
                                    <td>
                                        <p class="text-dark"> <?php echo e($pembayaran->tgl_bayar); ?> </p>
                                    </td>
                                    <td>
                                        <p class="text-dark nominal_bayar" data-value='<?php echo e($pembayaran->jumlah_bayar); ?>'> Rp. <?php echo e(number_format($pembayaran->jumlah_bayar)); ?> </p>
                                            <input type="number" class="nominal_bayar_input" onfocus="this.value = this.value;" style="display: none" data-id = '<?php echo e($pembayaran->id); ?>' value="<?php echo e($pembayaran->jumlah_bayar); ?>">
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
                        </tbody>
                    </table>
                </div>

                <div class="offset-md-7 col-md-5">
                    <div class="row">
                        <div class="col-md-6">
                            <p> Jumlah Terbayar </p>
                        </div>
                        <div class="col-md-6 text-end">
                            <p class='jumlahTerbayar'>Rp. <?php echo e(number_format($data->jumlah_terbayar)); ?> </p>
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="jurnal" tabindex="-1" aria-labelledby="jurnalTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jurnalTitle">Jurnal <span class="text-primary">#<?php echo e($data->no_transaksi); ?></span> </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="row mb-5">
                <div class="col-md-12">
                    <table class="table" style="font-size: 11px;">
                        <thead>
                            <tr>
                                <th width="20%">Kode Akun</th>
                                <th width="20%">Nama Akun</th>
                                <th width="30%" class="text-center">Debet</th>
                                <th width="30%" class="text-center">Kredit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data->jurnalUmum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jurnalUmum): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <p class="text-dark"> <?php echo e($jurnalUmum->akun->kode_akun); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark"> <?php echo e($jurnalUmum->akun->nama_akun); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark text-center"> Rp. <?php echo e(number_format($jurnalUmum->debet)); ?> </p>
                                </td>
                                <td>
                                    <p class="text-dark text-center"> Rp. <?php echo e(number_format($jurnalUmum->kredit)); ?> </p>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr class="fw-bold">
                                <td colspan="2">
                                    Total
                                </td>
                                <td class="text-center"> Rp. <?php echo e(number_format($data->debet)); ?></td>
                                <td class="text-center"> Rp. <?php echo e(number_format($data->kredit)); ?></td>
                            </tr>
            
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        
        // Function Wrapper

        /*
        Function Convert String To Number
        */
        function toNumber(string) {
            return parseInt(string.replace(/\./g, ''))
        }

        /*
        Function Format Uang
        */
        function money(x) {
            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        /*
        Function Hitung Sisa Tagihan
        */
        function hitungSisaTagihan(v) {
            const sisaTagihan ="<?php echo e($data->total - $data->jumlah_terbayar); ?>";
            if (v.length) {
                // Cek Jika Kelebihan Bayar
                if(sisaTagihan - toNumber(v) < 0){
                    alert('Pembayaran Tidak Dapat Melebihi Sisa Tagihan!')
                    $('#sisa_tagihan').html(money(0))
                    $('input[name="jumlah_bayar"]').val(sisaTagihan)
                }else{
                    $('#sisa_tagihan').html(money(sisaTagihan - toNumber(v)))
                }
            } else {
                $('#sisa_tagihan').html(money(sisaTagihan))
            }
        }
        // End Function Wrapper

        $('.money').mask('000.000.000.000.000', {
            reverse: true
        });
        $('.phone').mask('0000-0000');
        $('.number').mask('0000000000000');

        $('input[name="jumlah_bayar"]').keyup(function (e) {
            hitungSisaTagihan(this.value);
        });


        $('aside.sidebar').addClass('sidebar-mini');

        let terbayar = 0;


        function totalTagihan(){
            terbayar = 0;

            for (let index = 0; index < nominal_bayar.length; index++) {
                terbayar += parseInt(nominal_bayar[index].parentElement.children[1].value);
            }

            let jumlahTerbayar = document.getElementsByClassName('jumlahTerbayar');
            let subTotal = document.getElementById('subTotal');
            let sisaTagihan1 = document.getElementById('sisaTagihan');
            for (let index = 0; index < jumlahTerbayar.length; index++) {
                jumlahTerbayar[index].innerHTML = "Rp. " + terbayar.toLocaleString();
            }
            
            let sisa = parseInt(subTotal.getAttribute('data-value')) - parseInt(terbayar);

            if (sisa <= 0) {
                sisa = 0;
            }

            sisaTagihan1.innerHTML = "Rp. " + sisa.toLocaleString();
        }

        let nominal_bayar = document.getElementsByClassName('nominal_bayar');

        for (let index = 0; index < nominal_bayar.length; index++) {

            nominal_bayar[index].addEventListener('click', (event)=>{
                let value = event.target.getAttribute('data-value');

                let uang_input = event.target.parentElement.children[1];

                event.target.style.display = 'none';
                uang_input.style.display = 'inline-block';

                uang_input.focus();
                


            });
            
        }

        let nominal_bayar_input = document.getElementsByClassName('nominal_bayar_input');

        for (let index = 0; index < nominal_bayar_input.length; index++) {
            nominal_bayar_input[index].addEventListener('keypress', (event)=>{
                if (event.key == 'Enter') {

                    postData('<?php echo e(route("penjualan.update_detail",["id" => $data->id])); ?>','POST', {_token: csrfToken, id: event.target.getAttribute('data-id'), harga: event.target.value})
                    .then(data => {
                        let uang = event.target.parentElement.children[0];
                        event.target.style.display = 'none';
                        uang.style.display = 'inline-block';

                        number = parseInt(event.target.value);

                        uang.innerHTML ="Rp. " + number.toLocaleString();

                        totalTagihan();
                    });
                }
            });
            
        }

        totalTagihan();
        // nominal_bayar.addEventListener('keyup', (event)=> {
        //     console.log('test');
        // });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aplikasiposinfo/public_html/akuntansi.aplikasipos.info/laravel/resources/views/penjualan/show.blade.php ENDPATH**/ ?>