<?php $__env->startSection('form-title'); ?>
    <?php if(isset($data)): ?>
      <?php echo e($settings['title']); ?>

    <?php else: ?>
      <?php echo e($settings['title']); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('form'); ?>
<table class="table">
  <thead>
     <tr>
        <th>No</th>
        <th>Kode Akun</th>
        <th>Nama Akun</th>
        <th>Debet</th>
        <th>Kredit</th>
     </tr>
  </thead>
  <tbody>
    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
      <td><?php echo e($loop->iteration); ?></td>
      <td><?php echo e($data->kode_akun); ?></td>
      <td class="text-primary">
         <a href="<?php echo e(route($settings['route'].'.show', $data->id)); ?>"><?php echo e($data->nama_akun); ?></a>
      </td>
      <td>
        <input class="form-control money debet" type="text" value="<?php echo e(@\Helper::findAkunEkuitas($data->id)->debet ?? 0); ?>" <?php if($data->nama_akun == 'Pembukaan Saldo Ekuitas'): ?> readonly <?php else: ?> name="debet[]" <?php endif; ?>>
      </td>
      <td>
        <input class="form-control money kredit" type="text" value="<?php echo e(@\Helper::findAkunEkuitas($data->id)->kredit ?? 0); ?>" <?php if($data->nama_akun == 'Pembukaan Saldo Ekuitas'): ?> readonly <?php else: ?> name="kredit[]" <?php endif; ?>>
      </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </tfoot>
  <tfoot>
    <tr>
      <td colspan="3" align="right"> Total :</td>
      <td id="totalDebet"></td>
      <td id="totalKredit"></td>
    </tr>
  </tfoot>
</table>

<i class="text-danger">Catatan : Harap konfirmasi untuk mempublikasikan saldo awal dengan ketentuan di bawah ini: Jumlah debit dan kredit harus seimbang. Jika terdapat selisih.., selisih tersebut akan diposkan ke rekening <b>Pembukaan Saldo Ekuitas</b> .</i>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
  $(document).ready(function() {
    $('aside.sidebar').addClass('sidebar-mini');

    /*
    Function Convert String To Number
    */
    function toNumber(string){
      return parseInt(string.replace(/\./g, ''))
    }

    /*
    Function Format Uang
    */
    function money(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    $('form').submit(function (e) { 
      let totalDebet = 0;
      let totalKredit = 0;

      // Hitung Total Debet
      $('.debet').each(function(index, el) {
        var debet = toNumber($(this).val());
        if(debet){
          totalDebet += parseInt(debet);
        }
      });

      // Hitung Total Kredit
      $('.kredit').each(function(index, el) {
        var kredit = toNumber($(this).val());
        if(kredit){
          totalKredit += parseInt(kredit);
        }
      });

      if(totalDebet != totalKredit){
        alert('Jumlah debet dan kredit terdapat selisih sebanyak Rp. ' + money(Math.abs(totalDebet - totalKredit)) + ' , selisih tersebut akan dimasukkan ke akun Pembukaan Saldo Ekuitas.');
      }

      
    });

    function hitungTotal(){
      var totalDebet = 0;
      var totalKredit = 0;

      // Hitung Total Debet
      $('.debet').each(function(index, el) {
        var debet = toNumber($(this).val());
        if(debet){
          totalDebet += parseInt(debet);
        }
      });
      $('#totalDebet').html('Rp. '+ money(totalDebet));

      // Hitung Total Kredit
      $('.kredit').each(function(index, el) {
        var kredit = toNumber($(this).val());
        if(kredit){
          totalKredit += parseInt(kredit);
        }
      });
      $('#totalKredit').html('Rp. '+ money(totalKredit));
    }

    hitungTotal();
    
    $('.debet').keyup(function (e) { 
      hitungTotal();
    });

    $('.kredit').keyup(function (e) { 
      hitungTotal();
    });
  });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/suemerugrup/public_html/akuntansi/resources/views/akun/opening.blade.php ENDPATH**/ ?>