<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito+Sans&display=swap" rel="stylesheet">
    <style>
        .table-primary{
            background: #d8ddfa;
            color: #fff;
        }
        :focus{outline:none;}
        *,*::before,*::after{-webkit-box-sizing:border-box;box-sizing:border-box;}
        body{font-size: 12px;font-family: 'Nunito Sans', sans-serif;}
        h6,h5,h4,h1{margin-top:0;margin-bottom:0;font-weight:500;line-height:1.2;color:#232d42;}
        h1{font-size:-webkit-calc(1.375rem + 1.5vw);font-size:calc(1.375rem + 1.5vw);}
        @media (min-width: 1200px){
        h1{font-size:2.5rem;}
        }
        h4{font-size:-webkit-calc(1.275rem + 0.3vw);font-size:calc(1.275rem + 0.3vw);}
        @media (min-width: 1200px){
        h4{font-size:1.5rem;}
        }
        h5{font-size:1.25rem;}
        h6{font-size:1rem;}
        p{margin-top:0;margin-bottom:1rem;}
        ol,ul{padding-left:2rem;}
        ol,ul{margin-top:0;margin-bottom:1rem;}
        ul ul{margin-bottom:0;}
        small{font-size:0.875em;}
        a{color:#3a57e8;text-decoration:none;}
        a:hover{color:#2e46ba;}
        img,svg{vertical-align:middle;}
        table{caption-side:bottom;border-collapse:collapse;}
        th{font-weight:500;text-align:inherit;text-align:-webkit-match-parent;}
        tbody,tr,td,th{border-color:inherit;border-style:solid;border-width:0;}
        button{-webkit-border-radius:0;border-radius:0;}
        button:focus:not(:focus-visible){outline:0;}
        input,button,select{margin:0;font-family:inherit;font-size:inherit;line-height:inherit;}
        button,select{text-transform:none;}
        [role=button]{cursor:pointer;}
        select{word-wrap:normal;}
        select:disabled{opacity:1;}
        button,[type=button],[type=submit]{-webkit-appearance:button;}
        ::-moz-focus-inner{padding:0;border-style:none;}
        [type=search]{outline-offset:-2px;-webkit-appearance:textfield;}
        .list-inline{padding-left:0;list-style:none;}
        .list-inline-item{display:inline-block;}
        .list-inline-item:not(:last-child){margin-right:.5rem;}
        .img-fluid{max-width:100%;height:auto;}
        .container-fluid{width:100%;padding-right:var(--bs-gutter-x, 1rem);padding-left:var(--bs-gutter-x, 1rem);margin-right:auto;margin-left:auto;}
        .row{--bs-gutter-x:2rem;--bs-gutter-y:0;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;margin-top:-webkit-calc(-1*var(--bs-gutter-y));margin-top:calc(-1*var(--bs-gutter-y));margin-right:-webkit-calc(-0.5*var(--bs-gutter-x));margin-right:calc(-0.5*var(--bs-gutter-x));margin-left:-webkit-calc(-0.5*var(--bs-gutter-x));margin-left:calc(-0.5*var(--bs-gutter-x));}
        .row>*{-webkit-flex-shrink:0;-ms-flex-negative:0;flex-shrink:0;width:100%;max-width:100%;padding-right:-webkit-calc(var(--bs-gutter-x)*.5);padding-right:calc(var(--bs-gutter-x)*.5);padding-left:-webkit-calc(var(--bs-gutter-x)*.5);padding-left:calc(var(--bs-gutter-x)*.5);margin-top:var(--bs-gutter-y);}
        @media (min-width: 576px){
        .col-sm-12{-webkit-box-flex:0;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto;width:100%;}
        }
        @media (min-width: 768px){
        .col-md-3{-webkit-box-flex:0;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto;width:25%;}
        .col-md-12{-webkit-box-flex:0;-webkit-flex:0 0 auto;-ms-flex:0 0 auto;flex:0 0 auto;width:100%;}
        }
        .table{--bs-table-bg:transparent;--bs-table-accent-bg:transparent;--bs-table-striped-color:#8A92A6;--bs-table-striped-bg:rgba(138, 146, 166, 0.03);--bs-table-active-color:#8A92A6;--bs-table-active-bg:rgba(138, 146, 166, 0.1);--bs-table-hover-color:#8A92A6;--bs-table-hover-bg:rgba(138, 146, 166, 0.075);width:100%;margin-bottom:1rem;color:#8a92a6;vertical-align:center;border-color:lightgrey;}
        .table>:not(caption)>*>*{padding:1rem 1.5rem;background-color:var(--bs-table-bg);border-bottom-width:1px;-webkit-box-shadow:inset 0 0 0 9999px var(--bs-table-accent-bg);box-shadow:inset 0 0 0 9999px var(--bs-table-accent-bg);}
        .table>tbody{vertical-align:inherit;}
        .table-primary{--bs-table-bg:#d8ddfa;--bs-table-striped-bg:#d2d6f3;--bs-table-striped-color:#000;--bs-table-active-bg:#c2c7e1;--bs-table-active-color:#000;--bs-table-hover-bg:#c8cce7;--bs-table-hover-color:#000;color:#000;border-color:#c2c7e1;}
        .table-responsive{overflow-x:auto;-webkit-overflow-scrolling:touch;}
        .form-control{display:block;width:100%;padding:.5rem 1rem;font-size:1rem;font-weight:400;line-height:1.5;color:#8a92a6;background-color:#fff;-webkit-background-clip:padding-box;background-clip:padding-box;border:1px solid lightgrey;-webkit-appearance:none;-moz-appearance:none;appearance:none;-webkit-border-radius:.25rem;border-radius:.25rem;-webkit-box-shadow:0 0 0 0;box-shadow:0 0 0 0;-webkit-transition:border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;transition:border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;-o-transition:border-color .15s ease-in-out,box-shadow .15s ease-in-out;transition:border-color .15s ease-in-out,box-shadow .15s ease-in-out;transition:border-color .15s ease-in-out,box-shadow .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;}
        @media (prefers-reduced-motion: reduce){
        .form-control{-webkit-transition:none;-o-transition:none;transition:none;}
        }
        .form-control:focus{color:#8a92a6;background-color:#fff;border-color:#9dabf4;outline:0;-webkit-box-shadow:0 0 0 0,0 .125rem .25rem 0rem rgba(58,87,232,.15);box-shadow:0 0 0 0,0 .125rem .25rem 0rem rgba(58,87,232,.15);}
        .form-control::-webkit-input-placeholder{color:#6c757d;opacity:1;}
        .form-control::-moz-placeholder{color:#6c757d;opacity:1;}
        .form-control::-ms-input-placeholder{color:#6c757d;opacity:1;}
        .form-control::placeholder{color:#6c757d;opacity:1;}
        .form-control:disabled{background-color:#e9ecef;opacity:1;}
        .input-group{position:relative;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-align:stretch;-webkit-align-items:stretch;-ms-flex-align:stretch;align-items:stretch;width:100%;}
        .input-group>.form-control{position:relative;-webkit-box-flex:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;width:1%;min-width:0;}
        .input-group>.form-control:focus{z-index:3;}
        .input-group-text{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;padding:.5rem 1rem;font-size:1rem;font-weight:400;line-height:1.5;color:#8a92a6;text-align:center;white-space:nowrap;background-color:#fff;border:1px solid lightgrey;-webkit-border-radius:.25rem;border-radius:.25rem;}
        .input-group:not(.has-validation)>:not(:last-child):not(.dropdown-toggle):not(.dropdown-menu){-webkit-border-top-right-radius:0;border-top-right-radius:0;-webkit-border-bottom-right-radius:0;border-bottom-right-radius:0;}
        .input-group>:not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback){margin-left:-1px;-webkit-border-top-left-radius:0;border-top-left-radius:0;-webkit-border-bottom-left-radius:0;border-bottom-left-radius:0;}
        .btn{display:inline-block;font-weight:400;line-height:1.5;color:#8a92a6;text-align:center;vertical-align:middle;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;background-color:transparent;border:1px solid transparent;padding:.5rem 1.5rem;font-size:1rem;-webkit-border-radius:.25rem;border-radius:.25rem;-webkit-transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;-o-transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;}
        @media (prefers-reduced-motion: reduce){
        .btn{-webkit-transition:none;-o-transition:none;transition:none;}
        }
        .btn:hover{color:#8a92a6;}
        .btn:focus{outline:0;-webkit-box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15);box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15);}
        .btn:active{-webkit-box-shadow:0 0px 0px rgba(0,0,0,0);box-shadow:0 0px 0px rgba(0,0,0,0);}
        .btn:active:focus{-webkit-box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15),0 0px 0px rgba(0,0,0,0);box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15),0 0px 0px rgba(0,0,0,0);}
        .btn:disabled{pointer-events:none;opacity:.65;-webkit-box-shadow:none;box-shadow:none;}
        .btn-primary{color:#fff;background-color:#3a57e8;border-color:#3a57e8;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0);box-shadow:0 0px 0px 0 rgba(0,0,0,0);}
        .btn-primary:hover{color:#fff;background-color:#314ac5;border-color:#2e46ba;}
        .btn-primary:focus{color:#fff;background-color:#314ac5;border-color:#2e46ba;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);}
        .btn-primary:active{color:#fff;background-color:#2e46ba;border-color:#2c41ae;}
        .btn-primary:active:focus{-webkit-box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);}
        .btn-primary:disabled{color:#fff;background-color:#3a57e8;border-color:#3a57e8;}
        .btn-danger{color:#fff;background-color:#c03221;border-color:#c03221;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0);box-shadow:0 0px 0px 0 rgba(0,0,0,0);}
        .btn-danger:hover{color:#fff;background-color:#a32b1c;border-color:#9a281a;}
        .btn-danger:focus{color:#fff;background-color:#a32b1c;border-color:#9a281a;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);}
        .btn-danger:active{color:#fff;background-color:#9a281a;border-color:#902619;}
        .btn-danger:active:focus{-webkit-box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);}
        .btn-danger:disabled{color:#fff;background-color:#c03221;border-color:#c03221;}
        .btn-sm{padding:.25rem 1rem;font-size:0.875rem;-webkit-border-radius:.25rem;border-radius:.25rem;}
        .collapse:not(.show){display:none;}
        .dropdown{position:relative;}
        .dropdown-menu{position:absolute;z-index:1000;display:none;min-width:10rem;padding:.5rem 0;margin:0;font-size:1rem;color:#8a92a6;text-align:left;list-style:none;background-color:#fff;-webkit-background-clip:padding-box;background-clip:padding-box;border:1px solid rgba(0,0,0,0);-webkit-border-radius:.25rem;border-radius:.25rem;-webkit-box-shadow:0 10px 30px 0 rgba(17,38,146,.05);box-shadow:0 10px 30px 0 rgba(17,38,146,.05);}
        .dropdown-menu-end{--bs-position:end;}
        .dropdown-item{display:block;width:100%;padding:.25rem 1rem;clear:both;font-weight:400;color:#6c757d;text-align:inherit;white-space:nowrap;background-color:transparent;border:0;}
        .dropdown-item:hover,.dropdown-item:focus{color:#344ed1;background-color:transparent;}
        .dropdown-item:active{color:#fff;text-decoration:none;background-color:#3a57e8;}
        .dropdown-item:disabled{color:#adb5bd;pointer-events:none;background-color:transparent;}
        .nav{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;padding-left:0;margin-bottom:0;list-style:none;}
        .nav-link{display:block;padding:.5rem 1rem;color:#3a57e8;-webkit-transition:all 300ms ease-in-out;-o-transition:all 300ms ease-in-out;transition:all 300ms ease-in-out;}
        @media (prefers-reduced-motion: reduce){
        .nav-link{-webkit-transition:none;-o-transition:none;transition:none;}
        }
        .nav-link:hover,.nav-link:focus{color:#2e46ba;}
        .nav-link.disabled{color:#adb5bd;pointer-events:none;cursor:default;}
        .navbar{position:relative;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;padding-top:.5rem;padding-bottom:.5rem;}
        .navbar>.container-fluid{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:inherit;-ms-flex-wrap:inherit;flex-wrap:inherit;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;}
        .navbar-brand{padding-top:.3125rem;padding-bottom:.3125rem;margin-right:1rem;font-size:1.25rem;white-space:nowrap;}
        .navbar-nav{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;padding-left:0;margin-bottom:0;list-style:none;}
        .navbar-nav .nav-link{padding-right:0;padding-left:0;}
        .navbar-nav .dropdown-menu{position:static;}
        .navbar-collapse{-webkit-flex-basis:100%;-ms-flex-preferred-size:100%;flex-basis:100%;-webkit-box-flex:1;-webkit-flex-grow:1;-ms-flex-positive:1;flex-grow:1;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;}
        .navbar-toggler{padding:.25rem .75rem;font-size:1.25rem;line-height:1;background-color:transparent;border:1px solid transparent;-webkit-border-radius:.25rem;border-radius:.25rem;-webkit-transition:-webkit-box-shadow .15s ease-in-out;transition:-webkit-box-shadow .15s ease-in-out;-o-transition:box-shadow .15s ease-in-out;transition:box-shadow .15s ease-in-out;transition:box-shadow .15s ease-in-out, -webkit-box-shadow .15s ease-in-out;}
        @media (prefers-reduced-motion: reduce){
        .navbar-toggler{-webkit-transition:none;-o-transition:none;transition:none;}
        }
        .navbar-toggler:hover{text-decoration:none;}
        .navbar-toggler:focus{text-decoration:none;outline:0;-webkit-box-shadow:0 0 0 0rem;box-shadow:0 0 0 0rem;}
        .navbar-toggler-icon{display:inline-block;width:1.5em;height:1.5em;vertical-align:middle;background-repeat:no-repeat;background-position:center;-webkit-background-size:100% 100%;background-size:100%;}
        @media (min-width: 992px){
        .navbar-expand-lg{-webkit-flex-wrap:nowrap;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-box-pack:start;-webkit-justify-content:flex-start;-ms-flex-pack:start;justify-content:flex-start;}
        .navbar-expand-lg .navbar-nav{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;}
        .navbar-expand-lg .navbar-nav .dropdown-menu{position:absolute;}
        .navbar-expand-lg .navbar-nav .nav-link{padding-right:.5rem;padding-left:.5rem;}
        .navbar-expand-lg .navbar-collapse{display:-webkit-box!important;display:-webkit-flex!important;display:-ms-flexbox!important;display:flex!important;-webkit-flex-basis:auto;-ms-flex-preferred-size:auto;flex-basis:auto;}
        .navbar-expand-lg .navbar-toggler{display:none;}
        }
        .navbar-light .navbar-brand{color:rgba(0,0,0,.9);}
        .navbar-light .navbar-brand:hover,.navbar-light .navbar-brand:focus{color:rgba(0,0,0,.9);}
        .navbar-light .navbar-nav .nav-link{color:rgba(0,0,0,.55);}
        .navbar-light .navbar-nav .nav-link:hover,.navbar-light .navbar-nav .nav-link:focus{color:rgba(0,0,0,.7);}
        .navbar-light .navbar-toggler{color:rgba(0,0,0,.55);border-color:rgba(0,0,0,.1);}
        .navbar-light .navbar-toggler-icon{background-image:url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%280, 0, 0, 0.55%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");}
        .card{position:relative;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-orient:vertical;-webkit-box-direction:normal;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;min-width:0;word-wrap:break-word;background-color:#fff;-webkit-background-clip:border-box;background-clip:border-box;border:0 solid rgba(0,0,0,.125);-webkit-border-radius:.5rem;border-radius:.5rem;-webkit-box-shadow:0 10px 30px 0 rgba(17,38,146,.05);box-shadow:0 10px 30px 0 rgba(17,38,146,.05);}
        .card-body{-webkit-box-flex:1;-webkit-flex:1 1 auto;-ms-flex:1 1 auto;flex:1 1 auto;padding:1.5rem 1.5rem;}
        .card-title{margin-bottom:.5rem;}
        .card-header{padding:1.5rem 1.5rem;margin-bottom:0;background-color:#fff;border-bottom:0 solid rgba(0,0,0,.125);}
        .card-header:first-child{-webkit-border-radius:.5rem .5rem 0 0;border-radius:.5rem .5rem 0 0;}
        .breadcrumb{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;padding:0 0;margin-bottom:1rem;list-style:none;}
        .breadcrumb-item+.breadcrumb-item{padding-left:.5rem;}
        .breadcrumb-item+.breadcrumb-item::before{float:left;padding-right:.5rem;color:#6c757d;content:var(--bs-breadcrumb-divider, "/");}
        .breadcrumb-item.active{color:#6c757d;}
        .float-end{float:right!important;}
        .d-flex{display:-webkit-box!important;display:-webkit-flex!important;display:-ms-flexbox!important;display:flex!important;}
        .d-none{display:none!important;}
        .shadow-none{-webkit-box-shadow:none!important;box-shadow:none!important;}
        .position-relative{position:relative!important;}
        .w-100{width:100%!important;}
        .h-100{height:100%!important;}
        .flex-wrap{-webkit-flex-wrap:wrap!important;-ms-flex-wrap:wrap!important;flex-wrap:wrap!important;}
        .justify-content-start{-webkit-box-pack:start!important;-webkit-justify-content:flex-start!important;-ms-flex-pack:start!important;justify-content:flex-start!important;}
        .justify-content-between{-webkit-box-pack:justify!important;-webkit-justify-content:space-between!important;-ms-flex-pack:justify!important;justify-content:space-between!important;}
        .align-items-center{-webkit-box-align:center!important;-webkit-align-items:center!important;-ms-flex-align:center!important;align-items:center!important;}
        .m-0{margin:0!important;}
        .mt-2{margin-top:.5rem!important;}
        .mb-0{margin-bottom:0!important;}
        .mb-2{margin-bottom:.5rem!important;}
        .ms-3{margin-left:1rem!important;}
        .ms-auto{margin-left:auto!important;}
        .mt-n5{margin-top:-3rem!important;}
        .p-0{padding:0!important;}
        .p-1{padding:.25rem!important;}
        .py-0{padding-top:0!important;padding-bottom:0!important;}
        .py-3{padding-top:1rem!important;padding-bottom:1rem!important;}
        .pt-0{padding-top:0!important;}
        .fw-bold{font-weight:700!important;}
        .text-primary{--bs-text-opacity:1;color:rgba(var(--bs-primary-rgb), var(--bs-text-opacity))!important;}
        .text-white{--bs-text-opacity:1;color:rgba(var(--bs-white-rgb), var(--bs-text-opacity))!important;}
        .bg-primary{--bs-bg-opacity:1;background-color:rgba(var(--bs-primary-rgb), var(--bs-bg-opacity))!important;}
        .bg-danger{--bs-bg-opacity:1;background-color:rgba(var(--bs-danger-rgb), var(--bs-bg-opacity))!important;}
        .rounded-pill{-webkit-border-radius:50rem!important;border-radius:50rem!important;}
        @media (min-width: 768px){
        .d-md-block{display:block!important;}
        }
        @media (min-width: 992px){
        .mb-lg-0{margin-bottom:0!important;}
        }
        .card{-webkit-box-shadow:0 10px 30px 0 rgba(17,38,146,.05);box-shadow:0 10px 30px 0 rgba(17,38,146,.05);margin-bottom:2rem;}
        .card .card-header{margin-bottom:0;border:0;padding-bottom:0;}
        .card .card-header .header-title .card-title{margin-bottom:0;}
        .card-header .card-title{margin-bottom:0;}
        .dropdown .dropdown-menu{-webkit-animation-duration:400ms;animation-duration:400ms;-webkit-animation-fill-mode:both;animation-fill-mode:both;-webkit-backface-visibility:visible!important;backface-visibility:visible!important;-webkit-animation-name:dropdownAnimation;animation-name:dropdownAnimation;}
        .navbar-nav .dropdown-menu{position:absolute;}
        .btn{display:inline-block;font-weight:400;line-height:1.5;color:#8a92a6;text-align:center;vertical-align:middle;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;background-color:transparent;border:1px solid transparent;padding:.5rem 1.5rem;font-size:1rem;-webkit-border-radius:.25rem;border-radius:.25rem;-webkit-transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;-o-transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out,-webkit-box-shadow .15s ease-in-out;text-transform:capitalize;position:relative;-webkit-transition:all 300ms ease-in-out;-o-transition:all 300ms ease-in-out;transition:all 300ms ease-in-out;}
        @media (prefers-reduced-motion: reduce){
        .btn{-webkit-transition:none;-o-transition:none;transition:none;}
        }
        .btn:hover{color:#8a92a6;-webkit-transition:all 300ms ease-in-out;-o-transition:all 300ms ease-in-out;transition:all 300ms ease-in-out;}
        .btn:focus{outline:0;-webkit-box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15);box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15);}
        .btn:active{-webkit-box-shadow:0 0px 0px rgba(0,0,0,0);box-shadow:0 0px 0px rgba(0,0,0,0);}
        .btn:active:focus{-webkit-box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15),0 0px 0px rgba(0,0,0,0);box-shadow:0 .125rem .25rem 0rem rgba(58,87,232,.15),0 0px 0px rgba(0,0,0,0);}
        .btn:disabled{pointer-events:none;opacity:.65;-webkit-box-shadow:none;box-shadow:none;}
        .btn-primary{color:#fff;background-color:#3a57e8;border-color:#3a57e8;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0);box-shadow:0 0px 0px 0 rgba(0,0,0,0);}
        .btn-primary:hover{color:#fff;background-color:#314ac5;border-color:#2e46ba;}
        .btn-primary:focus{color:#fff;background-color:#314ac5;border-color:#2e46ba;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);}
        .btn-primary:active{color:#fff;background-color:#2e46ba;border-color:#2c41ae;}
        .btn-primary:active:focus{-webkit-box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(88,112,235,.5);}
        .btn-primary:disabled{color:#fff;background-color:#3a57e8;border-color:#3a57e8;}
        .btn-danger{color:#fff;background-color:#c03221;border-color:#c03221;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0);box-shadow:0 0px 0px 0 rgba(0,0,0,0);}
        .btn-danger:hover{color:#fff;background-color:#a32b1c;border-color:#9a281a;}
        .btn-danger:focus{color:#fff;background-color:#a32b1c;border-color:#9a281a;-webkit-box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);box-shadow:0 0px 0px 0 rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);}
        .btn-danger:active{color:#fff;background-color:#9a281a;border-color:#902619;}
        .btn-danger:active:focus{-webkit-box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);box-shadow:0 0px 0px rgba(0,0,0,0),0 0 0 0rem rgba(201,81,66,.5);}
        .btn-danger:disabled{color:#fff;background-color:#c03221;border-color:#c03221;}
        .btn-sm{padding:.25rem 1rem;font-size:0.875rem;-webkit-border-radius:.25rem;border-radius:.25rem;}
        .form-group{margin-bottom:1rem;}
        .table{overflow:hidden;}
        .table tbody tr td{color:#232d42;vertical-align:middle;}
        tbody,tr,td,th{white-space:nowrap;}
        .nav{background:#fff;}
        .nav .navbar-inner{padding:0 -webkit-calc(var(--bs-gutter-x, 0.75rem)*2);padding:0 calc(var(--bs-gutter-x, 0.75rem)*2);}
        .nav .search-input{width:auto;}
        .nav .search-input.input-group .input-group-text{padding-right:0;border-right:0;}
        .nav .search-input.input-group .form-control{border-left:0;}
        .nav .search-input.input-group .form-control:focus{-webkit-box-shadow:unset;box-shadow:unset;border-color:lightgrey;}
        .nav .navbar-brand{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;}
        .nav .navbar-brand .logo-title{margin-left:1rem;color:#212529;margin-bottom:0;z-index:1;}
        .nav .sidebar-toggle{height:26px;width:26px;line-height:19px;text-align:center;position:absolute;left:20px;right:auto;top:auto;cursor:pointer;background:#3a57e8;color:#fff;z-index:911;display:none;padding:.2rem;-webkit-border-radius:1rem;border-radius:1rem;-webkit-box-shadow:0 .125rem .25rem rgba(58,87,232,.1);box-shadow:0 .125rem .25rem rgba(58,87,232,.1);}
        .nav .navbar-toggler .navbar-toggler-icon{background-image:none;}
        .nav .navbar-toggler .navbar-toggler-icon .navbar-toggler-bar{display:block;position:relative;width:22px;height:1px;-webkit-border-radius:1px;border-radius:1px;background:#8a92a6;-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;margin:0 auto;}
        .nav .navbar-toggler .navbar-toggler-icon .navbar-toggler-bar.bar2{margin-top:7px;}
        .nav .navbar-toggler .navbar-toggler-icon .navbar-toggler-bar.bar3{margin-top:7px;}
        .iq-navbar{z-index:890;}
        .iq-navbar .dropdown .dropdown-menu.sub-drop{width:300px;-webkit-border-radius:.5rem;border-radius:.5rem;-webkit-animation:fade-in-bottom .6s cubic-bezier(0.39, 0.575, 0.565, 1) both;animation:fade-in-bottom .6s cubic-bezier(0.39, 0.575, 0.565, 1) both;}
        .iq-navbar .dropdown .dropdown-menu.sub-drop .iq-sub-card{cursor:pointer;padding:.75rem 1.25rem!important;display:inline-block;width:100%;color:#8a92a6;-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;}
        .iq-navbar .dropdown .dropdown-menu.sub-drop .iq-sub-card:hover{background:#ebeefd;}
        .iq-navbar .dropdown .dropdown-menu.sub-drop .iq-sub-card:not(:last-child){border-bottom:1px solid lightgrey;}
        .iq-navbar .dropdown .dropdown-menu.sub-drop .iq-sub-card:last-child{-webkit-border-bottom-left-radius:.5rem;border-bottom-left-radius:.5rem;-webkit-border-bottom-right-radius:.5rem;border-bottom-right-radius:.5rem;}
        .iq-navbar-header .iq-header-img{overflow:hidden;-webkit-border-radius:1rem;border-radius:1rem;}
        .iq-navbar-header .iq-header-img img{-o-object-fit:cover;object-fit:cover;}
        @media (max-width: 1199.98px){
        .nav .sidebar-toggle{display:block;}
        }
        @media (max-width: 991.98px){
        .iq-navbar .navbar-collapse:not(.offcanvas-collapse){position:absolute;top:100%;left:0;width:100%;-webkit-box-flex:unset;-webkit-flex-grow:unset;-ms-flex-positive:unset;flex-grow:unset;background:#fff;z-index:11;-webkit-box-shadow:0 .125rem .25rem rgba(17,38,146,.1);box-shadow:0 .125rem .25rem rgba(17,38,146,.1);-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;}
        .iq-navbar .navbar-collapse .navbar-nav.navbar-list:not(.offcanvas-collapse){-webkit-box-orient:horizontal;-webkit-box-direction:normal;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;float:right;}
        }
        @media (max-width: 575.98px){
        .iq-navbar .navbar-collapse .navbar-nav li{position:static;}
        .iq-navbar .navbar-collapse .navbar-nav li .sub-drop.dropdown-menu{margin:auto;left:0;right:0;}
        }
        .theme-color-purple-img{display:none;}
        .theme-color-pink-img{display:none;}
        .theme-color-green-img{display:none;}
        .theme-color-yellow-img{display:none;}
        .theme-color-blue-img{display:none;}
        .sidebar+.main-content .iq-navbar-header{color:#fff;}
        .sidebar+.main-content .iq-navbar-header .iq-container{padding:-webkit-calc(var(--bs-gutter-x, 0.75rem)*3);padding:calc(var(--bs-gutter-x, 0.75rem)*3);}
        .sidebar+.main-content .iq-navbar-header .iq-container h1,.sidebar+.main-content .iq-navbar-header .iq-container a{color:inherit;}
        .sidebar+.main-content .iq-navbar-header .iq-header-img{position:absolute;top:0;z-index:-1;height:264px;width:100%;-webkit-transition:all 400ms;-o-transition:all 400ms;transition:all 400ms;-webkit-transform-origin:center left;-ms-transform-origin:center left;transform-origin:center left;}
        @media (max-width: 767.98px){
        .iq-navbar-header .iq-header-img{height:310px!important;}
        .conatiner-fluid.content-inner.mt-n5{margin-top:unset!important;}
        }
        .iq-banner .iq-navbar-header{color:#fff;}
        .iq-banner .iq-navbar-header .iq-container{padding:-webkit-calc(var(--bs-gutter-x, 1rem)*2);padding:calc(var(--bs-gutter-x, 1rem)*2);}
        .iq-banner .iq-navbar-header .iq-container h1,.iq-banner .iq-navbar-header .iq-container a{color:inherit;}
        .iq-banner .iq-navbar-header .iq-header-img{height:264px;width:100%;position:absolute;top:0;z-index:-1;-webkit-transition:all 400ms;-o-transition:all 400ms;transition:all 400ms;-webkit-transform-origin:center left;-ms-transform-origin:center left;transform-origin:center left;overflow:hidden;-webkit-border-radius:1rem;border-radius:1rem;}
        .iq-banner .iq-navbar-header .iq-header-img img{-o-object-fit:cover;object-fit:cover;}
        .iq-banner:not(.hide)+.content-inner{margin-top:-3rem!important;padding-top:0;padding-bottom:0;}
        @media (max-width: 767.98px){
        .iq-navbar-header .iq-header-img{height:310px!important;}
        }
        .main-content .content-inner{min-height:-webkit-calc(100vh - 6.6rem);min-height:calc(100vh - 6.6rem);}
        .sidebar+.main-content{margin-left:16.2rem;-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;}
        @media (min-width: 1200px){
        .sidebar+.main-content .nav .navbar-brand{display:none;}
        }
        @media (max-width: 1199.98px){
        .sidebar-default+.main-content{margin-left:0;}
        .search-input{display:none;}
        }
        .sidebar{display:block;position:fixed;width:100%;max-width:16.2rem;top:0;bottom:0;z-index:910;-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;background-color:#fff;-webkit-box-shadow:0 0px 30px 0 rgba(17,38,146,.05);box-shadow:0 0px 30px 0 rgba(17,38,146,.05);}
        .sidebar .navbar-brand{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;padding:1.125rem 1rem;}
        .sidebar .navbar-brand svg{color:#3a57e8;}
        .sidebar .navbar-brand .logo-title{margin-left:1rem;color:#3a57e8;margin-bottom:0;-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;-webkit-transform:translateX(0%);-ms-transform:translateX(0%);transform:translateX(0%);opacity:1;color:#212529;}
        .sidebar .sidebar-header{border-bottom:1px solid #f1f1f1;margin-bottom:.75rem;}
        .sidebar .sidebar-body{padding:1rem;overflow:hidden;}
        .sidebar .data-scrollbar{max-height:92vh;}
        .sidebar-default .sidebar-list{display:block;position:static;}
        .sidebar-default .sidebar-list .navbar-nav .nav-item .nav-link:not(.disabled){display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;white-space:nowrap;}
        .sidebar-default .sidebar-list .navbar-nav .nav-item .nav-link:not(.disabled) span{-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;margin-left:1rem;-webkit-transform:translateX(0);-ms-transform:translateX(0);transform:translateX(0);opacity:1;}
        .sidebar-default .sidebar-list .navbar-nav .nav-item .nav-link.static-item .default-icon{font-weight:500;}
        .sidebar-default .sidebar-list .navbar-nav .nav-item .nav-link i.sidenav-mini-icon{opacity:0;display:none;}
        .sidebar-default .sidebar-body{padding:0;padding-right:.75rem;}
        .sidebar-default .navbar-nav .static-item .mini-icon{display:none;}
        .sidebar-default .navbar-nav .nav-item{-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;position:relative;margin-top:2px;}
        .sidebar-default .navbar-nav .nav-item .nav-link{text-transform:capitalize;padding:.625rem;padding-left:1rem;}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled){color:#6c757d;}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled) .right-icon{-webkit-transition:all 100ms ease-in-out;-o-transition:all 100ms ease-in-out;transition:all 100ms ease-in-out;}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled).active,.sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled)[aria-expanded=true]{background-color:#3a57e8;color:#fff;-webkit-box-shadow:0 10px 20px -10px rgba(17,38,146,.4);box-shadow:0 10px 20px -10px rgba(17,38,146,.4);}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled)[aria-expanded=true] .right-icon{-webkit-transition:all 100ms ease-in-out;-o-transition:all 100ms ease-in-out;transition:all 100ms ease-in-out;-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg);}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled):hover:not(.active):not([aria-expanded=true]){background-color:rgba(58,87,232,.1);color:#3a57e8;}
        .sidebar-default .navbar-nav .nav-item .sub-nav{list-style:none;padding:0;}
        .sidebar .sidebar-toggle{position:absolute;right:-12px;top:20px;cursor:pointer;background:#3a57e8;color:#fff;padding:.2rem;-webkit-border-radius:1rem;border-radius:1rem;-webkit-box-shadow:0 .125rem .25rem rgba(58,87,232,.1);box-shadow:0 .125rem .25rem rgba(58,87,232,.1);}
        .sidebar .sidebar-toggle:hover{-webkit-box-shadow:0 .125rem .25rem rgba(58,87,232,.15);box-shadow:0 .125rem .25rem rgba(58,87,232,.15);}
        .sidebar .sidebar-toggle .icon{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-transform:rotate(0);-ms-transform:rotate(0);transform:rotate(0);-webkit-transition:all 400ms ease;-o-transition:all 400ms ease;transition:all 400ms ease;}
        @media (max-width: 1199.98px){
        .sidebar .sidebar-toggle{right:18px;}
        }
        .navs-rounded-all .sidebar-body{padding-right:1rem;}
        .navs-rounded-all .navbar-nav .nav-item:not(.static-item){padding-left:1rem;}
        .navs-rounded-all .navbar-nav .nav-item .nav-link{padding:.625rem 1rem;}
        .navs-rounded-all .navbar-nav .nav-item .nav-link:not(.disabled){-webkit-border-radius:.25rem;border-radius:.25rem;}
        .navs-rounded-all .navbar-nav .nav-item .nav-link:not(.disabled)[aria-expanded=true]:after{-webkit-border-radius:0.5rem;border-radius:0.5rem;}
        @media (max-width: 1199.98px){
        .iq-navbar .navbar-brand{margin-left:2rem;}
        }
        @media (max-width: 991.98px){
        .iq-navbar .navbar-collapse:not(.offcanvas-collapse) .navbar-nav{-webkit-box-orient:horizontal;-webkit-box-direction:normal;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;float:right;-webkit-box-align:center;-webkit-align-items:center;-ms-flex-align:center;align-items:center;}
        .iq-navbar .navbar-collapse:not(.offcanvas-collapse) .navbar-nav li{padding:.5rem 1.5rem 0rem 0rem!important;}
        }
        .footer{font-size:14px;background:#fff;}
        .footer .footer-body{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-wrap:wrap;-ms-flex-wrap:wrap;flex-wrap:wrap;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;padding:.5rem -webkit-calc(var(--bs-gutter-x, 0.75rem)*3);padding:.5rem calc(var(--bs-gutter-x, 0.75rem)*3);}
        @media (max-width: 767.98px){
        .footer .footer-body{-webkit-box-pack:center;-webkit-justify-content:center;-ms-flex-pack:center;justify-content:center;}
        }
        .loader.simple-loader{background-color:#f5f6fa;height:100%;width:100%;position:fixed;place-content:center;overflow:hidden!important;right:0px;z-index:1250;}
        .loader.simple-loader .loader-body{-webkit-background-size:20% 20%;background-size:20%;width:100%;height:100%;position:relative;}
        .content-inner{padding:-webkit-calc(var(--bs-gutter-x, 0.75rem)*3);padding:calc(var(--bs-gutter-x, 0.75rem)*3);}
        @media (max-width: 767.98px){
        .content-inner{padding:-webkit-calc(var(--bs-gutter-x, 0.75rem)*2);padding:calc(var(--bs-gutter-x, 0.75rem)*2);}
        }
        .avatar{position:relative;}
        .avatar-40{height:40px;width:40px;min-width:40px;-webkit-border-radius:.25rem;border-radius:.25rem;}
        .avatar-50{height:50px;width:50px;min-width:50px;-webkit-border-radius:.25rem;border-radius:.25rem;}
        .avatar-rounded{-webkit-border-radius:50rem;border-radius:50rem;overflow:hidden;}
        .bg-soft-primary{color:#344ed1;background-color:rgba(58,87,232,.2)!important;}
        .animated-scaleX{-webkit-animation:animScale 45s 1s ease-in-out infinite;animation:animScale 45s 1s ease-in-out infinite;}
        .animate__animated{-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-duration:var(--animate-duration);animation-duration:var(--animate-duration);-webkit-animation-fill-mode:both;animation-fill-mode:both;}
        @media  print,(prefers-reduced-motion: reduce){
        .animate__animated{-webkit-animation-duration:1ms!important;animation-duration:1ms!important;-webkit-transition-duration:1ms!important;-o-transition-duration:1ms!important;transition-duration:1ms!important;-webkit-animation-iteration-count:1!important;animation-iteration-count:1!important;}
        .animate__animated[class*=Out]{opacity:0;}
        }
        .animate__fadeOut{-webkit-animation-name:fadeOut;animation-name:fadeOut;}
        /*! CSS Used from: http://localhost/laravel/akuntansi/public/assets/css/custom.min.css?v=1.2.0 */
        :focus{outline:none;}
        /*! CSS Used from: http://localhost/laravel/akuntansi/public/assets/css/dark.min.css */
        :focus{outline:none;}
        /*! CSS Used from: http://localhost/laravel/akuntansi/public/assets/css/customizer.min.css */
        a{color:var(--bs-primary);}
        a:hover{color:var(--bs-primary);}
        h1,h4,h5,h6{color:var(--bs-primary-shade-80);}
        body{background-color:var(--bs-body-bg);}
        .text-primary{color:var(--bs-primary)!important;}
        .bg-primary{background-color:var(--bs-primary)!important;}
        .bg-soft-primary{color:var(--bs-primary);background-color:rgba(var(--bs-primary-rgb), 0.1)!important;}
        .dropdown-item:hover,.dropdown-item:focus{color:var(--bs-primary-shade-20);}
        .dropdown-item:active{color:var(--bs-white);background-color:var(--bs-primary);}
        .btn.btn-primary{color:var(--bs-white);background-color:var(--bs-primary);border-color:var(--bs-primary);}
        .btn.btn-primary:hover{color:var(--bs-white);background-color:var(--bs-primary-shade-20);border-color:var(--bs-primary-shade-20);}
        .btn.btn-primary:focus{color:var(--bs-white);background-color:var(--bs-primary-shade-20);border-color:var(--bs-primary-shade-20);}
        .btn.btn-primary:active{color:var(--bs-white);background-color:var(--bs-primary-shade-20);border-color:var(--bs-primary-shade-20);}
        .form-control{font-size:var(--body-font-size);}
        .form-control:focus{border-color:var(--bs-primary-tint-40);}
        .nav-link{color:var(--bs-primary);}
        .nav-link:hover,.nav-link:focus{color:var(--bs-primary-shade-20);}
        .nav .sidebar-toggle{background:var(--bs-primary);}
        .iq-navbar .dropdown .dropdown-menu.sub-drop .iq-sub-card:hover{background:var(--bs-primary-tint-88);}
        .table-primary{--bs-table-bg:var(--bs-primary-tint-80);border-color:var(--bs-primary-tint-80);}
        .sidebar .sidebar-toggle{background:var(--bs-primary);}
        .sidebar .navbar-brand svg{color:var(--bs-primary);}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled).active,.sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled)[aria-expanded=true]{background-color:var(--bs-primary);-webkit-box-shadow:0 10px 20px -10px rgba(var(--bs-primary-rgb), 0.4);box-shadow:0 10px 20px -10px rgba(var(--bs-primary-rgb), 0.4);}
        .sidebar-default .navbar-nav .nav-item .nav-link:not(.disabled):hover:not(.active):not([aria-expanded=true]){background-color:var(--bs-primary-tint-88);color:var(--bs-primary);-webkit-box-shadow:none;box-shadow:none;}
        .text-primary{color:var(--bs-primary)!important;}
        .bg-primary{background-color:var(--bs-primary)!important;}
        .bg-soft-primary{color:var(--bs-primary);background-color:rgba(var(--bs-primary-rgb), 0.1)!important;}
        /*! CSS Used from: http://localhost/laravel/akuntansi/public/assets/css/rtl.min.css */
        :focus{outline:none;}
        /*! CSS Used from: Embedded ; media=all */
        @media  all{
        .fa-solid{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:var(--fa-display,inline-block);font-style:normal;font-variant:normal;line-height:1;text-rendering:auto;}
        .fa-solid{font-family:"Font Awesome 6 Free";}
        .fa-cart-plus:before{content:"\f217";}
        .fa-shop:before{content:"\f54f";}
        .fa-comment-dollar:before{content:"\f651";}
        .fa-house:before{content:"\f015";}
        .fa-file:before{content:"\f15b";}
        .fa-gears:before{content:"\f085";}
        .fa-database:before{content:"\f1c0";}
        .fa-solid{font-weight:900;}
        }
        /*! CSS Used from: Embedded */
        .indent{text-indent:30px;}
        /*! CSS Used from: Embedded */
        [data-scrollbar]{display:block;position:relative;}
        .scroll-content{display:flow-root;-webkit-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);}
        .scrollbar-track{position:absolute;opacity:0;z-index:1;background:rgba(222, 222, 222, .75);-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-transition:opacity 0.5s 0.5s ease-out;transition:opacity 0.5s 0.5s ease-out;}
        .scrollbar-track:hover{opacity:1;-webkit-transition-delay:0s;transition-delay:0s;}
        .scrollbar-track-x{bottom:0;left:0;width:100%;height:8px;}
        .scrollbar-track-y{top:0;right:0;width:8px;height:100%;}
        .scrollbar-thumb{position:absolute;top:0;left:0;width:8px;height:8px;background:rgba(0, 0, 0, .5);border-radius:4px;}
        /*! CSS Used keyframes */
        @-webkit-keyframes dropdownAnimation{from{opacity:0;}to{opacity:1;}}
        @keyframes  dropdownAnimation{from{opacity:0;}to{opacity:1;}}
        @-webkit-keyframes fade-in-bottom{0%{-webkit-transform:translateY(50px);transform:translateY(50px);-webkit-opacity:0;-moz-opacity:0;-ms-opacity:0;-o-opacity:0;opacity:0;}100%{-webkit-transform:translateY(0);transform:translateY(0);-webkit-opacity:1;-moz-opacity:1;-ms-opacity:1;-o-opacity:1;opacity:1;}}
        @keyframes  fade-in-bottom{0%{-webkit-transform:translateY(50px);transform:translateY(50px);-webkit-opacity:0;-moz-opacity:0;-ms-opacity:0;-o-opacity:0;opacity:0;}100%{-webkit-transform:translateY(0);transform:translateY(0);-webkit-opacity:1;-moz-opacity:1;-ms-opacity:1;-o-opacity:1;opacity:1;}}
        @-webkit-keyframes animScale{0%{-webkit-transform:scale(1);transform:scale(1);}50%{-webkit-transform:scale(1.175);transform:scale(1.175);}100%{-webkit-transform:scale(1);transform:scale(1);}}
        @keyframes  animScale{0%{-webkit-transform:scale(1);transform:scale(1);}50%{-webkit-transform:scale(1.175);transform:scale(1.175);}100%{-webkit-transform:scale(1);transform:scale(1);}}
        @-webkit-keyframes fadeOut{from{opacity:1;}to{opacity:0;}}
        @keyframes  fadeOut{from{opacity:1;}to{opacity:0;}}
        /*! CSS Used fontfaces */
        @font-face{font-family:"Font Awesome 6 Free";font-style:normal;font-weight:400;font-display:block;src:url(https://ka-f.fontawesome.com/releases/v6.2.0/webfonts/free-fa-regular-400.woff2) format("woff2"),url(https://ka-f.fontawesome.com/releases/v6.2.0/webfonts/free-fa-regular-400.ttf) format("truetype");}
        @font-face{font-family:"Font Awesome 6 Free";font-style:normal;font-weight:900;font-display:block;src:url(https://ka-f.fontawesome.com/releases/v6.2.0/webfonts/free-fa-solid-900.woff2) format("woff2"),url(https://ka-f.fontawesome.com/releases/v6.2.0/webfonts/free-fa-solid-900.ttf) format("truetype");}
    </style>
</head>
<body>
    <div class="row">
        <div class="col-sm-12">
           <div class="card">
              <div class="card-header d-flex justify-content-between">
                 <div class="header-title">
                    <h4 class="card-title"><?php echo e($settings['title']); ?></h4>
                  </div>
              </div>
              <div class="card-body">
                 <div class="table-responsive">
                    <table class="table" id="table">
                      <tr>
                          <th colspan="<?php if($bandingkan_periode): ?> <?php echo e($bandingkan_periode + 2); ?> <?php else: ?> 2 <?php endif; ?>"><h4><?php echo e($settings['title']); ?></h4></th>
                      </tr>
                      <tr class="table-primary text-white">
                          <th>Tanggal</th>
                          <th><?php echo e($tgl_mulai); ?> - <?php echo e($tgl_selesai); ?></th>
                          
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <th><?php echo e($periode['tgl_mulai']); ?> - <?php echo e($periode['tgl_selesai']); ?></th>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
      
                      
                      <tr class="fw-bold">
                          <td colspan="<?php if($bandingkan_periode): ?> <?php echo e($bandingkan_periode + 2); ?> <?php else: ?> 2 <?php endif; ?>">Pendapatan</td>
                      </tr>
                      <tr class="indent">
                          <td>
                              <a target="_blank" href="<?php echo e(route('akun.show', $akunPendapatan->id)); ?>"> <?php echo e($akunPendapatan->kode_akun); ?> <span style="margin-left: 2em;"> <?php echo e($akunPendapatan->nama_akun); ?> </span> </a>
                          </td>
                          <td> Rp. <?php echo e(number_format($kreditAkunPendapatan)); ?></td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td> Rp. <?php echo e(number_format($periode['kredit_akun_pendapatan'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
      
                      <tr class="indent">
                          <td>
                              <a target="_blank" href="<?php echo e(route('akun.show', $akunDiskon->id)); ?>"> <?php echo e($akunDiskon->kode_akun); ?> <span style="margin-left: 2em;"> <?php echo e($akunDiskon->nama_akun); ?> </span> </a>
                          </td>
                          <td> (Rp. <?php echo e(number_format($debetAkunDiskon)); ?>) </td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td> (Rp. <?php echo e(number_format($periode['debet_akun_diskon'])); ?>) </td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
      
                      <tr class="indent">
                          <td>Total dari Pendapatan</td>
                          <td> Rp. <?php echo e(number_format($kreditAkunPendapatan - $debetAkunDiskon)); ?></td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td> Rp. <?php echo e(number_format($periode['kredit_akun_pendapatan'] - $periode['debet_akun_diskon'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
                      
      
      
                      
                      <tr class="fw-bold">
                          <td colspan="<?php if($bandingkan_periode): ?> <?php echo e($bandingkan_periode + 2); ?> <?php else: ?> 2 <?php endif; ?>">Beban Pokok Pendapatan</td>
                      </tr>
                      <tr class="indent">
                          <td>
                              <a target="_blank" href="<?php echo e(route('akun.show', $akunHpp->id)); ?>"> <?php echo e($akunHpp->kode_akun); ?> <span style="margin-left: 2em;"> <?php echo e($akunHpp->nama_akun); ?> </span> </a>
                          </td>
                          <td> Rp. <?php echo e(number_format($debetAkunHpp)); ?></td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td> Rp. <?php echo e(number_format($periode['debet_akun_hpp'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
                      <tr class="indent">
                          <td>Total dari Beban Pokok Pendapatan</td>
                          <td> Rp. <?php echo e(number_format($debetAkunHpp)); ?></td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td> Rp. <?php echo e(number_format($periode['debet_akun_hpp'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
                      <tr class="fw-bold">
                          <td>Laba Kotor</td>
                          <td class="indent">Rp. <?php echo e(number_format($kreditAkunPendapatan - $debetAkunHpp)); ?></td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td class="indent">Rp. <?php echo e(number_format($periode['kredit_akun_pendapatan'] - $periode['debet_akun_hpp'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
                      
                      
                      
                      <tr class="fw-bold">
                          <td colspan="<?php if($bandingkan_periode): ?> <?php echo e($bandingkan_periode + 2); ?> <?php else: ?> 2 <?php endif; ?>">Beban Operasional</td>
                      </tr>
                      <tr class="indent">
                          <td>Total dari Beban Operasional</td>
                          <td>Rp. <?php echo e(number_format($debetAkunBeban)); ?></td>
                          
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td>Rp. <?php echo e(number_format($periode['debet_akun_beban'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
                      
      
                      <tr class="fw-bold">
                          <td>Laba (Rugi)</td>
                          <td class="indent">Rp. <?php echo e(number_format(($kreditAkunPendapatan - $debetAkunHpp) - $debetAkunBeban)); ?></td>
      
                          <?php $__currentLoopData = $arr_bandingkan_periode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <td class="indent">Rp. <?php echo e(number_format(($periode['kredit_akun_pendapatan'] - $periode['debet_akun_hpp']) - $periode['debet_akun_beban'])); ?></td>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tr>
      
                    </table>
                 </div>
              </div>
           </div>
        </div>
      </div>
</body>
</html><?php /**PATH /home/suemerugrup/public_html/akuntansi/resources/views/print_laporan/laba_rugi.blade.php ENDPATH**/ ?>