<?php

use App\Http\Controllers\JurnalUmumController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Hash;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

$ctrl = "\App\Http\Controllers";

Route::group(['middleware' => 'guest'], function() use($ctrl){
    Route::get('/login',$ctrl.'\LoginController@view')->name('login');
    Route::post('/login',$ctrl.'\LoginController@authenticate')->name('login.auth');
});

Route::get('tes', function(){
    return Hash::make('admin1');
});

Route::post('/logout',$ctrl.'\LoginController@logout')->name('logout');

Route::group(['middleware' => 'auth'], function() use($ctrl){

    Route::get('', [\App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');

    Route::resource('produk', \App\Http\Controllers\ProdukController::class);

    Route::get('akun/opening', [\App\Http\Controllers\AkunController::class, 'opening'])->name('akun.opening');
    Route::post('akun/opening', [\App\Http\Controllers\AkunController::class, 'openingStore'])->name('akun.openingStore');
    Route::resource('akun', \App\Http\Controllers\AkunController::class);
    Route::resource('pelanggan', \App\Http\Controllers\PelangganController::class);
    Route::resource('supplier', \App\Http\Controllers\SupplierController::class);
    Route::resource('level', \App\Http\Controllers\LevelController::class);
    Route::resource('user', \App\Http\Controllers\UserController::class);

    Route::resource('penjualan', \App\Http\Controllers\PenjualanController::class);
    Route::resource('jurnalUmum', JurnalUmumController::class);
    Route::get('penjualan/print/{id}', [\App\Http\Controllers\PenjualanController::class, 'print'])->name('penjualan.print');
    Route::post('penjualan/bayar/{id}', [\App\Http\Controllers\PenjualanController::class, 'bayar'])->name('penjualan.bayar');
    Route::post('penjualan/{id}/ubah_bayar', [\App\Http\Controllers\PenjualanController::class,'update_detail'])->name('penjualan.update_detail');
    Route::post('penjualan/{id}/ubah_uang_muka', [\App\Http\Controllers\PenjualanController::class,'update_uang_muka'])->name('penjualan.update_uang_muka');

    Route::resource('pembelian', \App\Http\Controllers\PembelianController::class);
    Route::post('pembelian/bayar/{id}', [\App\Http\Controllers\PembelianController::class, 'bayar'])->name('pembelian.bayar');
    Route::post('pembelian/{id}/ubah_bayar', [\App\Http\Controllers\PembelianController::class,'update_detail'])->name('pembelian.update_detail');
    Route::post('pembelian/{id}/ubah_uang_muka', [\App\Http\Controllers\PembelianController::class,'update_uang_muka'])->name('pembelian.update_uang_muka');

    Route::resource('pengeluaran', \App\Http\Controllers\PengeluaranController::class);
    Route::post('pengeluaran/bayar/{id}', [\App\Http\Controllers\PengeluaranController::class, 'bayar'])->name('pengeluaran.bayar');
    Route::post('pengeluaran/{id}/ubah_bayar', [\App\Http\Controllers\PengeluaranController::class,'update_detail'])->name('pengeluaran.update_detail');
    Route::post('pengeluaran/{id}/ubah_uang_muka', [\App\Http\Controllers\PengeluaranController::class,'update_uang_muka'])->name('pengeluaran.update_uang_muka');

    Route::get('laporan', [\App\Http\Controllers\LaporanController::class,'index'])->name('laporan.index');

    Route::group(['prefix' => 'laporan'], function(){
        Route::get('laba_rugi', [\App\Http\Controllers\LaporanController::class,'laba_rugi'])->name('laporan.laba_rugi.index');

        Route::get('arus_kas', [\App\Http\Controllers\LaporanController::class,'arus_kas'])->name('laporan.arus_kas.index');
    
        Route::get('neraca', [\App\Http\Controllers\LaporanController::class,'neraca'])->name('laporan.neraca.index');
    
        Route::get('perubahan_modal', [\App\Http\Controllers\LaporanController::class,'perubahan_modal'])->name('laporan.perubahan_modal.index');
    });

    Route::group(['prefix' => 'laporan-print'], function(){
        Route::get('laba_rugi', [\App\Http\Controllers\PrintLaporanController::class,'laba_rugi'])->name('print_laporan.laba_rugi');

        Route::get('arus_kas', [\App\Http\Controllers\PrintLaporanController::class,'arus_kas'])->name('print_laporan.arus_kas');
    
        Route::get('neraca', [\App\Http\Controllers\PrintLaporanController::class,'neraca'])->name('print_laporan.neraca');
    
        Route::get('perubahan_modal', [\App\Http\Controllers\PrintLaporanController::class,'perubahan_modal'])->name('print_laporan.perubahan_modal');
    });

});

