@extends('layouts.app-form')

@section('form-title')
    @if(isset($data))
        Ubah Data {{ $settings['title'] }}
    @else
        Tambah Data {{ $settings['title'] }}
    @endif
@endsection


@section('form')
    @if(isset($data))
        <input type="hidden" name="_method" value="PUT">
    @endif

    <div class="form-group">
        <label for="nama" class="label-control">Nama <span class="text-danger">*</span></label>
        <input type="text" autocomplete="off" maxlength="200" class="form-control" name="nama" id="nama" placeholder="Nama" required value="{{ old('nama',@$data->nama) }}">
        @error('nama')
            <strong class="text-danger">{{ $message }}</strong>
        @enderror
    </div>
    
    <div class="form-group">
        <label for="email" class="label-control">Email <span class="text-danger">*</span></label>
        <input type="email" autocomplete="off" maxlength="200" class="form-control" name="email" id="email" placeholder="Email" required value="{{ old('email',@$data->email) }}">
        @error('email')
            <strong class="text-danger">{{ $message }}</strong>
        @enderror
    </div>

    <div class="form-group">
        <label for="password" class="label-control">Password
        @if(isset($data))
          <span class="text-danger">*
          Kosongkan Jika Tidak Ingin Mengganti Password
        @endif    
        </span></label>
        <input type="password" autocomplete="off" maxlength="200" class="form-control" name="password" id="password" placeholder="Password">
        @error('password')
            <strong class="text-danger">{{ $message }}</strong>
        @enderror
    </div>

    <div class="form-group">
        <label for="password_confirm" class="label-control">Konfirmasi Password
        @if(isset($data))
          <span class="text-danger">*
          Kosongkan Jika Tidak Ingin Mengganti Password
        @endif    
        </span></label>
        <input type="password" autocomplete="off" maxlength="200" class="form-control" name="password_confirm" id="password_confirm" placeholder="Konfirmasi Password">
        @error('password_confirm')
            <strong class="text-danger">{{ $message }}</strong>
        @enderror
    </div>

    <div class="form-group">
        <label for="level_id" class="label-control">Jabatan <span class="text-danger">*</span></label>
        <select class="form-control select2" name="level_id" id="level_id" tabindex="-1" required>
            @foreach ($levels as $level)
            <option value="{{ $level->id }}" @if($level->id == old('level_id',@$data->level_id)) selected @endif>{{ $level->nama_level }}</option>
            @endforeach
        </select>
        @error('level_id')
            <strong class="text-danger">{{ $message }}</strong>
        @enderror
    </div>
@endsection