@extends('layouts.app-form')

@section('form-title')
    @if(isset($data))
        Ubah Data {{ $settings['title'] }}
    @else
        Tambah Data {{ $settings['title'] }}
    @endif
@endsection


@section('form')
    @if(isset($data))
        <input type="hidden" name="_method" value="PUT">
    @endif
    <div class="form-group">
      <label for="nama_produk" class="form-label">Nama Produk <span class="text-danger">*</span> </label>
      <input class="form-control" type="text" name="nama_produk" required value="{{ old('nama_produk',@$data->nama_produk) }}">
      @error('nama_produk')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>

    <div class="form-group">
      <label for="satuan" class="form-label">Satuan <span class="text-danger">*</span> </label>
      <input class="form-control" type="text" name="satuan" required value="{{ old('satuan',@$data->satuan) }}">
      @error('satuan')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>

    @if(!isset($data))
    <div class="form-group">
      <label for="stok" class="form-label">Stok Awal <span class="text-danger">*</span> </label>
      <input class="form-control" type="number" name="stok" required value="{{ old('stok') }}">
      @error('stok')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>
    @endif

    <div class="form-group">
      <label for="harga_jual" class="form-label">Harga Jual <span class="text-danger">*</span> </label>
      <input class="form-control money" type="text" name="harga_jual" required value="{{ old('harga_jual',@$data->harga_jual) }}">
      @error('harga_jual')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>

    <div class="form-group">
      <label for="harga_beli" class="form-label">Harga Beli <span class="text-danger">*</span> </label>
      <input class="form-control money" type="text" name="harga_beli" required value="{{ old('harga_beli',@$data->harga_beli) }}">
      @error('harga_beli')
        <strong class="text-danger">{{ $message }}</strong>
      @enderror
    </div>
@endsection