@extends('layouts.app-form')

@section('form-title')
    @if(isset($data))
        Ubah Data {{ $settings['title'] }}
    @else
        Tambah Data {{ $settings['title'] }}
    @endif
@endsection

@push('styles')
<style>
  .form-control{
    padding: .5rem 0.5rem !important;
  }
</style>
@endpush


@section('form')
    @if(isset($data))
        <input type="hidden" name="_method" value="PUT">
    @endif
    <div class="row">
      <input type="hidden" name="tipe_diskon" value="rp">
      <input type="hidden" name="tipe_pemotongan" value="rp">
      <div class="col-md-4">
        <div class="form-group">
          <label for="nama_produk" class="form-label">Pilih Pelanggan <span class="text-danger">*</span> </label>
          <select class="form-control select2" name="pelanggan_id" tabindex="-1" required>
            <option value="">Pilih Pelanggan</option>
            @foreach ($pelanggans as $pelanggan)
            <option value="{{ $pelanggan->id }}" @if($pelanggan->id == old('pelanggan_id',@$data->pelanggan_id)) selected @endif>{{ $pelanggan->nama_pelanggan }}</option>
            @endforeach
          </select>
          @error('pelanggan_id')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>

        <div class="form-group">
          <label for="alamat" class="form-label">Alamat</label>
          <textarea name="alamat" class="form-control" readonly>{{ old('alamat',@$data->alamat) }}</textarea>
          @error('alamat')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>
      </div>

      <div class="col-md-3">
        <div class="form-group">
          <label for="no_transaksi" class="form-label">No Transaksi <span class="text-danger">*</span> </label>
          <input class="form-control" type="text" value="{{ (@$data) ? $data->no_transaksi : \Helper::generateNoPenjualan() }}" name="no_transaksi" required>
          @error('no_transaksi')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>

        <div class="form-group">
          <label for="tgl_transaksi" class="form-label">Tgl Transkasi <span class="text-danger">*</span> </label>
          <input class="form-control" type="date" name="tgl_transaksi" id="tanggal_transaksi" required value="{{ date('Y-m-d') }}">
          @error('tgl_transaksi')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>
        <div class="form-group row">
          <label for="hari" class="form-label">
            Term of Payment
          </label>
          <div class="col-md-5 col-sm-5"><input type="number" class="form-control" name="top" id="top" placeholder="1" value="1"> </div>
          <div class="col"><p>Hari</p></div>
          
        </div>
        <div class="form-group">
          <label for="tgl_jatuh_tempo" class="form-label">Tgl Jatuh Tempo <span class="text-danger">*</span> </label>
          <input class="form-control" type="date" name="tgl_jatuh_tempo" id="tanggl_jatuh_tempo" required value="{{ date('Y-m-d') }}">
          @error('tgl_jatuh_tempo')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>
      </div>
      <div class="col-md-5">
        <div class="form-group text-end primary">
          <h3>Total <span style="color: #3a57e8" id="total_tagihan">Rp. 0</span></h3>
        </div>
      </div>
    </div>

    <div class="row mb-5">
      <div class="col-md-12">
        <table class="table" style="font-size: 11px;">
          <thead>
            <tr>
              <th width="25%">Produk<span class="text-danger">*</span></th>
              <th width="10%">Qty<span class="text-danger">*</span></th>
              <th width="10%">Satuan<span class="text-danger">*</span></th>
              <th width="13%">Harga Satuan<span class="text-danger">*</span></th>
              <th width="10%">Diskon</th>
              <th width="10%">PPN (%)</th>
              <th>Pajak Lain (%)</th>
              <th width="20%">Sub Total<span class="text-danger">*</span></th>
              <th width="2%"></th>
            </tr>
          </thead>
          <tbody id="wrapper">
            @if(isset($data))
            @foreach ($data->detail as $detail)
            <tr>
              <td>
                <select class="form-control select2" name="produk_id[]" tabindex="-1" required>
                  <option value="">Pilih Produk</option>
                  @foreach ($produks as $produk)
                  <option value="{{ $produk->id }}" @if($produk->id == $detail->produk_id) selected @endif >{{ $produk->nama_produk }}</option>
                  @endforeach
                </select>
                @error('produk_id')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="qty[]" required value="{{ $detail->qty }}">
                @error('qty')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="satuan[]" required value="{{ $detail->produk->satuan }}" readonly>
                @error('satuan')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="harga_jual[]" required value="{{ $detail->harga }}">
                @error('harga_jual')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="diskon[]" value="{{ $detail->diskon }}">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak" type="text" name="pajak[]" value="{{ $detail->pajak }}">
                @error('pajak')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak_lain" type="text" name="pajak_lain[]" value="{{ $detail->pajak_lain }}">
                @error('pajak_lain')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="jumlah[]" value="{{ $detail->sub_total }}" >
                @error('jumlah')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <a class="removeButton"><i class="fa-solid fa-minus"></i></a>
              </td>
            </tr>
            @endforeach


            @else
            <tr>
              <td>
                <select class="form-control select2" name="produk_id[]" tabindex="-1" required>
                  <option value="">Pilih Produk</option>
                  @foreach ($produks as $produk)
                  <option value="{{ $produk->id }}">{{ $produk->nama_produk }}</option>
                  @endforeach
                </select>
                @error('produk_id')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number" type="text" name="qty[]" required value="1">
                @error('qty')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="satuan[]" required readonly>
                @error('satuan')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="harga_jual[]" required>
                @error('harga_jual')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="diskon[]">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak" type="text" name="pajak[]">
                @error('pajak')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak_lain" type="text" name="pajak_lain[]">
                @error('pajak_lain')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="jumlah[]" >
                @error('jumlah')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <a class="removeButton"><i class="fa-solid fa-minus"></i></a>
              </td>
            </tr>


            @endif


          </tbody>
        </table>
        <button type="button" class="btn btn-sm btn-primary addButton"> <i class="fa-solid fa-plus"></i> Tambah Produk </button>
      </div>
    </div>

    <div class="row mb-5">
      <div class="col-md-3">
        <label for="catatan" class="form-label">Catatan </label>
        <textarea name="catatan" class="form-control">{{ old('catatan',@$data->catatan) }}</textarea>
        @error('catatan')
          <strong class="text-danger">{{ $message }}</strong>
        @enderror
      </div>
      
      <div class="offset-md-4 col-md-5">
        <div class="row">
          <table>
            <tr>
              <td>Sub Total</td>
              <td>
                <p id="sub_total"> 0 </p>
              </td>
            </tr>

            <tr>
              <td> Diskon <a class="btn btn-sm btn-primary" id="diskon_rp">Rp</a>
                <a class="btn btn-sm btn-light" id="diskon_persen">%</a> </td>
              <td>
                <p id="diskon"> 0 </p>
              </td>
            </tr>

            <tr>
              <td>Pajak</td>
              <td>
                <p id="pajak"> 0 </p>
              </td>
            </tr>

            <tr>
              <td>&nbsp;</td>
              <td>&nbsp;</td>
            </tr>
            
            <tr>
              <td>
                Pilih Akun Pemotongan
              </td>
              <td>
                <select class="form-control select2" name="akun_pemotongan" tabindex="-1">
                  <option value="">Pilih Akun Pemotongan</option>
                  @foreach ($akuns as $akun)
                  <option value="{{ $akun->id }}" @if($akun->id == old('akun_pemotongan',@$data->pemotongan_akun_id)) selected @endif>{{ $akun->nama_akun }}</option>
                  @endforeach
                </select>
              </td>
            </tr>

            <tr>
              <td>
                Pemotongan
              </td>
              <td id="pemotongan">0</td>
            </tr>

            <tr>
              <td>
                <a class="btn btn-sm btn-primary" id="pemotongan_rp">Rp</a>
                <a class="btn btn-sm btn-light" id="pemotongan_persen">%</a>
              </td>
              <td><input class="form-control money" type="text" name="pemotongan" value="{{ old('pemotongan') ?? @$data->pemotongan ?? 0 }}" maxlength="19"></td>
            </tr>

            <tr>
              <td>&nbsp;</td>
              <td>&nbsp;</td>
            </tr>

            <tr>
              <td>&nbsp;</td>
              <td>&nbsp;</td>
            </tr>

            <tr>
              <td><h5 style="color: #8A92A5">Sisa Tagihan</h5></td>
              <td>
                <h5 style="color: #8A92A5" id="sisa_tagihan"> </h5>
              </td>
            </tr>

          </table>
          
        </div>
      </div>
    </div>
    
@endsection

@push('scripts')
<script>
  $(document).ready(function(){

    let topInput = document.getElementById('top');
    let tipeDiskon = "rp";
    let tipePemotongan = "rp";
    
    top.addEventListener('change', (event)=>{
      addDate();
    });

    top.addEventListener('keyup', (event)=>{
      addDate();
    });

    function addDate()
    {
      let top = parseInt(topInput.value);
      let tanggalTransaksi = document.getElementById('tanggal_transaksi').value;
      let tanggalJatuhTempo = document.getElementById('tanggl_jatuh_tempo');

      if(top < 0 || top == null || top == 0){
        top = 0;
      }

      let tanggal = new Date(tanggalTransaksi);
      tanggal.setDate(tanggal.getDate() + top);

      tanggalJatuhTempo.valueAsDate = tanggal;


    }
    addDate();
    // Function Wrapper

    /*
    Function Convert String To Number
    */
    function toNumber(string){
      return parseInt(string.replace(/\./g, ''))
    }
    function toFloat(string){
      return parseFloat(string)
    }

    /*
    Function Format Uang
    */
    function money(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    /*
    Function Hitung Keseluruhan Produk
    */
    function hitungTotal(){
      let total = 0;
      $('input[name="jumlah[]"]').each(function(index, el) {
        total += toNumber($(this).val());
      });

      let diskon = 0;
      $('input[name="diskon[]"]').each(function(index, el) {
        if($(this).val())
          if (tipeDiskon == 'rp') {
            diskon += toNumber($(this).val());
          }else if(tipeDiskon == 'persen'){
            const harga = toNumber($(el).parent().parent().find('input[name="harga_jual[]"]').val());
            const qty = $(el).parent().parent().find('input[name="qty[]"]').val();
            const jumlah = harga*qty;
            console.log((jumlah*$(this).val()/100))
            diskon += jumlah*$(this).val()/100;
          }
      });

      let subTotal = 0;
      let pajakTtl = 0;
      $('input[name="harga_jual[]"]').each(function(index, el) {
        let harga = toNumber($(this).val());
        let qty = toFloat($(this).parent().parent().find('input[name="qty[]"]').val());
        let diskon = toNumber($(this).parent().parent().find('input[name="diskon[]"]').val());
        let pajak = toNumber($(this).parent().parent().find('input[name="pajak[]"]').val());
        let pajakLain = toNumber($(this).parent().parent().find('input[name="pajak_lain[]"]').val());

        subTotal += harga * qty;
        if(pajak){
          if(diskon){
            if (tipeDiskon == 'rp') {
              pajakTtl += (pajak) * ((harga * qty) - diskon) / 100;
            }else if(tipeDiskon == 'persen'){
              pajakTtl += (pajak) * ((harga*qty) - ((harga * qty) * diskon / 100)) / 100;
            }
          }else{
            pajakTtl += (pajak) * ((harga * qty)) / 100;
          }
        }
        if(pajakLain){
          if(diskon){
            if (tipeDiskon == 'rp') {
              pajakTtl += (pajakLain) * ((harga * qty) - diskon) / 100;
            }else if(tipeDiskon == 'persen'){
              pajakTtl += (pajakLain) * ((harga * qty) * diskon / 100) / 100;
            }
          }else{
            pajakTtl += (pajakLain) * ((harga * qty)) / 100;
          }
        }
      });
      
      // $('#total').html("Rp. " + money(total));
      $('#diskon').html("Rp. " + money(diskon));
      $('#pajak').html("Rp. " + money(pajakTtl));
      $('#sub_total').html("Rp. " + money(subTotal));

      // const uangMuka = toNumber($('input[name="uang_muka"]').val());
      // const sisaTagihan = total - (uangMuka ? uangMuka : 0);
      let inputPemotongan = toNumber($("input[name='pemotongan']").val());
      let pemotongan = 0;

      if (tipePemotongan == 'rp') {
        pemotongan = inputPemotongan;
      }else if(tipePemotongan == 'persen'){
        pemotongan = subTotal * inputPemotongan / 100;
      }

      $('#pemotongan').html("Rp. " + money(pemotongan));
      $('#sisa_tagihan').html("Rp. " + money(total - pemotongan));
      $('#total_tagihan').html("Rp. " + money(total - pemotongan));
    }

    /*
    Function Hitung Per Produk
    */
    function hitungJumlah(el){
      const harga = toNumber($(el).parent().parent().find('input[name="harga_jual[]"]').val());
      const qty = $(el).parent().parent().find('input[name="qty[]"]').val();
      const diskon = toNumber($(el).parent().parent().find('input[name="diskon[]"]').val());
      const pajak = $(el).parent().parent().find('input[name="pajak[]"]').val();
      const pajakLain = $(el).parent().parent().find('input[name="pajak_lain[]"]').val();

      let jumlah = (harga * qty);

      if(diskon){
        if (tipeDiskon == 'rp') {
          jumlah -= diskon
        }else if(tipeDiskon == 'persen'){
          jumlah -= (jumlah*diskon/100)
        }
      }

      if(pajak){
        jumlah = (jumlah) + jumlah * pajak / 100 ;
      }
      if(pajakLain){
        jumlah = (jumlah) + jumlah * pajakLain / 100;
      }
        
      $(el).parent().parent().find('input[name="jumlah[]"]').val(Math.ceil(jumlah));
      $(el).parent().parent().find('input[name="jumlah[]"]').trigger('input');

      hitungTotal();
    }

    function init(){
      $('.money').mask('000.000.000.000.000', {reverse: true});
      $('.phone').mask('0000-0000');
      $('.select2').select2();

      $('select[name="produk_id[]"]').change(function (e) { 
        const value = this.value;
        const el = $(this);
        $.ajax({
          type: "get",
          url: "{{ url('api/produk') }}/"+value,
          success: function (res) {
            const data = res.data;
            if(!data.stok){
              alert(`Stok Untuk Produk ${data.nama_produk} Habis`)
              el.val('')
            }else{
              el.parent().parent().find('input[name="satuan[]"]').val(data.satuan);
              el.parent().parent().find('input[name="harga_jual[]"]').val(data.harga_jual);
              el.parent().parent().find('input[name="harga_jual[]"]').trigger('input');
              el.parent().parent().find('input[name="qty[]"]').attr('max', data.stok);

              hitungJumlah(el);
            }
          }
        });
      });

      $('input[name="qty[]"]').keyup(function (e) { 
        const produkId = $(this).parent().parent().find('select[name="produk_id[]"]').val();
        const value = $(this);
        if(produkId){
          $.ajax({
            type: "get",
            url: "{{ url('api/produk') }}"+'/'+produkId,
            success: function (res) {
              const data = res.data;
              if(value.val()){
                if(value.val() > data.stok){
                  alert(`Stok Untuk Produk ${data.nama_produk} Tersisa ${data.stok}`)
                  value.val(data.stok)
                }
                hitungJumlah(value);
              }
            }
          });
        }
      });

      $('input[name="harga_jual[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="diskon[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="pajak[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });
      
      $('input[name="pajak_lain[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="pemotongan"]').keyup(function (e) { 
        hitungTotal(this);
      });

      // $('input[name="uang_muka"]').keyup(function (e) { 
      //   hitungTotal();
      // }); 
    }

    // End Function Wrapper

    $('aside.sidebar').addClass('sidebar-mini');

    $("#diskon_rp").click(function (e) { 
      $('input[name="tipe_diskon"]').val('rp');
      tipeDiskon = "rp";
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#diskon_persen").removeClass('btn-primary').addClass("btn-light");

      $.each($('input[name="diskon[]"]'), function (i, v) { 
         hitungJumlah(this)
      });
    });

    $("#diskon_persen").click(function (e) { 
      tipeDiskon = "persen";
      $('input[name="tipe_diskon"]').val('persen');
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#diskon_rp").removeClass('btn-primary').addClass("btn-light");

      $.each($('input[name="diskon[]"]'), function (i, v) { 
         hitungJumlah(this)
      });
    });

    $("#pemotongan_rp").click(function (e) { 
      $('input[name="tipe_pemotongan"]').val('rp');
      tipePemotongan = "rp";
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#pemotongan_persen").removeClass('btn-primary').addClass("btn-light");

      hitungTotal();
    });

    $("#pemotongan_persen").click(function (e) { 
      tipePemotongan = "persen";
      $('input[name="tipe_pemotongan"]').val('persen');
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#pemotongan_rp").removeClass('btn-primary').addClass("btn-light");

      hitungTotal();
    });

    let addButton = $('.addButton');
    let wrapper = $('#wrapper');
    let fieldHtml = `
    <tr>
        <td>
            <select class="form-control select2" name="produk_id[]" tabindex="-1" required>
              <option value="">Pilih Produk</option>
              @foreach ($produks as $produk)
              <option value="{{ $produk->id }}">{{ $produk->nama_produk }}</option>
              @endforeach
            </select>
            @error('produk_id')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control number" type="text" name="qty[]" required value="1">
            @error('qty')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control" type="text" name="satuan[]" required readonly>
            @error('satuan')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control money" type="text" name="harga_jual[]" required>
            @error('harga_jual')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control money" type="text" name="diskon[]">
            @error('diskon')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control number pajak" type="text" name="pajak[]">
            @error('pajak')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control number pajak_lain" type="text" name="pajak_lain[]">
            @error('pajak_lain')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control money" type="text" name="jumlah[]">
            @error('jumlah')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
          <a class="removeButton"><i class="fa-solid fa-minus"></i></a>
        </td>
    </tr>
    `;

    $(addButton).click(function(){
      $(wrapper).append(fieldHtml); //Add field html

      init();
    });

    $(wrapper).on('click', '.removeButton', function(e){
        e.preventDefault();
        $(this).parent().parent().remove(); //Remove field html
    });

    $('select[name="pelanggan_id"]').change(function (e) { 
      $.ajax({
        type: "get",
        url: "{{ url('api/pelanggan') }}"+"/"+$(this).val(),
        success: function (res) {
          $('textarea[name="alamat"]').val(res.data.alamat);
        }
      });
      
    });

    init();
    
    let isEditForm = "{{ @$data }}";
    if(isEditForm.length){
      hitungTotal();
    }


    let pajakInput = document.getElementsByClassName('pajak');
    let pajakLainInput = document.getElementsByClassName('pajak_lain');

    for (let index = 0; index < pajakInput.length; index++) {
      pajakInput[index].addEventListener('keyup',(event,pajakLainInput)=>{
        pajakLainInput = document.getElementsByClassName('pajak_lain');
        pajakLainInput[index].value = null;
      });
      
    }

    for (let index = 0; index < pajakLainInput.length; index++) {
      pajakLainInput[index].addEventListener('keyup',(event,pajakInput)=>{
        pajakInput = document.getElementsByClassName('pajak');
        pajakInput[index].value = null;
      });
      
    }
    
  });
</script>
@endpush