@extends('layouts.index')

@section('breadcrumb')
@include('layouts.include._breadcrumb')    
@endsection

@section('content')

<div class="row">
  <div class="col-sm-12">
     <div class="card">
        <div class="card-header d-flex justify-content-between">
           <div class="header-title">
              <h4 class="card-title">{{ $settings['title'] }}</h4>
            </div>
            @if (Helper::cek_akses($settings['title'], 'Tambah'))
               <a href="{{ route($settings['route'].'.create') }}" class="btn btn-sm btn-primary float-right">+ Tambah {{ $settings['title'] }}</a>
            @endif
        </div>
        <div class="card-body">
           <div class="table-responsive">
              <table class="table" data-toggle="data-table">
                 <thead>
                    <tr>
                       <th>No</th>
                       <th>Tanggal</th>
                       <th>Tgl Jatuh Tempo</th>
                       <th>Kode Pengeluaran</th>
                       <th>Status</th>
                       <th>Sisa Tagihan</th>
                       <th>Total Tagihan</th>
                       <th>Aksi</th>
                    </tr>
                 </thead>
                 <tbody>
                   @foreach ($datas as $data)
                   <tr>
                     <td>{{ $loop->iteration }}</td>
                     <td>{{ $data->tgl_pengeluaran }}</td>
                     <td>{{ $data->tgl_jatuh_tempo }}</td>
                     <td class="text-primary text-center">
                        <a href="{{ route($settings['route'].'.show', $data->id) }}">{{ $data->no_pengeluaran }}</a>
                     </td>
                     <td>
                        <button class="btn btn-xs btn-{{ $data->status_button }}">{{ $data->status}}</button>
                     </td>
                     <td>Rp. {{ number_format($data->sisa_tagihan) }}</td>
                     <td>Rp. {{ number_format($data->total) }}</td>
                     @include('layouts.include.basic-action')
                   </tr>
                   @endforeach
                 </tfoot>
              </table>
           </div>
        </div>
     </div>
  </div>
</div>
@endsection