@extends('layouts.app-form')

@section('form-title')
    @if(isset($data))
        Ubah Data {{ $settings['title'] }}
    @else
        Tambah Data {{ $settings['title'] }}
    @endif
@endsection

@push('styles')
<style>
  .form-control{
    padding: .5rem 0.5rem !important;
  }
</style>
@endpush


@section('form')
    @if(isset($data))
        <input type="hidden" name="_method" value="PUT">
    @endif
    <div class="row">
      <input type="hidden" name="tipe_diskon" value="rp">
      <input type="hidden" name="tipe_pemotongan" value="rp">
      <div class="col-md-4">
        <div class="form-group">
          <label for="no_pengeluaran" class="form-label">No Pengeluaran <span class="text-danger">*</span> </label>
          <input class="form-control" type="text" value="{{ (@$data) ? $data->no_pengeluaran : \Helper::generateNoPengeluaran() }}" name="no_pengeluaran" required readonly>
          @error('no_pengeluaran')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>
      </div>

      <div class="col-md-3">
        <div class="form-group">
          <label for="tgl_pengeluaran" class="form-label">Tgl Pengeluaran <span class="text-danger">*</span> </label>
          <input class="form-control" type="date" name="tgl_pengeluaran" required value="{{ date('Y-m-d') }}">
          @error('tgl_pengeluaran')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>

        <div class="form-group">
          <label for="tgl_jatuh_tempo" class="form-label">Tgl Jatuh Tempo <span class="text-danger">*</span> </label>
          <input class="form-control" type="date" name="tgl_jatuh_tempo" required value="{{ date('Y-m-d') }}">
          @error('tgl_jatuh_tempo')
            <strong class="text-danger">{{ $message }}</strong>
          @enderror
        </div>
      </div>
      <div class="col-md-5">
        <div class="form-group text-end primary">
          <h3>Total <span style="color: #3a57e8" id="total_tagihan">Rp. 0</span></h3>
        </div>
      </div>
    </div>

    <div class="row mb-5">
      <div class="col-md-12">
        <table class="table" style="font-size: 11px;">
          <thead>
            <tr>
              <th width="25%">Pengeluaran / Akun<span class="text-danger">*</span></th>
              <th width="50%">Deskripsi<span class="text-danger">*</span></th>
              <th width="20%">Biaya<span class="text-danger">*</span></th>
              <th width="20%">Diskon</th>
              <th width="10%">PPN (%)</th>
              <th>Pajak Lain (%)</th>
              <th width="20%">Sub Total<span class="text-danger">*</span></th>
            </tr>
          </thead>
          <tbody>
            @if(isset($data))
            @foreach ($data->detail as $detail)
            <tr>
              <td>
                <select class="form-control select2" name="akun_id[]" tabindex="-1" required>
                  <option value="">Pilih Akun</option>
                  @foreach ($akuns->where('kategori_akun_id', 6) as $akun)
                  <option value="{{ $akun->id }}" @if($akun->id == $detail->akun_id) selected @endif >{{ $akun->nama_akun }}</option>
                  @endforeach
                </select>
                @error('akun_id')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="desc[]" required value="{{ $detail->desc }}">
                @error('desc')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="biaya[]" value="{{ $detail->biaya }}" >
                @error('biaya')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="diskon[]" value="{{ $detail->diskon }}">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak" type="text" name="pajak[]" value="{{ $detail->pajak }}">
                @error('pajak')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak_lain" type="text" name="pajak_lain[]" value="{{ $detail->pajak_lain }}">
                @error('pajak_lain')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="jumlah[]" value="{{ $detail->sub_total }}">
                @error('jumlah')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
            </tr>
            @endforeach


            @else
            <tr>
              <td>
                <select class="form-control select2" name="akun_id[]" tabindex="-1" required>
                  <option value="">Pilih Akun</option>
                  @foreach ($akuns->where('kategori_akun_id', 6) as $akun)
                  <option value="{{ $akun->id }}">{{ $akun->nama_akun }}</option>
                  @endforeach
                </select>
                @error('akun_id')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control" type="text" name="desc[]" required>
                @error('desc')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="biaya[]" >
                @error('biaya')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="diskon[]">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak" type="text" name="pajak[]">
                @error('pajak')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak_lain" type="text" name="pajak_lain[]">
                @error('pajak_lain')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="jumlah[]">
                @error('jumlah')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
            </tr>


            @endif


          </tbody>
        </table>
        <button type="button" class="btn btn-sm btn-primary addButton"> <i class="fa-solid fa-plus"></i> Tambah Biaya </button>
      </div>
    </div>

    <div class="row mb-5">
      <div class="col-md-3">
        <label for="catatan" class="form-label">Catatan </label>
        <textarea name="catatan" class="form-control">{{ old('catatan',@$data->catatan) }}</textarea>
        @error('catatan')
          <strong class="text-danger">{{ $message }}</strong>
        @enderror
      </div>

      <div class="offset-md-5 col-md-4">
        <div class="row">
          <div class="col-md-6">
            {{-- <p> Total </p> --}}
            {{-- <p class="fw-bolder"> Uang Muka (Rp.) </p> --}}
          </div>
          <div class="col-md-6 text-end">
            {{-- <p id="total"> 0 </p> --}}
            {{-- <input style="width: 80%;" class="form-control money float-end text-end" type="text" name="uang_muka" value="{{ old('uang_muka',@$data->uang_muka) }}"> --}}
          </div>
          
          <div class="col-md-6">
            <p>
              Diskon <a class="btn btn-sm btn-primary" id="diskon_rp">Rp</a>
                <a class="btn btn-sm btn-light" id="diskon_persen">%</a> </td>
            </p>
            <p>Pajak</p>
            <p>Pilih Akun Pemotongan</p>
            <p>Pemotongan</p>
            <p><a class="btn btn-sm btn-primary" id="pemotongan_rp">Rp</a>
              <a class="btn btn-sm btn-light" id="pemotongan_persen">%</a>
            </p>
            <h5 style="color: #8A92A5">Sisa Tagihan</h5>
          </div>
          <div class="col-md-6 text-end">
            <p id="diskon"> 0 </p>
            <p id="pajak">0</p>
            <p><select class="form-control select2" name="akun_pemotongan" tabindex="-1">
              <option value="">Pilih Akun Pemotongan</option>
              @foreach ($akuns as $akun)
              <option value="{{ $akun->id }}" @if($akun->id == old('akun_pemotongan',@$data->pemotongan_akun_id)) selected @endif>{{ $akun->nama_akun }}</option>
              @endforeach
            </select>
          </p>
          <p id="pemotongan">0</p>
          <p><input class="form-control money" type="text" name="pemotongan" value="{{ old('pemotongan') ?? @$data->pemotongan ?? 0 }}" maxlength="19"></p>
            <h5 style="color: #8A92A5" id="sisa_tagihan"> - </h5>
          </div>
        </div>
      </div>
    </div>
    
@endsection

@push('scripts')
<script>
  $(document).ready(function(){
    // Function Wrapper
    let tipeDiskon = "rp";
    let tipePemotongan = "rp";
    /*
    Function Convert String To Number
    */
    function toNumber(string){
      return parseInt(string.replace(/\./g, ''))
    }

    /*
    Function Format Uang
    */
    function money(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }


    function hitungTotal(){
      let total = 0;
      $('input[name="jumlah[]"]').each(function(index, el) {
        total += toNumber($(this).val());
      });

      let diskon = 0;
      $('input[name="diskon[]"]').each(function(index, el) {
        if($(this).val())
          if (tipeDiskon == 'rp') {
            diskon += toNumber($(this).val());
          }else if(tipeDiskon == 'persen'){
            const harga = toNumber($(el).parent().parent().find('input[name="biaya[]"]').val());
            diskon += harga*$(this).val()/100;
          }
      });

      let subTotal = 0;
      let pajakTtl = 0;
      $('input[name="biaya[]"]').each(function(index, el) {
        let harga = toNumber($(this).val());
        let diskon = toNumber($(this).parent().parent().find('input[name="diskon[]"]').val());
        let pajak = toNumber($(this).parent().parent().find('input[name="pajak[]"]').val());
        let pajakLain = toNumber($(this).parent().parent().find('input[name="pajak_lain[]"]').val());

        subTotal += harga;
        if(pajak){
          if(diskon){
            if (tipeDiskon == 'rp') {
              pajakTtl += (pajak) * ((harga) - diskon) / 100;
            }else if(tipeDiskon == 'persen'){
              pajakTtl += (pajak) * ((harga) - ((harga) * diskon / 100)) / 100;
            }
          }else{
            pajakTtl += (pajak) * ((harga)) / 100;
          }
        }
        if(pajakLain){
          if(diskon){
            if (tipeDiskon == 'rp') {
              pajakTtl += (pajakLain) * ((harga) - diskon) / 100;
            }else if(tipeDiskon == 'persen'){
              pajakTtl += (pajakLain) * ((harga) * diskon / 100) / 100;
            }
          }else{
            pajakTtl += (pajakLain) * ((harga)) / 100;
          }
        }
      });
      
      // $('#total').html("Rp. " + money(total));
      $('#diskon').html("Rp. " + money(diskon));
      $('#pajak').html("Rp. " + money(pajakTtl));
      $('#sub_total').html("Rp. " + money(subTotal));

      // const uangMuka = toNumber($('input[name="uang_muka"]').val());
      // const sisaTagihan = total - (uangMuka ? uangMuka : 0);
      let inputPemotongan = toNumber($("input[name='pemotongan']").val());
      let pemotongan = 0;

      if (tipePemotongan == 'rp') {
        pemotongan = inputPemotongan;
      }else if(tipePemotongan == 'persen'){
        pemotongan = total * inputPemotongan / 100;
      }

      $('#pemotongan').html("Rp. " + money(pemotongan));
      $('#sisa_tagihan').html("Rp. " + money(total - pemotongan));
      $('#total_tagihan').html("Rp. " + money(total - pemotongan));
    }

    /*
    Function Hitung Per Produk
    */
    function hitungJumlah(el){
      const harga = toNumber($(el).parent().parent().find('input[name="biaya[]"]').val());
      const diskon = toNumber($(el).parent().parent().find('input[name="diskon[]"]').val());
      const pajak = $(el).parent().parent().find('input[name="pajak[]"]').val();
      const pajakLain = $(el).parent().parent().find('input[name="pajak_lain[]"]').val();

      let jumlah = (harga);

      if(diskon){
        if (tipeDiskon == 'rp') {
          jumlah -= diskon
        }else if(tipeDiskon == 'persen'){
          jumlah -= (jumlah*diskon/100)
        }
      }

      if(pajak){
        jumlah = (jumlah) + jumlah * pajak / 100 ;
      }
      if(pajakLain){
        jumlah = (jumlah) + jumlah * pajakLain / 100;
      }
        
      $(el).parent().parent().find('input[name="jumlah[]"]').val(Math.ceil(jumlah));
      $(el).parent().parent().find('input[name="jumlah[]"]').trigger('input');

      hitungTotal();
    }

    function init(){
      $('.money').mask('000.000.000.000.000', {reverse: true});
      $('.phone').mask('0000-0000');
      $('.select2').select2();

      $('input[name="biaya[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="diskon[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="pajak[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });
      
      $('input[name="pajak_lain[]"]').keyup(function (e) { 
        hitungJumlah(this);
      });

      $('input[name="pemotongan"]').keyup(function (e) { 
        hitungTotal(this);
      });

      // $('input[name="uang_muka"]').keyup(function (e) { 
      //   hitungTotal();
      // }); 
    }


    // End Function Wrapper

    $('aside.sidebar').addClass('sidebar-mini');

    $("#diskon_rp").click(function (e) { 
      $('input[name="tipe_diskon"]').val('rp');
      tipeDiskon = "rp";
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#diskon_persen").removeClass('btn-primary').addClass("btn-light");

      $.each($('input[name="diskon[]"]'), function (i, v) { 
        hitungJumlah(this)
      });
    });

    $("#diskon_persen").click(function (e) { 
      tipeDiskon = "persen";
      $('input[name="tipe_diskon"]').val('persen');
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#diskon_rp").removeClass('btn-primary').addClass("btn-light");

      $.each($('input[name="diskon[]"]'), function (i, v) { 
        hitungJumlah(this)
      });
    });
    $("#pemotongan_rp").click(function (e) { 
      $('input[name="tipe_pemotongan"]').val('rp');
      tipePemotongan = "rp";
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#pemotongan_persen").removeClass('btn-primary').addClass("btn-light");

      hitungTotal();
    });

    $("#pemotongan_persen").click(function (e) { 
      tipePemotongan = "persen";
      $('input[name="tipe_pemotongan"]').val('persen');
      $(this).removeClass('btn-light').addClass("btn-primary");
      $("#pemotongan_rp").removeClass('btn-primary').addClass("btn-light");

      hitungTotal();
    });

    let addButton = $('.addButton');
    let wrapper = $('tbody');
    let fieldHtml = `
    <tr>
        <td>
            <select class="form-control select2" name="akun_id[]" tabindex="-1" required>
              <option value="">Pilih Akun</option>
              @foreach ($akuns->where('kategori_akun_id', 6) as $akun)
              <option value="{{ $akun->id }}">{{ $akun->nama_akun }}</option>
              @endforeach
            </select>
            @error('akun_id')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control" type="text" name="desc[]" required>
            @error('desc')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
            <input class="form-control money" type="text" name="biaya[]">
            @error('biaya')
            <strong class="text-danger">{{ $message }}</strong>
            @enderror
        </td>
        <td>
                <input class="form-control money" type="text" name="diskon[]">
                @error('diskon')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak" type="text" name="pajak[]">
                @error('pajak')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control number pajak_lain" type="text" name="pajak_lain[]">
                @error('pajak_lain')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <input class="form-control money" type="text" name="jumlah[]" >
                @error('jumlah')
                  <strong class="text-danger">{{ $message }}</strong>
                @enderror
              </td>
              <td>
                <a class="removeButton"><i class="fa-solid fa-minus"></i></a>
              </td>
    </tr>
    `;

    $(addButton).click(function(){
      $(wrapper).append(fieldHtml); //Add field html

      init();
    });

    $(wrapper).on('click', '.removeButton', function(e){
        e.preventDefault();
        $(this).parent().parent().remove(); //Remove field html
    });

    init();
    
    let isEditForm = "{{ @$data }}";
    if(isEditForm.length){
      hitungTotal();
    }

    let pajakInput = document.getElementsByClassName('pajak');
    let pajakLainInput = document.getElementsByClassName('pajak_lain');

    for (let index = 0; index < pajakInput.length; index++) {
      pajakInput[index].addEventListener('keyup',(event,pajakLainInput)=>{
        pajakLainInput = document.getElementsByClassName('pajak_lain');
        pajakLainInput[index].value = null;
      });
      
    }

    for (let index = 0; index < pajakLainInput.length; index++) {
      pajakLainInput[index].addEventListener('keyup',(event,pajakInput)=>{
        pajakInput = document.getElementsByClassName('pajak');
        pajakInput[index].value = null;
      });
      
    }
    console.log(pajakInput.length, pajakLainInput.length)

    
  });
</script>
@endpush