@extends('layouts.index')

@section('breadcrumb')
@include('layouts.include._breadcrumb')    
@endsection

@section('content')

<div class="row">
  <div class="col-sm-12">
     <div class="card">
        <div class="card-header d-flex justify-content-between">
           <div class="header-title">
              <h4 class="card-title">{{ $settings['title'] }}</h4>
            </div>
        </div>
        <div class="card-body">
            @include('laporan.filter')
            <div class="row">
                <div class="col-md-12">
                    <a href="{{ route('print_laporan.arus_kas') }}" target="_blank" class="btn btn-sm btn-danger">Download PDF</a>
                </div>
            </div>
           <div class="table-responsive">
              <table class="table" id="table">
                <tr>
                    <th colspan="@if($bandingkan_periode) {{ $bandingkan_periode + 2 }} @else 2 @endif"><h4>{{ $settings['title'] }}</h4></th>
                </tr>
                <tr class="table-primary">
                    <th>Tanggal</th>
                    <th>{{ $tgl_mulai }} - {{ $tgl_selesai }}</th>
                    
                    @foreach ($arr_bandingkan_periode as $periode)
                    <th>{{ $periode['tgl_mulai'] }} - {{ $periode['tgl_selesai'] }}</th>
                    @endforeach
                </tr>

                {{-- Arus Kas --}}
                <tr class="fw-bold">
                    <td colspan="@if($bandingkan_periode) {{ $bandingkan_periode + 2 }} @else 2 @endif">Arus Kas dari Aktifitas Operasional</td>
                </tr>
                <tr class="indent">
                    <td> Penerimaan dari Pelanggan </td>
                    <td>Rp. {{ number_format($kreditAkunPiutang) }}</td>

                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format($periode['kredit_akun_piutang']) }}</td>
                    @endforeach
                </tr>
                <tr class="indent">
                    <td> Pembayaran ke Pemasok </td>
                    <td>Rp. {{ number_format($debetAkunPersediaan) }}</td>

                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format($periode['debet_akun_persediaan']) }}</td>
                    @endforeach
                </tr>
                <tr class="indent">
                    <td> Pengeluaran Operasional </td>
                    <td>Rp. {{ number_format($debetAkunHpp) }}</td>

                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format($periode['debet_akun_hpp']) }}</td>
                    @endforeach
                </tr>

                <tr class="fw-bold">
                    <td>Kas Bersih yang diperoleh dari Aktifitas Operasional</td>
                    <td> Rp. {{ number_format(($kreditAkunPiutang) - ($debetAkunPersediaan + $debetAkunHpp) ) }}</td>

                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format(($periode['kredit_akun_piutang']) - ($periode['debet_akun_persediaan'] + $periode['debet_akun_hpp']) ) }}</td>
                    @endforeach
                </tr>
                {{-- Akhir Arus Kas --}}


                <tr>
                    <td colspan="@if($bandingkan_periode) {{ $bandingkan_periode + 2 }} @else 2 @endif"></td>
                </tr>
                
                {{-- Rangkuman --}}
                <tr class="fw-bold">
                    <td>Kenaikan (penurunan) Kas</td>
                    <td> Rp. {{ number_format($kreditAkunPiutang - $debetAkunPersediaan - $debetAkunHpp) }}</td>

                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format($periode['kredit_akun_piutang'] - $periode['debet_akun_persediaan'] - $periode['debet_akun_hpp']) }}</td>
                    @endforeach
                </tr>
                <tr class="fw-bold">
                    <td>Saldo Kas Awal</td>
                    <td> Rp. {{ number_format($saldoKasAwal) }}</td>
                    
                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format($saldoKasAwal) }}</td>
                    @endforeach
                </tr>
                <tr class="fw-bold">
                    <td>Saldo Kas Akhir</td>
                    <td> Rp. {{ number_format( $saldoKasAwal - ($kreditAkunPiutang + $debetAkunPersediaan + $debetAkunHpp)  ) }}</td>

                    @foreach ($arr_bandingkan_periode as $periode)
                    <td> Rp. {{ number_format( $saldoKasAwal - ($periode['kredit_akun_piutang'] + $periode['debet_akun_persediaan'] + $periode['debet_akun_hpp'])  ) }}</td>
                    @endforeach
                </tr>
                {{-- Akhr iRangkuman --}}

              </table>
           </div>
        </div>
     </div>
  </div>
</div>
@endsection

@push('scripts')
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.4/moment.min.js" integrity="sha512-CryKbMe7sjSCDPl18jtJI5DR5jtkUWxPXWaLCst6QjH8wxDexfRJic2WRmRXmstr2Y8SxDDWuBO6CQC6IE4KTA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script> --}}

<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>
<script>
    // Date.prototype.GetFirstDayOfWeek = function() {
    //     return (new Date(this.setDate(this.getDate() - this.getDay()+ (this.getDay() == 0 ? -6:1) )));
    // }

    // Date.prototype.GetLastDayOfWeek = function() {
    //     return (new Date(this.setDate(this.getDate() - this.getDay() +7)));
    // }

    // function getFirstDayOfWeek(){
    //     let today = new Date();
    
    //     return today.GetFirstDayOfWeek().getFullYear() + '-' + (today.GetFirstDayOfWeek().getMonth() + 1) + '-' + today.GetFirstDayOfWeek().getDate();
    // }

    // function getLastDayOfWeek(){
    //     let today = new Date();
    
    //     return today.GetLastDayOfWeek().getFullYear() + '-' + (today.GetLastDayOfWeek().getMonth() + 1) + '-' + today.GetLastDayOfWeek().getDate();
    // }


    $(document).ready(function(){
        let tglMulai = $('#tgl_mulai');
        let tglSelesai = $('#tgl_selesai');

        $('select[name="periode"]').change(function (e) { 
            switch ($(this).val()) {
                case "hari_ini":
                    // Ambil Hari ini 
                    let today = moment().format('YYYY-MM-DD');

                    tglMulai.val(today)
                    tglSelesai.val(today)
                    break;
                
                case "minggu_ini":
                    // Ambil minggu ini
                    let weekStart = moment().startOf('week').add(1, 'days').format('YYYY-MM-DD');
                    let weekEnd = moment().endOf('week').add(1, 'days').format('YYYY-MM-DD');
                    
                    tglMulai.val(weekStart)
                    tglSelesai.val(weekEnd)
                    break;

                case "bulan_ini":

                    // Ambil Tanggal Bulan Ini
                    let startOfMonth = moment().startOf('month').format('YYYY-MM-DD');
                    let endOfMonth   = moment().endOf('month').format('YYYY-MM-DD');
                    
                    tglMulai.val(startOfMonth)
                    tglSelesai.val(endOfMonth)
                    break;

                case "tahun_ini":

                    // Ambil Tanggal Tahun Ini
                    let startOfYear = moment().startOf('year').format('YYYY-MM-DD');
                    let endOfYear   = moment().endOf('year').format('YYYY-MM-DD');
                    
                    tglMulai.val(startOfYear)
                    tglSelesai.val(endOfYear)
                    break;

                case "kemarin":
                    // Ambil Kemarin
                    let yesterday = moment().subtract(1, 'day').format('YYYY-MM-DD');
                    
                    tglMulai.val(yesterday)
                    tglSelesai.val(yesterday)
                    break;

                case "minggu_lalu":

                    // Ambil minggu lalu
                    let prevWeekStart = moment().startOf('week').add('1', 'days').subtract('1', 'week').format('YYYY-MM-DD');
                    let prevWeekEnd = moment().endOf('week').add('1', 'days').subtract('1', 'week').format('YYYY-MM-DD');
                    
                    tglMulai.val(prevWeekStart)
                    tglSelesai.val(prevWeekEnd)
                    break;

                case "bulan_lalu":

                // Ambil Tanggal Bulan Lalu
                    let prevStartOfMonth = moment().startOf('month').subtract('1', 'month').format('YYYY-MM-DD');
                    let prevEndOfMonth   = moment().endOf('month').subtract('1', 'month').format('YYYY-MM-DD');
                    
                    tglMulai.val(prevStartOfMonth)
                    tglSelesai.val(prevEndOfMonth)
                    break;

                case "tahun_lalu":

                    // Ambil Tanggal Tahun Lalu
                    let prevStartOfYear = moment().startOf('year').subtract('1', 'year').format('YYYY-MM-DD');
                    let prevEndOfYear   = moment().endOf('year').subtract('1', 'year').format('YYYY-MM-DD');
                    
                    tglMulai.val(prevStartOfYear)
                    tglSelesai.val(prevEndOfYear)
                    break;
            
                default:
                    break;
            }
            
        });
    });
</script>
@endpush
